--This file is used for the KIM authorization data that is needed for maintenance docs

--**************************************************************************************************************************************************
--*************************************************** KIM ROLES ************************************************************************************
--**************************************************************************************************************************************************

insert into KRIM_ROLE_T (role_id, role_nm, nmspc_cd, desc_txt, kim_typ_id, actv_ind, last_updt_dt, obj_id)  values ('1144', 'Manager', 'KC-SYS', 'This ROLE represents a collection of all the KC module manager roles and has permission to initiate simple maintenance documents.', (select kim_typ_id from KRIM_TYP_T where nm = 'Default' and nmspc_cd = 'KUALI'), 'Y', to_date('2010-01-28 12:00:00','YYYY-MM-DD HH24:MI:SS'), '9bd81290-4c0d-45a2-a128-8f22e5b63a51');


--**************************************************************************************************************************************************
--*************************************************** KIM PERMISSIONS (NOT TEMPLATES) AND ATTRIBUTE DATA-TO-PERMISSION *****************************
--**************************************************************************************************************************************************

insert into KRIM_PERM_T (perm_id, perm_tmpl_id, nmspc_cd, nm, desc_txt, actv_ind, obj_id)  values ('1068', (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T T WHERE T.NMSPC_CD = 'KR-WKFLW' AND T.NM = 'Administer Routing for Document'), 'KC-SYS', 'Administer Routing for Document', 'Allows users to open KC documents via the Super search option in Document Search and take Administrative workflow actions on them (such as approving the document, approving individual requests, or sending the document to a specified route node).', 'Y', '201b5fae-89f8-4bc2-8cbc-334174f78620');
insert into KRIM_PERM_T (perm_id, perm_tmpl_id, nmspc_cd, nm, desc_txt, actv_ind, obj_id)  values ('1069', (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T T WHERE T.NMSPC_CD = 'KR-WKFLW' AND T.NM = 'Blanket Approve Document'), 'KC-SYS', 'Blanket Approve Document', 'Allows access to the Blanket Approval button on KC Documents.', 'Y', '95528de6-615f-41c6-a890-dcfa68bd1e29');
insert into KRIM_PERM_T (perm_id, perm_tmpl_id, nmspc_cd, nm, desc_txt, actv_ind, obj_id)  values ('1070', (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T T WHERE T.NMSPC_CD = 'KR-SYS' AND T.NM = 'Initiate Document'), 'KC-SYS', 'Initiate Document', 'Authorizes the initiation of KC Documents.', 'Y', '6ffb673b-1a98-473d-90b6-82880d828b17');
insert into KRIM_PERM_T (perm_id, perm_tmpl_id, nmspc_cd, nm, desc_txt, actv_ind, obj_id)  values ('1071', (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T T WHERE T.NMSPC_CD = 'KR-NS' AND T.NM = 'Open Document'), 'KC-SYS', 'Open Document', 'Authorizes users to open KC Documents.', 'Y', 'c9448894-7d27-4509-83ef-25345970f88a');
insert into KRIM_PERM_T (perm_id, perm_tmpl_id, nmspc_cd, nm, desc_txt, actv_ind, obj_id)  values ('1072', (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T T WHERE T.NMSPC_CD = 'KR-WKFLW' AND T.NM = 'Save Document'), 'KC-SYS', 'Save Document', 'Authorizes user to save documents answering to the KC parent document Type.', 'Y', 'a45a7e90-6fcc-48de-9bbc-dc3958ef5afb');
insert into KRIM_PERM_T (perm_id, perm_tmpl_id, nmspc_cd, nm, desc_txt, actv_ind, obj_id)  values ('1073', (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T T WHERE T.NMSPC_CD = 'KR-NS' AND T.NM = 'Delete Note / Attachment'), 'KC-SYS', 'Delete Note / Attachment', 'Authorizes users to delete notes and attachments created by any user on documents answering to the KC parent document type.', 'Y', '0c6ae4e8-bfcf-437a-9f1a-9832ab620af0');
insert into KRIM_PERM_T (perm_id, perm_tmpl_id, nmspc_cd, nm, desc_txt, actv_ind, obj_id)  values ('1074', (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T T WHERE T.NMSPC_CD = 'KR-WKFLW' AND T.NM = 'Ad Hoc Review Document'), 'KC-SYS', 'Ad Hoc Review Document', 'Authorizes users to take the Approve action on KC documents Ad Hoc routed to them.', 'Y', '6bdf6a04-def1-48c5-a306-b95ff4959f54');
insert into KRIM_PERM_T (perm_id, perm_tmpl_id, nmspc_cd, nm, desc_txt, actv_ind, obj_id)  values ('1075', (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T T WHERE T.NMSPC_CD = 'KR-WKFLW' AND T.NM = 'Ad Hoc Review Document'), 'KC-SYS', 'Ad Hoc Review Document', 'Authorizes users to take the FYI action on KC documents Ad Hoc routed to them.', 'Y', 'f57bb444-8d49-49fd-a80d-82b7aca1b376');
insert into KRIM_PERM_T (perm_id, perm_tmpl_id, nmspc_cd, nm, desc_txt, actv_ind, obj_id)  values ('1076', (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T T WHERE T.NMSPC_CD = 'KR-WKFLW' AND T.NM = 'Ad Hoc Review Document'), 'KC-SYS', 'Ad Hoc Review Document', 'Authorizes users to take the Acknowledge action on KC documents Ad Hoc routed to them.', 'Y', '3a90ddfe-040c-490f-bb53-919a0c1cda07');
insert into KRIM_PERM_T (perm_id, perm_tmpl_id, nmspc_cd, nm, desc_txt, actv_ind, obj_id)  values ('1077', (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T T WHERE T.NMSPC_CD = 'KR-SYS' AND T.NM = 'Initiate Document'), 'KC-SYS', 'Initiate Document', 'Authorizes the initiation of KC Simple Maintenance documents.', 'Y', '58034d56-9aa2-4551-92f8-444c0822555a');
insert into KRIM_PERM_T (perm_id, perm_tmpl_id, nmspc_cd, nm, desc_txt, actv_ind, obj_id)  values ('1078', (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T T WHERE T.NMSPC_CD = 'KR-IDM' AND T.NM = 'Assign Role'), 'KC-SYS', 'Assign Role', 'Authorizes users to modify the information on the Assignees Tab of the ROLE Document and the Roles section of the Membership Tab on the Person Document for roles with a Module Code beginning with KRA.', 'Y', '1a0479e6-e7cd-4723-b2fe-3f7a38a6cb39');
insert into KRIM_PERM_T (perm_id, perm_tmpl_id, nmspc_cd, nm, desc_txt, actv_ind, obj_id)  values ('1079', (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T T WHERE T.NMSPC_CD = 'KR-IDM' AND T.NM = 'Grant Permission'), 'KC-SYS', 'Grant Permission', 'Authorizes users to modify the information on the Permissions tab of the ROLE Document for roles with a module code beginning with KRA.', 'Y', '808a60b8-78a5-4620-a9ff-27808d63ceaa');
insert into KRIM_PERM_T (perm_id, perm_tmpl_id, nmspc_cd, nm, desc_txt, actv_ind, obj_id)  values ('1080', (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T T WHERE T.NMSPC_CD = 'KR-IDM' AND T.NM = 'Grant Responsibility'), 'KC-SYS', 'Grant Responsibility', 'Authorizes users to modify the information on the Responsibility tab of the ROLE Document for roles with a Module Code that begins with KFS.', 'Y', 'd36061f4-a3cd-4ad9-aeae-30cdb116fb96');
insert into KRIM_PERM_T (perm_id, perm_tmpl_id, nmspc_cd, nm, desc_txt, actv_ind, obj_id)  values ('1081', (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T T WHERE T.NMSPC_CD = 'KR-NS' AND T.NM = 'Maintain System Parameter'), 'KC-SYS', 'Maintain System Parameter', 'Authorizes users to initiate and edit the Parameter document for pameters with a module code beginning with KFS.', 'Y', '34e46fcd-0657-4ec9-9f35-3402c8ffd919');
insert into KRIM_PERM_T (perm_id, perm_tmpl_id, nmspc_cd, nm, desc_txt, actv_ind, obj_id)  values ('1082', (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T T WHERE T.NMSPC_CD = 'KUALI' AND T.NM = 'Default'), 'KR-WKFLW', 'View Other Action List', 'Authorizes users to access other user''s action lists via the Help Desk Action List Login.', 'Y', '1096b202-aafa-474f-8e4f-dce1a291dc28');
insert into KRIM_PERM_T (perm_id, perm_tmpl_id, nmspc_cd, nm, desc_txt, actv_ind, obj_id)  values ('1083', (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T T WHERE T.NMSPC_CD = 'KUALI' AND T.NM = 'Default'), 'KR-WKFLW', 'Unrestricted Document Search', 'Allows power users to bypass the security associated with certain document types to limit the result set.', 'Y', '40cd9a70-4763-47fd-bc78-a62fd2687b4a');
insert into KRIM_PERM_T (perm_id, perm_tmpl_id, nmspc_cd, nm, desc_txt, actv_ind, obj_id)  values ('1084', (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T T WHERE T.NMSPC_CD = 'KR-WKFLW' AND T.NM = 'Blanket Approve Document'), 'KC-PD', 'Blanket Approve ProposalDevelopmentDocument', 'Blanket Approve ProposalDevelopmentDocument', 'Y', 'fd1e8164-674c-4fde-8e68-0def9c6e31c3');
insert into KRIM_PERM_T (perm_id, perm_tmpl_id, nmspc_cd, nm, desc_txt, actv_ind, obj_id)  values ('1085', (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T T WHERE T.NMSPC_CD = 'KR-WKFLW' AND T.NM = 'Blanket Approve Document'), 'KC-PROTOCOL', 'Blanket Approve ProtocolDocument', 'Blanket Approve ProtocolDocument', 'Y', '211a8648-eaa6-4b3d-98bc-4516d2a21485');
insert into KRIM_PERM_T (perm_id, perm_tmpl_id, nmspc_cd, nm, desc_txt, actv_ind, obj_id)  values ('1086', (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T T WHERE T.NMSPC_CD = 'KR-WKFLW' AND T.NM = 'Blanket Approve Document'), 'KC-PROTOCOL', 'Blanket Approve CommitteeDocument', 'Blanket Approve CommitteeDocument', 'Y', '2bb4bdca-2ee1-44aa-8178-8f81dbe4ce16');
insert into KRIM_PERM_T (perm_id, perm_tmpl_id, nmspc_cd, nm, desc_txt, actv_ind, obj_id)  values ('1087', (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T T WHERE T.NMSPC_CD = 'KR-WKFLW' AND T.NM = 'Blanket Approve Document'), 'KC-AWARD', 'Blanket Approve AwardDocument', 'Blanket Approve AwardDocument', 'Y', 'a061f523-c52a-400e-8ab8-c74a58065fc3');
insert into KRIM_PERM_T (perm_id, perm_tmpl_id, nmspc_cd, nm, desc_txt, actv_ind, obj_id)  values ('1088', (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T T WHERE T.NMSPC_CD = 'KR-WKFLW' AND T.NM = 'Blanket Approve Document'), 'KC-AWARD', 'Blanket Approve AwardBudgetDocument', 'Blanket Approve AwardBudgetDocument', 'Y', 'b88e794a-2a43-4a6d-a7d7-68e11ee40026');
insert into KRIM_PERM_T (perm_id, perm_tmpl_id, nmspc_cd, nm, desc_txt, actv_ind, obj_id)  values ('1089', (SELECT PERM_TMPL_ID FROM KRIM_PERM_TMPL_T T WHERE T.NMSPC_CD = 'KR-WKFLW' AND T.NM = 'Blanket Approve Document'), 'KC-AWARD', 'Blanket Approve TimeAndMoneyDocument', 'Blanket Approve TimeAndMoneyDocument', 'Y', '0965b734-c119-4280-bdbf-c697bb17a501');

insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values ('1110', '1068', (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Document Type (Permission)'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'documentTypeName'), 'KC', '219c39df-d4eb-4282-9442-723d28e4450f');
insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values ('1111', '1069', (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Document Type (Permission)'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'documentTypeName'), 'KC', '87a44bba-2892-41d6-8d3c-cb22e7a6cbd2');
insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values ('1112', '1070', (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Document Type (Permission)'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'documentTypeName'), 'KC', 'f7a82468-8ac9-4e66-b67b-7dd3765030c9');
insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values ('1113', '1071', (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Document Type (Permission)'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'documentTypeName'), 'KC', 'f914bb00-3055-4c70-8e6e-a66884dfd777');
insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values ('1114', '1072', (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Document Type & Routing Node or State'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'documentTypeName'), 'KC', 'e0f8292c-e6fe-4bf0-91a1-8de241bd5594'); 
insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values ('1115', '1073', (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-NS' AND NM = 'Document Type & Relationship to Note Author'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'documentTypeName'), 'KC', 'e191eac1-edf2-4d25-92e8-d8a9f4389cc2');
insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values ('1116', '1073', (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-NS' AND NM = 'Document Type & Relationship to Note Author'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-NS' AND NM = 'createdBySelfOnly'), 'false', '8ba0eb97-f0f3-4c58-84c8-4cf8bf84479c');
insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values ('1117', '1074', (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'Ad Hoc Review'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'documentTypeName'), 'KC', '26dff489-7eac-4f15-9b2d-614f38a5dbc6');
insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values ('1118', '1074', (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'Ad Hoc Review'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'actionRequestCd'), 'A', '8f9f9fbf-87f8-4e8c-b8f6-0bb34866cd6d');
insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values ('1119', '1075', (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'Ad Hoc Review'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'documentTypeName'), 'KC', '253f55b6-fbc2-4ea4-9cad-ed7785d93c82');
insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values ('1120', '1075', (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'Ad Hoc Review'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'actionRequestCd'), 'F', '779be627-9348-4adb-a809-0db0c2e04b00');
insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values ('1121', '1076', (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'Ad Hoc Review'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'documentTypeName'), 'KC', 'c0cc3858-8bcc-41a4-b29b-5584ddb1f3b5');
insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values ('1122', '1076', (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'Ad Hoc Review'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'actionRequestCd'), 'K', 'a01186f4-822e-44df-9edd-6afb4b20b6b3');
insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values ('1123', '1077', (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Document Type (Permission)'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'documentTypeName'), 'KcMaintenanceDocument', '27f25cb3-2dd4-4a67-b904-cf1aea030740');
insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values ('1124', '1078', (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-IDM' AND NM = 'Role'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-NS' AND NM = 'namespaceCode'), 'KRA*', 'e7e32567-d16c-48b8-ac8d-bb91efb82b93');
insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values ('1125', '1078', (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-IDM' AND NM = 'Role'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-NS' AND NM = 'namespaceCode'), 'KC*', 'df146277-614e-4410-a390-3c2f2b35fa2a');
insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values ('1126', '1079', (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-IDM' AND NM = 'Permission'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-NS' AND NM = 'namespaceCode'), 'KRA*', '3e5d0f01-b117-449f-b825-d11832b2a429');
insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values ('1127', '1079', (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-IDM' AND NM = 'Permission'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-NS' AND NM = 'namespaceCode'), 'KC*', '2642a7da-9566-46fc-b026-b6ed190061bc');
insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values ('1128', '1080', (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-IDM' AND NM = 'Responsibility'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-NS' AND NM = 'namespaceCode'), 'KRA*', 'e97435b8-bea2-48bf-9fe9-0e19fc32fe39');
insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values ('1129', '1080', (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-IDM' AND NM = 'Responsibility'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-NS' AND NM = 'namespaceCode'), 'KC*', '027db090-3541-4cb5-a082-22a3f6e8bd74');
insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values ('1130', '1081', (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-NS' AND NM = 'Parameter'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-NS' AND NM = 'namespaceCode'), 'KRA*', '83067d68-4fca-4ea4-8643-e1eb701b670e');
insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values ('1131', '1081', (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-NS' AND NM = 'Parameter'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-NS' AND NM = 'namespaceCode'), 'KC*', 'bdcc5676-0e56-463e-bf41-afdd32c40b32');
insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values ('1132', (SELECT PERM_ID FROM KRIM_PERM_T T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Maintain System Parameter'), (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-NS' AND NM = 'Parameter'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-NS' AND NM = 'namespaceCode'), 'KR-SYS', 'e0e6b72e-5825-4736-b97d-d2c5b16f248e');
insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values ('1133', (SELECT PERM_ID FROM KRIM_PERM_T T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Maintain System Parameter'), (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-NS' AND NM = 'Parameter'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-NS' AND NM = 'namespaceCode'), 'KR*', 'e6fe0508-d67e-4960-9a3d-fec8820d5696');
insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values ('1134', (SELECT PERM_ID FROM KRIM_PERM_T T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Full Unmask Field' AND DESC_TXT LIKE '%password field%'), (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-NS' AND NM = 'Component Field'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-NS' AND NM = 'componentName'), 'KimPrincipalImpl', 'a730a9be-0e04-4130-aec7-fdac2efddc97');
insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values ('1135', (SELECT PERM_ID FROM KRIM_PERM_T T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Full Unmask Field' AND DESC_TXT LIKE '%password field%'), (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-NS' AND NM = 'Component Field'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-NS' AND NM = 'propertyName'), 'password', '9f633457-ac9e-455b-a0dd-ac5cf96231ce');
insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values ('1136', (SELECT PERM_ID FROM KRIM_PERM_T T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Full Unmask Field' AND DESC_TXT LIKE '% Tax Identification Number%'), (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-NS' AND NM = 'Component Field'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-NS' AND NM = 'componentName'), 'IdentityManagementPersonDocument', 'b8edba5c-c13e-4923-8fe7-aff9a69ba53f');
insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values ('1137', (SELECT PERM_ID FROM KRIM_PERM_T T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Full Unmask Field' AND DESC_TXT LIKE '% Tax Identification Number%'), (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-NS' AND NM = 'Component Field'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-NS' AND NM = 'propertyName'), 'taxId', '90ad69e2-2b20-457e-8622-c10c9f826181');
insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values ('1138', (SELECT PERM_ID FROM KRIM_PERM_T T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Full Unmask Field' AND DESC_TXT LIKE '% Tax Identification Number%'), (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Document Type (Permission)'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'documentTypeName'), 'RiceDocument', 'fb0ddbb3-3a62-493d-8284-47be08e1aefd');
insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values('1142', '1087', (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Document Type (Permission)'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'documentTypeName') , 'AwardDocument', 'c5578a1e-df3c-4d3a-beda-a6b45508dd4c' );
insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values('1143', '1088', (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Document Type (Permission)'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'documentTypeName') , 'AwardBudgetDocument', 'bba233f0-f552-449d-838a-bce4a3cbb94c' );
insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values('1139', '1084', (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Document Type (Permission)'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'documentTypeName') , 'ProposalDevelopmentDocument', '6fba01d4-bd19-4aca-99cb-80f28e753da5' );
insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values('1140', '1085', (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Document Type (Permission)'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'documentTypeName') , 'ProtocolDocument', '2be14028-28a3-461c-bcc2-3e0aa975a2e6' );
insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values('1141', '1086', (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Document Type (Permission)'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'documentTypeName') , 'CommitteeDocument', '5e91816e-810c-4a8c-8877-d0ba004a53ea' );
insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values('1144', '1089', (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Document Type (Permission)'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'documentTypeName') , 'TimeAndMoneyDocument', '09bb9f4f-356d-48a4-9274-372b66ade877' );
insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values('1145', (SELECT PERM_ID FROM KRIM_PERM_T T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Ad Hoc Review Document'), (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'Ad Hoc Review'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'documentTypeName') , 'KualiDocument', '23f4c27a-7b7e-48bd-8ddc-492b909ecf46' );
insert into KRIM_PERM_ATTR_DATA_T (attr_data_id, perm_id, kim_typ_id, kim_attr_defn_id, attr_val, obj_id)  values('1146', (SELECT PERM_ID FROM KRIM_PERM_T T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Copy Document'), (SELECT KIM_TYP_ID FROM KRIM_TYP_T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Document Type (Permission)'), (SELECT KIM_ATTR_DEFN_ID FROM KRIM_ATTR_DEFN_T WHERE NMSPC_CD = 'KR-WKFLW' AND NM = 'documentTypeName') , 'KualiDocument', '2cade830-80df-49ef-a278-726860be4ead' );


--**************************************************************************************************************************************************
--*************************************************** MEMBERS(GROUPS, ROLES, PRIMCIPALS)-TO-ROLES & ATTRIBUTE DATA-TO-MEMBERS-TO-ROLES **************
--**************************************************************************************************************************************************

insert into KRIM_ROLE_MBR_T (role_mbr_id, role_id, mbr_id, mbr_typ_cd, actv_frm_dt, actv_to_dt, last_updt_dt, ver_nbr, obj_id)  values (1593, '1144', (select grp_id from KRIM_GRP_T where grp_nm = 'KcAdmin' and nmspc_cd = 'KC-WKFLW'), 'G', null, null, to_date('2010-01-28 12:00:00','YYYY-MM-DD HH24:MI:SS'), 1, 'f2ccead3-1cc4-4197-9ec8-429ea02223fd');


--**************************************************************************************************************************************************
--*************************************************** PERMISSIONS-TO-ROLES *************************************************************************
--**************************************************************************************************************************************************

insert into KRIM_ROLE_PERM_T (role_perm_id, role_id, perm_id, actv_ind, obj_id)  values ('10111', '1144', '1069', 'Y', '5d8ac5a5-dce9-4a69-a758-8f28a76c8ad0');
insert into KRIM_ROLE_PERM_T (role_perm_id, role_id, perm_id, actv_ind, obj_id)  values ('10112', '1144', '1072', 'Y', '1ee654c3-7580-4584-a8c6-b6ea73c0f90d');
insert into KRIM_ROLE_PERM_T (role_perm_id, role_id, perm_id, actv_ind, obj_id)  values ('10113', '1144', '1073', 'Y', '1ba26a83-4840-4182-9080-48f783456dea');
insert into KRIM_ROLE_PERM_T (role_perm_id, role_id, perm_id, actv_ind, obj_id)  values ('10114', '1144', '1077', 'Y', 'd9cd8b6e-95f6-478d-b9ed-a9b0762204c6');
insert into KRIM_ROLE_PERM_T (role_perm_id, role_id, perm_id, actv_ind, obj_id)  values ('10115', '1144', '1078', 'Y', '2cec29e4-f865-41fd-a4bf-587fb2eec628');
insert into KRIM_ROLE_PERM_T (role_perm_id, role_id, perm_id, actv_ind, obj_id)  values ('10116', '1144', '1079', 'Y', '43a08b1a-59cf-4f99-a837-9c43345b6579');
insert into KRIM_ROLE_PERM_T (role_perm_id, role_id, perm_id, actv_ind, obj_id)  values ('10117', '1144', '1080', 'Y', 'f294fe25-bd31-4e5c-98d5-66c50b98435d');
insert into KRIM_ROLE_PERM_T (role_perm_id, role_id, perm_id, actv_ind, obj_id)  values ('10118', '1144', '1081', 'Y', 'e5ea07be-d2f4-4b45-abf5-92c0dbf65081');
insert into KRIM_ROLE_PERM_T (role_perm_id, role_id, perm_id, actv_ind, obj_id)  values ('10119', '1144', (SELECT PERM_ID FROM KRIM_PERM_T T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Maintain System Parameter'), 'Y', '3d1d40e3-eb77-4e95-9eca-9c56a2524305');
insert into KRIM_ROLE_PERM_T (role_perm_id, role_id, perm_id, actv_ind, obj_id)  values ('10120', '1144', (SELECT PERM_ID FROM KRIM_PERM_T T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Full Unmask Field' AND DESC_TXT LIKE '%password field%'), 'Y', '8d606434-ab8a-408f-9a3a-a9b31136c9ca');
insert into KRIM_ROLE_PERM_T (role_perm_id, role_id, perm_id, actv_ind, obj_id)  values ('10121', '1144', '1082', 'Y', '95bacf60-e9b1-474d-9bc5-f8f78d26cb60');
insert into KRIM_ROLE_PERM_T (role_perm_id, role_id, perm_id, actv_ind, obj_id)  values ('10122', '1144', '1083', 'Y', 'fadf4e2a-1993-4ac9-b04e-a8f1f687bfc2');
insert into KRIM_ROLE_PERM_T (role_perm_id, role_id, perm_id, actv_ind, obj_id)  values ('10123', '1144', (SELECT PERM_ID FROM KRIM_PERM_T T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Full Unmask Field' AND DESC_TXT LIKE '% Tax Identification Number%'), 'Y', '9e333ac7-086b-4fb9-b601-1ac6359287ac');
insert into KRIM_ROLE_PERM_T (role_perm_id, role_id, perm_id, actv_ind, obj_id)  values ('10124', '1144', (SELECT PERM_ID FROM KRIM_PERM_T T WHERE NMSPC_CD = 'KR-SYS' AND NM = 'Initiate Document'), 'Y', '76bf0b85-3bcf-41ad-bdc3-fd6081fd6ad6');
