/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.authorization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.doctype.service.impl.KimDocumentTypeAuthorizer;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

public abstract class KcWorkflowDocumentAuthorizer
extends KimDocumentTypeAuthorizer {
    protected static final Log LOG = LogFactory.getLog(KcWorkflowDocumentAuthorizer.class);
    private transient DocumentService documentService;
    private transient BusinessObjectService businessObjectService;

    public boolean canRecall(String principalId, DocumentRouteHeaderValue document) {
        this.validatePrincipalId(principalId);
        this.validateDocument(document);
        String documentId = document.getDocumentId();
        DocumentType documentType = document.getDocumentType();
        String documentStatus = document.getDocRouteStatus();
        String appDocStatus = document.getAppDocStatus();
        List routeNodeNames = document.getCurrentNodeNames();
        this.validateDocumentType(documentType);
        this.validateDocumentStatus(documentStatus);
        List permissionDetailList = this.buildDocumentTypePermissionDetailsForNodes(documentType, (Collection)routeNodeNames, documentStatus, null);
        if (!StringUtils.isBlank((String)appDocStatus)) {
            for (Map details : permissionDetailList) {
                details.put("appDocStatus", appDocStatus);
            }
        }
        for (Map permissionDetails : permissionDetailList) {
            if (!this.useKimPermission("KR-WKFLW", "Recall Document", permissionDetails, false) || !this.getPermissionService().isPermissionDefinedByTemplate("KR-WKFLW", "Recall Document", permissionDetails)) continue;
            List qualifierList = this.getSetsOfRoleQualifiers(document, (String)permissionDetails.get("routeNodeName"));
            for (Map roleQualifiers : qualifierList) {
                if (!this.getPermissionService().isAuthorizedByTemplate(principalId, "KR-WKFLW", "Recall Document", permissionDetails, roleQualifiers)) continue;
                return true;
            }
        }
        return false;
    }

    protected List<Map<String, String>> getSetsOfRoleQualifiers(DocumentRouteHeaderValue document, String routeNodeName) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        Map defaultQualifications = this.buildDocumentRoleQualifiers(document, routeNodeName);
        result.add(defaultQualifications);
        Permissionable permissionable = this.getPermissionable(document.getDocumentId());
        if (permissionable != null) {
            HashMap<String, String> docNbrQualifiers = new HashMap<String, String>();
            docNbrQualifiers.put(permissionable.getDocumentKey(), permissionable.getDocumentNumberForPermission());
            docNbrQualifiers.putAll(defaultQualifications);
            result.add(docNbrQualifiers);
            HashMap<String, String> unitNumberQualifiers = new HashMap<String, String>();
            unitNumberQualifiers.put("unitNumber", permissionable.getLeadUnitNumber());
            unitNumberQualifiers.putAll(defaultQualifications);
            result.add(unitNumberQualifiers);
        }
        return result;
    }

    protected abstract Permissionable getPermissionable(String var1);

    public DocumentService getDocumentService() {
        if (this.documentService == null) {
            this.documentService = (DocumentService)KraServiceLocator.getService(DocumentService.class);
        }
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public BusinessObjectService getBusinessObjectService() {
        if (this.businessObjectService == null) {
            this.businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        }
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

