/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;

public class AwardBudgetLimitsAuditRule
implements DocumentAuditRule {
    protected String AWARD_BUDGET_LIMITS_AUDIT_ERRORS = "awardBudgetLimitAuditErrors";

    public boolean processRunAuditBusinessRules(Document document) {
        boolean result = true;
        Award award = ((AwardDocument)document).getAward();
        ArrayList<AuditError> auditWarnings = new ArrayList<AuditError>();
        if (award.getTotalCostBudgetLimit() != null && !award.getTotalCostBudgetLimit().equals((Object)award.getObligatedDistributableTotal())) {
            result = false;
            auditWarnings.add(new AuditError("document.award.totalCostBudgetLimit.limit", "warning.awardbudget.limitNotEqual.obligated", "budgets.BudgetLimits", new String[]{award.getAwardNumber()}));
        }
        this.reportAndCreateAuditCluster(auditWarnings);
        return result;
    }

    protected void reportAndCreateAuditCluster(List<AuditError> auditErrors) {
        if (auditErrors.size() > 0) {
            KNSGlobalVariables.getAuditErrorMap().put(this.AWARD_BUDGET_LIMITS_AUDIT_ERRORS, new AuditCluster("Budget Limits", auditErrors, "Warnings"));
        }
    }
}

