/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.award.AwardBudgetLimitsAuditRule;
import org.kuali.kra.award.AwardDateRulesHelper;
import org.kuali.kra.award.AwardPaymentAndInvoicesAuditRule;
import org.kuali.kra.award.AwardReportAuditRule;
import org.kuali.kra.award.AwardSubawardAuditRule;
import org.kuali.kra.award.AwardSyncAuditRule;
import org.kuali.kra.award.AwardTemplateSyncEvent;
import org.kuali.kra.award.AwardTemplateSyncRule;
import org.kuali.kra.award.AwardTemplateSyncRuleImpl;
import org.kuali.kra.award.AwardTermsAuditRule;
import org.kuali.kra.award.commitments.AddAwardFandaRateEvent;
import org.kuali.kra.award.commitments.AddFandaRateRule;
import org.kuali.kra.award.commitments.AwardBenefitsRatesRuleEvent;
import org.kuali.kra.award.commitments.AwardBenefitsRatesRuleImpl;
import org.kuali.kra.award.commitments.AwardCostShare;
import org.kuali.kra.award.commitments.AwardCostShareAuditRule;
import org.kuali.kra.award.commitments.AwardCostShareRuleEvent;
import org.kuali.kra.award.commitments.AwardCostShareRuleImpl;
import org.kuali.kra.award.commitments.AwardFandARateAuditRule;
import org.kuali.kra.award.commitments.AwardFandaRateRule;
import org.kuali.kra.award.commitments.AwardFandaRateSaveEvent;
import org.kuali.kra.award.commitments.AwardFandaRateSaveRule;
import org.kuali.kra.award.contacts.AwardPersonCreditSplitAuditRule;
import org.kuali.kra.award.contacts.AwardProjectPersonsAuditRule;
import org.kuali.kra.award.contacts.AwardProjectPersonsSaveRule;
import org.kuali.kra.award.contacts.AwardProjectPersonsSaveRuleImpl;
import org.kuali.kra.award.contacts.AwardSponsorContactAuditRule;
import org.kuali.kra.award.contacts.SaveAwardProjectPersonsRuleEvent;
import org.kuali.kra.award.detailsdates.AddAwardTransferringSponsorEvent;
import org.kuali.kra.award.detailsdates.AwardDetailsAndDatesRule;
import org.kuali.kra.award.detailsdates.AwardDetailsAndDatesRuleImpl;
import org.kuali.kra.award.detailsdates.AwardDetailsAndDatesSaveEvent;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.home.approvedsubawards.AwardApprovedSubaward;
import org.kuali.kra.award.home.approvedsubawards.AwardApprovedSubawardRuleEvent;
import org.kuali.kra.award.home.approvedsubawards.AwardApprovedSubawardRuleImpl;
import org.kuali.kra.award.home.keywords.AwardScienceKeyword;
import org.kuali.kra.award.lookup.keyvalue.FrequencyBaseCodeValuesFinder;
import org.kuali.kra.award.lookup.keyvalue.FrequencyCodeValuesFinder;
import org.kuali.kra.award.lookup.keyvalue.ReportCodeValuesFinder;
import org.kuali.kra.award.paymentreports.awardreports.AddAwardReportTermRecipientRuleEvent;
import org.kuali.kra.award.paymentreports.awardreports.AddAwardReportTermRuleEvent;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTerm;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTermRecipient;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTermRecipientRule;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTermRecipientRuleEvent;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTermRecipientRuleImpl;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTermRule;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTermRuleEvent;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTermRuleImpl;
import org.kuali.kra.award.paymentreports.closeout.AddAwardCloseoutRuleEvent;
import org.kuali.kra.award.paymentreports.closeout.AwardCloseoutRule;
import org.kuali.kra.award.paymentreports.closeout.AwardCloseoutRuleEvent;
import org.kuali.kra.award.paymentreports.closeout.AwardCloseoutRuleImpl;
import org.kuali.kra.award.paymentreports.paymentschedule.AddAwardPaymentScheduleRuleEvent;
import org.kuali.kra.award.paymentreports.paymentschedule.AwardPaymentScheduleRule;
import org.kuali.kra.award.paymentreports.paymentschedule.AwardPaymentScheduleRuleEvent;
import org.kuali.kra.award.paymentreports.paymentschedule.AwardPaymentScheduleRuleImpl;
import org.kuali.kra.award.paymentreports.specialapproval.approvedequipment.AwardApprovedEquipment;
import org.kuali.kra.award.paymentreports.specialapproval.approvedequipment.AwardApprovedEquipmentRule;
import org.kuali.kra.award.paymentreports.specialapproval.approvedequipment.AwardApprovedEquipmentRuleEvent;
import org.kuali.kra.award.paymentreports.specialapproval.approvedequipment.AwardApprovedEquipmentRuleImpl;
import org.kuali.kra.award.paymentreports.specialapproval.approvedequipment.EquipmentCapitalizationMinimumLoader;
import org.kuali.kra.award.paymentreports.specialapproval.foreigntravel.AwardApprovedForeignTravel;
import org.kuali.kra.award.paymentreports.specialapproval.foreigntravel.AwardApprovedForeignTravelRule;
import org.kuali.kra.award.paymentreports.specialapproval.foreigntravel.AwardApprovedForeignTravelRuleEvent;
import org.kuali.kra.award.paymentreports.specialapproval.foreigntravel.AwardApprovedForeignTravelRuleImpl;
import org.kuali.kra.award.permissions.AwardPermissionsRule;
import org.kuali.kra.award.rule.AddAwardAttachmentRule;
import org.kuali.kra.award.rule.AwardCommentsRule;
import org.kuali.kra.award.rule.AwardCommentsRuleImpl;
import org.kuali.kra.award.rule.event.AddAwardAttachmentEvent;
import org.kuali.kra.award.rule.event.AwardCommentsRuleEvent;
import org.kuali.kra.common.permissions.bo.PermissionsUser;
import org.kuali.kra.common.permissions.bo.PermissionsUserEditRoles;
import org.kuali.kra.common.permissions.rule.PermissionsRule;
import org.kuali.kra.common.permissions.web.bean.User;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.rule.BusinessRuleInterface;
import org.kuali.kra.rule.event.KraDocumentEventBaseExtension;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.kra.service.SponsorService;
import org.kuali.kra.timeandmoney.TimeAndMoneyForm;
import org.kuali.kra.timeandmoney.rule.event.TimeAndMoneyAwardDateSaveEvent;
import org.kuali.kra.timeandmoney.rules.TimeAndMoneyAwardDateSaveRuleImpl;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class AwardDocumentRule
extends ResearchDocumentRuleBase
implements AwardPaymentScheduleRule,
AwardApprovedEquipmentRule,
AwardApprovedForeignTravelRule,
AddFandaRateRule,
AwardFandaRateSaveRule,
AwardDetailsAndDatesRule,
AwardProjectPersonsSaveRule,
PermissionsRule,
AwardReportTermRule,
AwardReportTermRecipientRule,
AwardCloseoutRule,
AwardTemplateSyncRule,
AwardCommentsRule,
BusinessRuleInterface,
AddAwardAttachmentRule,
DocumentAuditRule {
    public static final String DOCUMENT_ERROR_PATH = "document";
    public static final String AWARD_ERROR_PATH = "awardList[0]";
    public static final boolean VALIDATION_REQUIRED = true;
    public static final boolean CHOMP_LAST_LETTER_S_FROM_COLLECTION_NAME = false;
    private static final String AWARD_REPORT_TERMS = "awardReportTerms";
    private static final String AWARD_REPORT_TERM_ITEMS = "awardReportTermItems";
    private static final String AWARD_ERROR_PATH_PREFIX = "document.awardList[0].";
    private static final Log LOG = LogFactory.getLog(AwardDocumentRule.class);
    private List<AuditError> auditErrors = new ArrayList();
    private List<AuditError> auditWarnings = new ArrayList();

    public boolean processAwardApprovedEquipmentBusinessRules(AwardApprovedEquipmentRuleEvent event) {
        return this.processApprovedEquipmentBusinessRules(GlobalVariables.getMessageMap(), event.getAwardDocument());
    }

    public boolean processAwardApprovedForeignTravelBusinessRules(AwardApprovedForeignTravelRuleEvent event) {
        return this.processApprovedForeignTravelBusinessRules(GlobalVariables.getMessageMap(), event.getAwardDocument());
    }

    public boolean processAwardPaymentScheduleBusinessRules(AwardPaymentScheduleRuleEvent event) {
        return this.processPaymentScheduleBusinessRules(GlobalVariables.getMessageMap(), event.getAwardDocument());
    }

    public boolean processAddAwardPaymentScheduleBusinessRules(AddAwardPaymentScheduleRuleEvent event) {
        return this.processAddPaymentScheduleBusinessRules(GlobalVariables.getMessageMap(), event);
    }

    public boolean processAddAwardTransferringSponsorEvent(AddAwardTransferringSponsorEvent addAwardTransferringSponsorEvent) {
        return new AwardDetailsAndDatesRuleImpl().processAddAwardTransferringSponsorEvent(addAwardTransferringSponsorEvent);
    }

    public boolean processAddAwardCloseoutBusinessRules(AddAwardCloseoutRuleEvent addAwardCloseoutRuleEvent) {
        return new AwardCloseoutRuleImpl().processAddAwardCloseoutBusinessRules(addAwardCloseoutRuleEvent);
    }

    public boolean processAwardCloseoutBusinessRules(AwardCloseoutRuleEvent awardCloseoutRuleEvent) {
        return new AwardCloseoutRuleImpl().processAwardCloseoutBusinessRules(awardCloseoutRuleEvent);
    }

    public boolean processSaveAwardProjectPersonsBusinessRules(SaveAwardProjectPersonsRuleEvent event) {
        return this.processSaveAwardProjectPersonsBusinessRules(GlobalVariables.getMessageMap(), (AwardDocument)event.getDocument());
    }

    protected boolean processCustomRouteDocumentBusinessRules(Document document) {
        return super.processCustomRouteDocumentBusinessRules(document);
    }

    public boolean processAddPermissionsUserBusinessRules(Document document, List<User> users, PermissionsUser newUser) {
        return new AwardPermissionsRule().processAddPermissionsUserBusinessRules(document, users, newUser);
    }

    public boolean processDeletePermissionsUserBusinessRules(Document document, List<User> users, int index) {
        return new AwardPermissionsRule().processDeletePermissionsUserBusinessRules(document, users, index);
    }

    public boolean processEditPermissionsUserRolesBusinessRules(Document document, List<User> users, PermissionsUserEditRoles editRoles) {
        return new AwardPermissionsRule().processEditPermissionsUserRolesBusinessRules(document, users, editRoles);
    }

    public boolean processSaveAwardDetailsAndDates(AwardDetailsAndDatesSaveEvent awardDetailsAndDatesSaveEvent) {
        return new AwardDetailsAndDatesRuleImpl().processSaveAwardDetailsAndDates(awardDetailsAndDatesSaveEvent);
    }

    protected boolean processCustomSaveDocumentBusinessRules(Document document) {
        if (this.skipRuleProcessing(document)) {
            return true;
        }
        boolean retval = true;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        if (!(document instanceof AwardDocument)) {
            return false;
        }
        errorMap.addToErrorPath(DOCUMENT_ERROR_PATH);
        this.getKnsDictionaryValidationService().validateDocumentAndUpdatableReferencesRecursively(document, this.getMaxDictionaryValidationDepth(), true, false);
        errorMap.removeFromErrorPath(DOCUMENT_ERROR_PATH);
        AwardDocument awardDocument = (AwardDocument)document;
        retval &= this.processUnitNumberBusinessRule(errorMap, awardDocument);
        retval &= this.processCostShareBusinessRules(document);
        retval &= this.processBenefitsRatesBusinessRules(document);
        retval &= this.processApprovedSubawardBusinessRules(document);
        retval &= this.processApprovedEquipmentBusinessRules(errorMap, awardDocument);
        retval &= this.processApprovedForeignTravelBusinessRules(errorMap, awardDocument);
        retval &= this.processSaveAwardProjectPersonsBusinessRules(errorMap, awardDocument);
        retval &= this.processAwardCommentsBusinessRules(awardDocument);
        retval &= this.processAwardDetailsAndDatesSaveRules(document);
        retval &= this.processDateBusinessRule(errorMap, awardDocument);
        return retval &= this.processKeywordBusinessRule(awardDocument);
    }

    private boolean validateSponsors(MessageMap errorMap, AwardDocument awardDocument) {
        boolean valid = true;
        SponsorService ss = this.getSponsorService();
        if (!ss.validateSponsor(awardDocument.getAward().getSponsor())) {
            errorMap.putError("document.awardList[0].sponsorCode", "error.invalid.sponsorCode", new String[0]);
            valid = false;
        }
        if (!StringUtils.isEmpty((String)awardDocument.getAward().getPrimeSponsorCode()) && !ss.validateSponsor(awardDocument.getAward().getPrimeSponsor())) {
            errorMap.putError("document.awardList[0].primeSponsorCode", "error.invalid.sponsorCode", new String[0]);
            valid = false;
        }
        return valid;
    }

    private boolean skipRuleProcessing(Document document) {
        return "*****PLACEHOLDER*****".equals(document.getDocumentHeader().getDocumentDescription());
    }

    private boolean processApprovedEquipmentBusinessRules(MessageMap errorMap, AwardDocument awardDocument) {
        boolean success = true;
        errorMap.addToErrorPath(DOCUMENT_ERROR_PATH);
        errorMap.addToErrorPath(AWARD_ERROR_PATH);
        Award award = awardDocument.getAward();
        EquipmentCapitalizationMinimumLoader helper = new EquipmentCapitalizationMinimumLoader();
        AwardApprovedEquipmentRuleImpl rule = new AwardApprovedEquipmentRuleImpl();
        int count = award.getApprovedEquipmentItems().size();
        for (int i = 0; i < count; ++i) {
            String errorPath = String.format("approvedEquipmentItems[%d]", i);
            errorMap.addToErrorPath(errorPath);
            String errorKey = AWARD_ERROR_PATH_PREFIX + errorPath;
            AwardApprovedEquipmentRuleEvent event = new AwardApprovedEquipmentRuleEvent(errorKey, awardDocument, awardDocument.getAward(), (AwardApprovedEquipment)award.getApprovedEquipmentItems().get(i), helper.getMinimumCapitalization());
            success &= rule.processAwardApprovedEquipmentBusinessRules(event);
            errorMap.removeFromErrorPath(errorPath);
        }
        errorMap.removeFromErrorPath(AWARD_ERROR_PATH);
        errorMap.removeFromErrorPath(DOCUMENT_ERROR_PATH);
        return success;
    }

    private boolean processPaymentScheduleBusinessRules(MessageMap errorMap, AwardDocument awardDocument) {
        errorMap.addToErrorPath(DOCUMENT_ERROR_PATH);
        errorMap.addToErrorPath(AWARD_ERROR_PATH);
        boolean success = true;
        errorMap.removeFromErrorPath(AWARD_ERROR_PATH);
        errorMap.removeFromErrorPath(DOCUMENT_ERROR_PATH);
        return success;
    }

    private boolean processKeywordBusinessRule(AwardDocument awardDocument) {
        List keywords = awardDocument.getAward().getKeywords();
        for (AwardScienceKeyword keyword : keywords) {
            for (AwardScienceKeyword keyword2 : keywords) {
                if (keyword == keyword2 || !StringUtils.equalsIgnoreCase((String)keyword.getScienceKeywordCode(), (String)keyword2.getScienceKeywordCode())) continue;
                GlobalVariables.getMessageMap().putError("document.awardList[0].keywords", "error.proposalKeywords.duplicate", new String[0]);
                return false;
            }
        }
        return true;
    }

    private boolean processAddPaymentScheduleBusinessRules(MessageMap errorMap, AddAwardPaymentScheduleRuleEvent event) {
        boolean success = new AwardPaymentScheduleRuleImpl().processAddAwardPaymentScheduleBusinessRules(event);
        return success;
    }

    private boolean processCostShareBusinessRules(Document document) {
        boolean valid = true;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        AwardDocument awardDocument = (AwardDocument)document;
        int i = 0;
        List awardCostShares = awardDocument.getAward().getAwardCostShares();
        errorMap.addToErrorPath(DOCUMENT_ERROR_PATH);
        errorMap.addToErrorPath(AWARD_ERROR_PATH);
        for (AwardCostShare awardCostShare : awardCostShares) {
            String errorPath = "awardCostShares[" + i + "]";
            errorMap.addToErrorPath(errorPath);
            AwardCostShareRuleEvent event = new AwardCostShareRuleEvent(errorPath, awardDocument, awardCostShare);
            valid &= new AwardCostShareRuleImpl().processCostShareBusinessRules(event, i);
            errorMap.removeFromErrorPath(errorPath);
            ++i;
        }
        errorMap.removeFromErrorPath(AWARD_ERROR_PATH);
        errorMap.removeFromErrorPath(DOCUMENT_ERROR_PATH);
        return valid;
    }

    private boolean processAwardDetailsAndDatesSaveRules(Document document) {
        boolean valid = true;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        AwardDocument awardDocument = (AwardDocument)document;
        errorMap.addToErrorPath(DOCUMENT_ERROR_PATH);
        errorMap.addToErrorPath(AWARD_ERROR_PATH);
        AwardDetailsAndDatesSaveEvent event = new AwardDetailsAndDatesSaveEvent(awardDocument, awardDocument.getAward());
        errorMap.removeFromErrorPath(AWARD_ERROR_PATH);
        errorMap.removeFromErrorPath(DOCUMENT_ERROR_PATH);
        return valid &= new AwardDetailsAndDatesRuleImpl().processSaveAwardDetailsAndDates(event);
    }

    private boolean processAwardCommentsBusinessRules(AwardDocument awardDocument) {
        AwardCommentsRuleEvent ruleEvent = new AwardCommentsRuleEvent("document.awardList[0]", awardDocument);
        return this.processAwardCommentsBusinessRules(ruleEvent);
    }

    public boolean processAwardCommentsBusinessRules(AwardCommentsRuleEvent ruleEvent) {
        return new AwardCommentsRuleImpl().processAwardCommentsBusinessRules(ruleEvent);
    }

    private boolean processBenefitsRatesBusinessRules(Document document) {
        boolean valid = true;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        AwardDocument awardDocument = (AwardDocument)document;
        Award award = awardDocument.getAward();
        errorMap.addToErrorPath(DOCUMENT_ERROR_PATH);
        errorMap.addToErrorPath(AWARD_ERROR_PATH);
        if (StringUtils.equalsIgnoreCase((String)this.getParameterService().getParameterValueAsString("KC-AWARD", "Document", "enable.award.FnA.validation"), (String)"1") || StringUtils.equalsIgnoreCase((String)this.getParameterService().getParameterValueAsString("KC-AWARD", "Document", "enable.award.FnA.validation"), (String)"2")) {
            String errorPath = "benefitsRates.rates";
            errorMap.addToErrorPath(errorPath);
            AwardBenefitsRatesRuleEvent event = new AwardBenefitsRatesRuleEvent(errorPath, award, awardDocument);
            valid &= new AwardBenefitsRatesRuleImpl().processBenefitsRatesBusinessRules(event);
            errorMap.removeFromErrorPath(errorPath);
        }
        errorMap.removeFromErrorPath(AWARD_ERROR_PATH);
        errorMap.removeFromErrorPath(DOCUMENT_ERROR_PATH);
        return valid;
    }

    public boolean processApprovedSubawardBusinessRules(Document document) {
        boolean valid = true;
        MessageMap errorMap = GlobalVariables.getMessageMap();
        AwardDocument awardDocument = (AwardDocument)document;
        int i = 0;
        List awardApprovedSubawards = awardDocument.getAward().getAwardApprovedSubawards();
        errorMap.addToErrorPath(DOCUMENT_ERROR_PATH);
        errorMap.addToErrorPath(AWARD_ERROR_PATH);
        for (AwardApprovedSubaward awardApprovedSubaward : awardApprovedSubawards) {
            String errorPath = "awardApprovedSubawards[" + i + "]";
            errorMap.addToErrorPath(errorPath);
            AwardApprovedSubawardRuleEvent event = new AwardApprovedSubawardRuleEvent(errorPath, awardDocument, awardApprovedSubaward, awardApprovedSubawards);
            valid &= new AwardApprovedSubawardRuleImpl().processApprovedSubawardBusinessRules(event);
            errorMap.removeFromErrorPath(errorPath);
            ++i;
        }
        errorMap.removeFromErrorPath(AWARD_ERROR_PATH);
        errorMap.removeFromErrorPath(DOCUMENT_ERROR_PATH);
        return valid;
    }

    public boolean processRunAuditBusinessRules(Document document) {
        boolean retval = true;
        retval &= super.processRunAuditBusinessRules(document);
        retval &= new AwardReportAuditRule().processRunAuditBusinessRules(document);
        retval &= new AwardTermsAuditRule().processRunAuditBusinessRules(document);
        retval &= new AwardPaymentAndInvoicesAuditRule().processRunAuditBusinessRules(document);
        retval &= new AwardCostShareAuditRule().processRunAuditBusinessRules(document);
        retval &= new AwardFandARateAuditRule().processRunAuditBusinessRules(document);
        retval &= new AwardProjectPersonsAuditRule().processRunAuditBusinessRules(document);
        retval &= new AwardPersonCreditSplitAuditRule().processRunAuditBusinessRules(document);
        retval &= new AwardSubawardAuditRule().processRunAuditBusinessRules(document);
        retval &= new AwardSyncAuditRule().processRunAuditBusinessRules(document);
        retval &= new AwardSponsorContactAuditRule().processRunAuditBusinessRules(document);
        retval &= new AwardBudgetLimitsAuditRule().processRunAuditBusinessRules(document);
        this.reportAndCreateAuditCluster();
        return retval &= this.processDateBusinessRule(GlobalVariables.getMessageMap(), (AwardDocument)document);
    }

    public boolean processAddFandaRateBusinessRules(AddAwardFandaRateEvent addAwardFandaRateEvent) {
        return new AwardFandaRateRule().processAddFandaRateBusinessRules(addAwardFandaRateEvent);
    }

    public boolean processSaveFandaRateBusinessRules(AwardFandaRateSaveEvent awardFandaRateSaveEvent) {
        return new AwardFandaRateRule().processSaveFandaRateBusinessRules(awardFandaRateSaveEvent);
    }

    public boolean processAwardReportTermBusinessRules(Document document) {
        AwardDocument awardDocument = (AwardDocument)document;
        AwardReportTerm awardReportTermItem = awardDocument.getAward().getAwardReportTermItems().isEmpty() ? null : (AwardReportTerm)awardDocument.getAward().getAwardReportTermItems().get(0);
        AwardReportTermRuleEvent event = new AwardReportTermRuleEvent(AWARD_ERROR_PATH_PREFIX, awardDocument, awardDocument.getAward(), awardReportTermItem);
        return this.processAwardReportTermBusinessRules(event);
    }

    public boolean processAwardReportTermBusinessRules(AwardReportTermRuleEvent event) {
        return new AwardReportTermRuleImpl().processAwardReportTermBusinessRules(event);
    }

    protected boolean evaluateBusinessRuleForReportCodeField(AwardReportTerm awardReportTerm, int index) {
        boolean retval = this.isValidReportCode(awardReportTerm, this.getReportCodes(awardReportTerm.getReportClassCode()));
        if (!retval) {
            GlobalVariables.getMessageMap().putError("awardReportTermItems[" + index + "]" + ".reportCode", "error.invalid.type.for.reportClass", new String[0]);
        }
        return retval;
    }

    protected boolean isValidReportCode(AwardReportTerm awardReportTerm, List<KeyValue> reportCodes) {
        boolean isValid = false;
        for (KeyValue KeyValue2 : reportCodes) {
            if (!StringUtils.equalsIgnoreCase((String)KeyValue2.getKey().toString(), (String)awardReportTerm.getReportCode())) continue;
            isValid = true;
        }
        return isValid;
    }

    protected boolean evaluateBusinessRuleForFrequencyCodeField(AwardReportTerm awardReportTerm, int index) {
        boolean retval = this.isValidFrequency(awardReportTerm, this.getFrequencyCodes(awardReportTerm.getReportClassCode(), awardReportTerm.getReportCode()));
        if (!retval) {
            GlobalVariables.getMessageMap().putError("awardReportTermItems[" + index + "]" + ".frequencyCode", "error.invalid.frequency.for.reportClass.and.type", new String[0]);
        }
        return retval;
    }

    protected boolean isValidFrequency(AwardReportTerm awardReportTerm, List<KeyValue> frequencyCodes) {
        boolean isValid = false;
        for (KeyValue KeyValue2 : frequencyCodes) {
            if (!StringUtils.equalsIgnoreCase((String)KeyValue2.getKey().toString(), (String)awardReportTerm.getFrequencyCode())) continue;
            isValid = true;
        }
        return isValid;
    }

    protected boolean evaluateBusinessRuleForFrequencyBaseCodeField(AwardReportTerm awardReportTerm, int index) {
        boolean retval = this.isValidFrequencyBase(awardReportTerm, this.getFrequencyBaseCodes(awardReportTerm.getFrequencyCode()));
        if (!retval) {
            GlobalVariables.getMessageMap().putError("awardReportTermItems[" + index + "]" + ".frequencyBaseCode", "error.invalid.frequencyBase.for.frequency", new String[0]);
        }
        return retval;
    }

    protected boolean isValidFrequencyBase(AwardReportTerm awardReportTerm, List<KeyValue> frequencyBaseCodes) {
        boolean isValid = false;
        for (KeyValue KeyValue2 : frequencyBaseCodes) {
            if (!StringUtils.equalsIgnoreCase((String)KeyValue2.getKey().toString(), (String)awardReportTerm.getFrequencyBaseCode())) continue;
            isValid = true;
        }
        return isValid;
    }

    protected boolean evaluateBusinessRuleForRecipients(AwardReportTerm awardReportTerm, int index) {
        boolean isValid = true;
        List recipients = awardReportTerm.getAwardReportTermRecipients();
        for (int i = 0; i < recipients.size(); ++i) {
            AwardReportTermRecipient recipient = (AwardReportTermRecipient)recipients.get(i);
            if (recipient.getRolodexId() != null) continue;
            GlobalVariables.getMessageMap().putError("awardReportTermItems[" + index + "]" + ".awardReportTermRecipients" + "[" + i + "]" + ".rolodexId", "error.required.organization", new String[]{new Integer(i + 1).toString()});
            isValid = false;
        }
        return isValid;
    }

    protected List<KeyValue> getReportCodes(String reportClassCode) {
        ReportCodeValuesFinder reportCodeValuesFinder = new ReportCodeValuesFinder();
        reportCodeValuesFinder.setReportClassCode(reportClassCode);
        return reportCodeValuesFinder.getKeyValues();
    }

    protected List<KeyValue> getFrequencyCodes(String reportClassCode, String reportCode) {
        FrequencyCodeValuesFinder frequencyCodeValuesFinder = new FrequencyCodeValuesFinder(reportClassCode, reportCode);
        return frequencyCodeValuesFinder.getKeyValues();
    }

    protected List<KeyValue> getFrequencyBaseCodes(String frequencyCode) {
        FrequencyBaseCodeValuesFinder frequencyBaseCodeValuesFinder = new FrequencyBaseCodeValuesFinder();
        frequencyBaseCodeValuesFinder.setFrequencyCode(frequencyCode);
        return frequencyBaseCodeValuesFinder.getKeyValues();
    }

    public boolean processAddAwardReportTermBusinessRules(AddAwardReportTermRuleEvent event) {
        return new AwardReportTermRuleImpl().processAddAwardReportTermBusinessRules(event);
    }

    public boolean processAwardReportTermRecipientBusinessRules(AwardReportTermRecipientRuleEvent event) {
        return new AwardReportTermRecipientRuleImpl().processAwardReportTermRecipientBusinessRules(event);
    }

    public boolean processAddAwardReportTermRecipientBusinessRules(AddAwardReportTermRecipientRuleEvent event) {
        return new AwardReportTermRecipientRuleImpl().processAddAwardReportTermRecipientBusinessRules(event);
    }

    public boolean processAddAwardReportTermRecipientEvent(AddAwardReportTermRecipientRuleEvent addAwardReportTermRecipientRuleEvent) {
        return new AwardReportTermRecipientRuleImpl().processAddAwardReportTermRecipientBusinessRules(addAwardReportTermRecipientRuleEvent);
    }

    public boolean processAwardReportTermRecipientEvent(AwardReportTermRecipientRuleEvent event) {
        return new AwardReportTermRecipientRuleImpl().processAwardReportTermRecipientBusinessRules(event);
    }

    private boolean processApprovedForeignTravelBusinessRules(MessageMap errorMap, AwardDocument awardDocument) {
        boolean success = true;
        errorMap.addToErrorPath(DOCUMENT_ERROR_PATH);
        errorMap.addToErrorPath(AWARD_ERROR_PATH);
        Award award = awardDocument.getAward();
        AwardApprovedForeignTravelRuleImpl rule = new AwardApprovedForeignTravelRuleImpl();
        int count = award.getApprovedForeignTravelTrips().size();
        for (int i = 0; i < count; ++i) {
            String errorPath = String.format("approvedForeignTravelTrips[%d]", i);
            errorMap.addToErrorPath(errorPath);
            String errorKey = AWARD_ERROR_PATH_PREFIX + errorPath;
            AwardApprovedForeignTravelRuleEvent event = new AwardApprovedForeignTravelRuleEvent(errorKey, awardDocument, awardDocument.getAward(), (AwardApprovedForeignTravel)award.getApprovedForeignTravelTrips().get(i));
            success &= rule.processAwardApprovedForeignTravelBusinessRules(event);
            errorMap.removeFromErrorPath(errorPath);
        }
        errorMap.removeFromErrorPath(AWARD_ERROR_PATH);
        errorMap.removeFromErrorPath(DOCUMENT_ERROR_PATH);
        return success;
    }

    private boolean processSaveAwardProjectPersonsBusinessRules(MessageMap errorMap, AwardDocument document) {
        errorMap.addToErrorPath(DOCUMENT_ERROR_PATH);
        errorMap.addToErrorPath(AWARD_ERROR_PATH);
        SaveAwardProjectPersonsRuleEvent event = new SaveAwardProjectPersonsRuleEvent("Project Persons", "projectPersons", (Document)document);
        boolean success = new AwardProjectPersonsSaveRuleImpl().processSaveAwardProjectPersonsBusinessRules(event);
        errorMap.removeFromErrorPath(AWARD_ERROR_PATH);
        errorMap.removeFromErrorPath(DOCUMENT_ERROR_PATH);
        return success;
    }

    public boolean processAwardTemplateSyncRules(AwardTemplateSyncEvent awardTemplateSyncEvent) {
        return new AwardTemplateSyncRuleImpl().processAwardTemplateSyncRules(awardTemplateSyncEvent);
    }

    private boolean processUnitNumberBusinessRule(MessageMap errorMap, AwardDocument awardDocument) {
        boolean success;
        Award award = awardDocument.getAward();
        errorMap.addToErrorPath(DOCUMENT_ERROR_PATH);
        errorMap.addToErrorPath(AWARD_ERROR_PATH);
        boolean bl = success = award.getUnitNumber() != null && award.getUnit() != null;
        if (!success) {
            errorMap.putError("unitNumber", "error.award.unitNumber", new String[]{award.getUnitNumber()});
        }
        errorMap.removeFromErrorPath(AWARD_ERROR_PATH);
        errorMap.removeFromErrorPath(DOCUMENT_ERROR_PATH);
        return success;
    }

    private boolean processDateBusinessRule(MessageMap errorMap, AwardDocument awardDocument) {
        boolean isTimeAndMoneyDocument = KNSGlobalVariables.getKualiForm() instanceof TimeAndMoneyForm;
        if (isTimeAndMoneyDocument) {
            TimeAndMoneyForm timeAndMoneyForm = (TimeAndMoneyForm)KNSGlobalVariables.getKualiForm();
            TimeAndMoneyAwardDateSaveEvent event = new TimeAndMoneyAwardDateSaveEvent("", (Document)timeAndMoneyForm.getTimeAndMoneyDocument());
            TimeAndMoneyAwardDateSaveRuleImpl rule = new TimeAndMoneyAwardDateSaveRuleImpl();
            boolean result = rule.processSaveAwardDatesBusinessRules(event);
            return result;
        }
        Award award = awardDocument.getAward();
        errorMap.addToErrorPath(DOCUMENT_ERROR_PATH);
        errorMap.addToErrorPath(AWARD_ERROR_PATH);
        boolean success = true;
        int lastIndex = award.getIndexOfLastAwardAmountInfo();
        Date effStartDate = award.getAwardEffectiveDate();
        Date effEndDate = ((AwardAmountInfo)award.getAwardAmountInfos().get(lastIndex)).getFinalExpirationDate();
        String awardId = award.getAwardNumber();
        Date oblStartDate = ((AwardAmountInfo)award.getAwardAmountInfos().get(lastIndex)).getCurrentFundEffectiveDate();
        Date oblEndDate = ((AwardAmountInfo)award.getAwardAmountInfos().get(lastIndex)).getObligationExpirationDate();
        String fieldStarter = "awardAmountInfos[" + lastIndex;
        success = AwardDateRulesHelper.validateProjectStartBeforeProjectEnd((MessageMap)errorMap, (Date)effStartDate, (Date)effEndDate, (String)(fieldStarter + "].finalExpirationDate"), (String)awardId) && success;
        success = AwardDateRulesHelper.validateObligationStartBeforeObligationEnd((MessageMap)errorMap, (Date)oblStartDate, (Date)oblEndDate, (String)(fieldStarter + "].currentFundEffectiveDate"), (String)awardId) && success;
        success = AwardDateRulesHelper.validateProjectStartBeforeObligationStart((MessageMap)errorMap, (Date)effStartDate, (Date)oblStartDate, (String)(fieldStarter + "].currentFundEffectiveDate"), (String)awardId) && success;
        success = AwardDateRulesHelper.validateProjectStartBeforeObligationEnd((MessageMap)errorMap, (Date)effStartDate, (Date)oblEndDate, (String)(fieldStarter + "].obligationExpirationDate"), (String)awardId) && success;
        success = AwardDateRulesHelper.validateObligationStartBeforeProjectEnd((MessageMap)errorMap, (Date)oblStartDate, (Date)effEndDate, (String)(fieldStarter + "].currentFundEffectiveDate"), (String)awardId) && success;
        boolean bl = success = AwardDateRulesHelper.validateObligationEndBeforeProjectEnd((MessageMap)errorMap, (Date)oblEndDate, (Date)effEndDate, (String)(fieldStarter + "].obligationExpirationDate"), (String)awardId) && success;
        if (effStartDate == null) {
            String link = "home.anchorDetailsDates";
            String messageKey = "warn.awardProjectStartDate.null";
            String errorKey = "document.awardList[0].awardEffectiveDate";
            this.auditWarnings.add(new AuditError(errorKey, messageKey, link));
        }
        errorMap.removeFromErrorPath(AWARD_ERROR_PATH);
        errorMap.removeFromErrorPath(DOCUMENT_ERROR_PATH);
        return success;
    }

    public boolean processRules(KraDocumentEventBaseExtension event) {
        boolean retVal = false;
        retVal = event.getRule().processRules(event);
        return retVal;
    }

    public boolean processsAddAttachmentRule(AddAwardAttachmentEvent event) {
        boolean valid = true;
        if (StringUtils.isBlank((String)event.getAwardAttachment().getTypeCode())) {
            valid = false;
            LOG.debug((Object)"error.awardNotesAndAttachments.attachment.typeRequired");
            this.reportError("awardAttachmentFormBean.newAttachment.typeCode", "error.awardNotesAndAttachments.attachment.typeRequired", new String[0]);
        }
        if (event.getAwardAttachment().getNewFile() == null || StringUtils.isEmpty((String)event.getAwardAttachment().getNewFile().getFileName())) {
            valid = false;
            LOG.debug((Object)"error.awardNotesAndAttachments.attachment.fileRequired");
            this.reportError("awardAttachmentFormBean.newAttachment.newFile", "error.awardNotesAndAttachments.attachment.fileRequired", new String[0]);
        }
        return valid;
    }

    protected void reportAndCreateAuditCluster() {
        if (this.auditErrors.size() > 0) {
            KNSGlobalVariables.getAuditErrorMap().put("homePageAuditErrors", new AuditCluster("Details & Dates", this.auditErrors, "Validation Errors"));
        }
        if (this.auditWarnings.size() > 0) {
            KNSGlobalVariables.getAuditErrorMap().put("homePageAuditWarnings", new AuditCluster("Details & Dates", this.auditWarnings, "Warnings"));
        }
    }

    private SponsorService getSponsorService() {
        return (SponsorService)KraServiceLocator.getService(SponsorService.class);
    }
}

