/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.AwardHierarchyUIService;
import org.kuali.kra.timeandmoney.AwardHierarchyNode;
import org.kuali.rice.kns.inquiry.KualiInquirableImpl;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.kns.web.ui.Section;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.util.ObjectUtils;

public class AwardInquirable
extends KualiInquirableImpl {
    private static final Log LOG = LogFactory.getLog(AwardInquirable.class);

    public List<Section> getSections(BusinessObject bo) {
        ArrayList<Section> sections = new ArrayList<Section>();
        Section section = new Section();
        section.setRows(new ArrayList());
        section.setDefaultOpen(true);
        section.setNumberOfColumns(2);
        AwardHierarchyUIService service = this.getAwardHierarchyUIService();
        Award award = (Award)bo;
        AwardHierarchyNode awardNode = null;
        try {
            awardNode = service.getRootAwardNode(award);
        }
        catch (ParseException e) {
            LOG.error((Object)"Error parsing award information", (Throwable)e);
        }
        String sectionTitle = "";
        sectionTitle = sectionTitle + awardNode.getAwardNumber();
        sectionTitle = sectionTitle + " ";
        sectionTitle = sectionTitle + ":";
        sectionTitle = sectionTitle + " ";
        if (ObjectUtils.isNotNull((Object)award.getAccountNumber())) {
            sectionTitle = sectionTitle + awardNode.getAccountNumber();
            sectionTitle = sectionTitle + " ";
            sectionTitle = sectionTitle + ":";
            sectionTitle = sectionTitle + " ";
        }
        if (ObjectUtils.isNotNull((Object)awardNode.getPrincipalInvestigatorName())) {
            sectionTitle = sectionTitle + awardNode.getPrincipalInvestigatorName();
            sectionTitle = sectionTitle + " ";
            sectionTitle = sectionTitle + ":";
            sectionTitle = sectionTitle + " ";
        }
        if (ObjectUtils.isNotNull((Object)awardNode.getLeadUnitName())) {
            sectionTitle = sectionTitle + awardNode.getLeadUnitName();
        }
        section.setSectionTitle(sectionTitle);
        section.setRows(new ArrayList());
        Row row1 = new Row();
        this.addField(awardNode.getProjectStartDate() + "", row1, "projectStartDate", "Project Start Date");
        this.addField(awardNode.getCurrentFundEffectiveDate() + "", row1, "obligationStartDate", "Obligation Start Date");
        section.getRows().add(row1);
        Row row2 = new Row();
        this.addField(awardNode.getFinalExpirationDate() + "", row2, "projectEndDate", "Project End Date");
        this.addField(awardNode.getObligationExpirationDate() + "", row2, "obligationEndDate", "Obligation End Date");
        section.getRows().add(row2);
        Row row3 = new Row();
        this.addField(awardNode.getAnticipatedTotalAmount() + "", row3, "anticipatedAmount", "Anticipated Amount");
        this.addField(awardNode.getAmountObligatedToDate() + "", row3, "obligatedAmount", "Obligated Amount");
        section.getRows().add(row3);
        Row row4 = new Row();
        this.addField(awardNode.getTitle(), row4, "title", "Title");
        this.addField(award.getSponsorAwardNumber(), row4, "sponsorAwardNumber", "Sponsor Award Number");
        section.getRows().add(row4);
        Row row5 = new Row();
        this.addField(award.getAwardNumber(), row5, "awardNumber", "Award Number");
        this.addField(award.getAwardStatus().getStatusCode() + "", row5, "awardStatusCode", "Award Status Code");
        section.getRows().add(row5);
        Row row6 = new Row();
        this.addField(award.getOspAdministratorName(), row6, "ospAdminName", "OSP Administrator Name");
        this.addField(award.getCloseoutDate() + "", row6, "closeoutDate", "Closeout Date");
        section.getRows().add(row6);
        Row row7 = new Row();
        this.addField(award.getCfdaNumber(), row7, "cfdaNumber", "CFDA Number");
        section.getRows().add(row7);
        sections.add(section);
        return sections;
    }

    private void addField(String text, Row row1, String propertyName, String fieldLabel) {
        Field field = new Field();
        field.setPropertyName(propertyName);
        field.setFieldLabel(fieldLabel);
        field.setFieldType("text");
        if (StringUtils.equalsIgnoreCase((String)text, (String)" &nbsp; ")) {
            text = "";
        }
        field.setPropertyValue(text);
        row1.getFields().add(field);
    }

    private AwardHierarchyUIService getAwardHierarchyUIService() {
        return (AwardHierarchyUIService)KraServiceLocator.getService(AwardHierarchyUIService.class);
    }
}

