/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.proposaldevelopment.service.ProposalLockService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.service.impl.PessimisticLockServiceImpl;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public class AwardLockServiceImpl
extends PessimisticLockServiceImpl
implements ProposalLockService {
    protected boolean isLockRequiredByUser(Document document, Map editMode, Person user) {
        String activeLockRegion = (String)GlobalVariables.getUserSession().retrieveObject("ACTIVE_LOCK_REGION");
        for (Map.Entry entry : editMode.entrySet()) {
            if (!this.isEntryEditMode(entry) || !StringUtils.isNotEmpty((String)activeLockRegion)) continue;
            return true;
        }
        return false;
    }

    protected boolean isEntryEditMode(Map.Entry entry) {
        if ("fullEntry".equals(entry.getKey()) || "addNarratives".equals(entry.getKey()) || "modifyPermissions".equals(entry.getKey()) || "modifyProposal".equals(entry.getKey()) || "modifyBudgets".equals(entry.getKey()) || "addBudget".equals(entry.getKey())) {
            String fullEntryEditModeValue = (String)entry.getValue();
            return ObjectUtils.isNotNull((Object)fullEntryEditModeValue) && StringUtils.equalsIgnoreCase((String)"true", (String)fullEntryEditModeValue);
        }
        return false;
    }

    protected Map getEditModeWithEditableModesRemoved(Map currentEditMode) {
        HashMap editModeMap = new HashMap();
        for (Map.Entry entry : editModeMap.entrySet()) {
            if (!StringUtils.equals((String)((String)entry.getKey()), (String)"addBudget")) continue;
            entry.setValue("FALSE");
        }
        return editModeMap;
    }

    protected PessimisticLock createNewPessimisticLock(Document document, Map editMode, Person user) {
        if (document.useCustomLockDescriptors()) {
            String lockDescriptor = document.getCustomLockDescriptor(user);
            AwardDocument pdDocument = (AwardDocument)document;
            if (StringUtils.isNotEmpty((String)lockDescriptor) && lockDescriptor.contains("BUDGET")) {
                List awardBudgetDocuments = pdDocument.getBudgetDocumentVersions();
                for (BudgetDocumentVersion budgetOverview : awardBudgetDocuments) {
                    this.generateNewLock(budgetOverview.getDocumentNumber(), lockDescriptor, user);
                }
            }
            return this.generateNewLock(document.getDocumentNumber(), lockDescriptor, user);
        }
        return this.generateNewLock(document.getDocumentNumber(), user);
    }
}

