/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award;

import java.text.DecimalFormat;
import java.util.List;
import org.kuali.kra.award.AwardNumberService;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.dao.KraLookupDao;
import org.kuali.rice.krad.service.SequenceAccessorService;

public class AwardNumberServiceImpl
implements AwardNumberService {
    private SequenceAccessorService sequenceAccessorService;
    private KraLookupDao kraLookupDao;
    private String DASH = "-";
    private String PERCENT = "%";
    private String AWARD_NUMBER = "awardNumber";

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }

    public void setKraLookupDao(KraLookupDao kraLookupDao) {
        this.kraLookupDao = kraLookupDao;
    }

    public String getNextAwardNumber() {
        Long nextAwardNumber = this.sequenceAccessorService.getNextAvailableSequenceNumber("SEQ_AWARD_AWARD_NUMBER");
        DecimalFormat formatter = new DecimalFormat("000000");
        return formatter.format(nextAwardNumber) + "-00001";
    }

    public String getNextAwardNumberInHierarchy(String awardNumber) {
        String[] splitAwardNumber = awardNumber.split(this.DASH);
        String awardNumberLike = splitAwardNumber[0] + this.PERCENT;
        StringBuilder returnString = new StringBuilder(12);
        returnString.append(splitAwardNumber[0]);
        returnString.append(this.DASH);
        returnString.append(this.lookupLikeAwardNumbers(awardNumberLike));
        return returnString.toString();
    }

    protected String lookupLikeAwardNumbers(String lookupLike) {
        DecimalFormat formatter = new DecimalFormat("00000");
        List awardList = (List)this.kraLookupDao.findCollectionUsingWildCard(Award.class, "awardNumber", lookupLike, Boolean.TRUE.booleanValue());
        return formatter.format(this.getHighestSequenceNode(awardList));
    }

    protected Long getHighestSequenceNode(List<Award> awardList) {
        Long returnValue = null;
        for (Award loopAward : awardList) {
            String[] splitAwardNumber = loopAward.getAwardNumber().split("-");
            Long testValue = Long.parseLong(splitAwardNumber[1]);
            if (returnValue != null && testValue <= returnValue) continue;
            returnValue = testValue;
        }
        return returnValue + 1L;
    }
}

