/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.ValidAwardBasisPayment;
import org.kuali.kra.award.home.ValidBasisMethodPayment;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.AwardPaymentAndInvoicesService;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;

public class AwardPaymentAndInvoicesAuditRule
implements DocumentAuditRule {
    private static final String DOT = ".";
    private static final String PAYMENTS_AND_INVOICES_AUDIT_ERRORS = "paymentAndInvoicesAuditErrors";
    private static final String PAYMENT_METHOD = "Payment Method";
    private static final String PAYMENT_BASIS = "Payment Basis";
    private static final String BASIS_OF_PAYMENT_AUDIT_KEY = "awardBasisOfPaymentCode";
    private static final String METHOD_OF_PAYMENT_AUDIT_KEY = "awardMethofOfPaymentCode";
    private static final String PAYMENTS_INVOICES_URL = "paymentReportsAndTerms.Payments";

    public boolean processRunAuditBusinessRules(Document document) {
        boolean valid = true;
        AwardDocument awardDocument = (AwardDocument)document;
        ArrayList auditErrors = new ArrayList();
        Award award = awardDocument.getAward();
        if (award.getMethodOfPaymentCode() == null) {
            valid &= false;
            this.addErrorToAuditErrors(auditErrors, METHOD_OF_PAYMENT_AUDIT_KEY, PAYMENT_METHOD);
        }
        if (award.getBasisOfPaymentCode() == null) {
            valid &= false;
            this.addErrorToAuditErrors(auditErrors, BASIS_OF_PAYMENT_AUDIT_KEY, PAYMENT_BASIS);
        }
        valid &= this.checkAwardBasisOfPayment(awardDocument, auditErrors);
        this.reportAndCreateAuditCluster(auditErrors);
        return valid &= this.checkAwardBasisAndMethodOfPayment(awardDocument, auditErrors);
    }

    protected void addErrorToAuditErrors(List<AuditError> auditErrors, String relAuditErrorKey, String description) {
        String[] params = new String[5];
        params[0] = description;
        StringBuilder sb = new StringBuilder();
        sb.append("paymentReportsAndTerms");
        sb.append(DOT);
        sb.append("Payments");
        if (relAuditErrorKey != null) {
            sb.append(DOT);
            sb.append(relAuditErrorKey);
        }
        auditErrors.add(new AuditError("document.paymentsAuditRules", "error.required", sb.toString(), params));
    }

    protected void reportAndCreateAuditCluster(List<AuditError> auditErrors) {
        if (auditErrors.size() > 0) {
            KNSGlobalVariables.getAuditErrorMap().put(PAYMENTS_AND_INVOICES_AUDIT_ERRORS, new AuditCluster("Payments", auditErrors, "Validation Errors"));
        }
    }

    protected boolean checkAwardBasisOfPayment(AwardDocument document, List<AuditError> errors) {
        boolean valid = false;
        if (document.getAward().getAwardTypeCode() != null && document.getAward().getBasisOfPaymentCode() != null) {
            ArrayList basisPayments = new ArrayList(this.getAwardPaymentAndInvoicesService().getValidAwardBasisPaymentsByAwardTypeCode(document.getAward().getAwardTypeCode()));
            for (ValidAwardBasisPayment basisPayment : basisPayments) {
                if (!StringUtils.equals((String)basisPayment.getBasisOfPaymentCode(), (String)document.getAward().getBasisOfPaymentCode())) continue;
                valid = true;
            }
            document.getAward().refreshReferenceObject("awardType");
            if (!valid) {
                errors.add(new AuditError("document.paymentsAuditRules", "error.award.paymentsAndInvoices.invalidBasisOfPaymentForAwardType", PAYMENTS_INVOICES_URL, new String[]{document.getAward().getBasisOfPaymentCode(), document.getAward().getAwardType().getDescription()}));
            }
        } else {
            valid = true;
        }
        return valid;
    }

    protected boolean checkAwardBasisAndMethodOfPayment(AwardDocument document, List<AuditError> errors) {
        boolean valid = false;
        if (document.getAward().getAwardTypeCode() != null && document.getAward().getBasisOfPaymentCode() != null) {
            ArrayList basisMethodPayments = new ArrayList(this.getAwardPaymentAndInvoicesService().getValidBasisMethodPaymentByBasisCode(document.getAward().getBasisOfPaymentCode()));
            for (ValidBasisMethodPayment basisMethodPayment : basisMethodPayments) {
                if (!StringUtils.equals((String)basisMethodPayment.getMethodOfPaymentCode(), (String)document.getAward().getMethodOfPaymentCode())) continue;
                valid = true;
            }
            if (!valid) {
                errors.add(new AuditError("document.paymentsAuditRules", "error.award.paymentsAndInvoices.invalidBasisAndMethodOfPayment", PAYMENTS_INVOICES_URL, new String[0]));
            }
        } else {
            valid = true;
        }
        return valid;
    }

    protected AwardPaymentAndInvoicesService getAwardPaymentAndInvoicesService() {
        return (AwardPaymentAndInvoicesService)KraServiceLocator.getService(AwardPaymentAndInvoicesService.class);
    }
}

