/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award;

import java.lang.reflect.Field;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.award.contacts.AwardSponsorContact;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.AwardComment;
import org.kuali.kra.award.home.AwardSyncable;
import org.kuali.kra.award.home.AwardSyncableList;
import org.kuali.kra.award.home.AwardTemplateComment;
import org.kuali.kra.award.home.AwardTemplateContact;
import org.kuali.kra.award.home.AwardTemplateReportTerm;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTerm;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;

/*
 * Exception performing whole class analysis ignored.
 */
public enum AwardTemplateSyncScope {
    ANY(null),
    FULL(null),
    AWARD_PAGE("document.question.syncPanel.panelName.AWARD_PAGE"),
    SPONSOR_CONTACTS_TAB("document.question.syncPanel.panelName.SPONSOR_CONTACTS_TAB"),
    PAYMENTS_AND_INVOICES_TAB("document.question.syncPanel.panelName.PAYMENTS_AND_INVOICES_TAB"),
    REPORTS_TAB("document.question.syncPanel.panelName.REPORTS_TAB"),
    TERMS_TAB("document.question.syncPanel.panelName.TERMS_TAB"),
    COMMENTS_TAB("document.question.syncPanel.panelName.COMMENTS_TAB"),
    COST_SHARE("document.question.syncPanel.panelName.COST_SHARE"),
    PREAWARD_AUTHORIZATIONS_TAB("document.question.syncPanel.panelName.PREAWARD_AUTHORIZATIONS_TAB"),
    RATES_TAB("document.question.syncPanel.panelName.RATES_TAB"),
    CONTAINING_CLASS_INHERIT(null);

    private static final Log LOG;
    private String displayPropertyName;

    private AwardTemplateSyncScope(String displayPropertyName) {
        this.displayPropertyName = displayPropertyName;
    }

    public String getDisplayPropertyName() {
        return this.displayPropertyName;
    }

    public boolean isInScope(Field field) {
        boolean result = false;
        AwardSyncable async = field.getAnnotation(AwardSyncable.class);
        if (async != null && (ArrayUtils.contains((Object[])async.scopes(), (Object)this) || this == ANY)) {
            return true;
        }
        AwardSyncableList asynclist = field.getAnnotation(AwardSyncableList.class);
        if (asynclist != null && (ArrayUtils.contains((Object[])asynclist.scopes(), (Object)this) || this == ANY)) {
            return true;
        }
        return result;
    }

    public static boolean isInScope(AwardSyncable syncAnnotation, AwardTemplateSyncScope[] scopes) {
        return AwardTemplateSyncScope.isInScope((AwardTemplateSyncScope[])syncAnnotation.scopes(), (AwardTemplateSyncScope[])scopes);
    }

    public static boolean isInScope(AwardSyncableList syncAnnotation, AwardTemplateSyncScope[] scopes) {
        return AwardTemplateSyncScope.isInScope((AwardTemplateSyncScope[])syncAnnotation.scopes(), (AwardTemplateSyncScope[])scopes);
    }

    public static boolean isInScope(AwardTemplateSyncScope[] propertyScopes, AwardTemplateSyncScope[] appliedScopes) {
        boolean result = ArrayUtils.contains((Object[])propertyScopes, (Object)ANY);
        if (result) {
            return result;
        }
        for (AwardTemplateSyncScope scope : appliedScopes) {
            if (!ArrayUtils.contains((Object[])propertyScopes, (Object)scope)) continue;
            return true;
        }
        return result;
    }

    public boolean isInScope(AwardTemplateComment comment) {
        String commentTypeCode = comment.getCommentTypeCode();
        boolean result = this.isAwardCommentInScope(commentTypeCode);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("%s.isInScope for AwardTemplateComment ( commentTypeCode = %s ) returns %s.", this, comment.getCommentTypeCode(), result));
        }
        return result;
    }

    public static boolean isInScope(AwardTemplateComment comment, AwardTemplateSyncScope[] scopes) {
        for (AwardTemplateSyncScope scope : scopes) {
            if (!scope.isInScope(comment)) continue;
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("isInScope called for AwardTemplateComment ( commentTypeCode = %s ) with scopes = %s returning false.", comment.getCommentTypeCode(), ArrayUtils.toString((Object)scopes)));
        }
        return false;
    }

    public boolean isInScope(AwardComment comment) {
        String commentTypeCode = comment.getCommentTypeCode();
        boolean result = this.isAwardCommentInScope(commentTypeCode);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("%s.isInScope for AwardComment ( commentTypeCode = %s ) returns %s.", this, comment.getCommentTypeCode(), result));
        }
        return result;
    }

    public static boolean isInScope(AwardComment comment, AwardTemplateSyncScope[] scopes) {
        for (AwardTemplateSyncScope scope : scopes) {
            if (!scope.isInScope(comment)) continue;
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("isInScope called for AwardComment ( commentTypeCode = %s ) with scopes = %s returning false.", comment.getCommentTypeCode(), ArrayUtils.toString((Object)scopes)));
        }
        return false;
    }

    public static boolean isInScope(Object awardObject, AwardTemplateSyncScope[] scopes) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("default static isInScope called with scopes = %s", ArrayUtils.toString((Object)scopes)));
        }
        for (AwardTemplateSyncScope scope : scopes) {
            if (!scope.isInScope(awardObject)) continue;
            return true;
        }
        return false;
    }

    public boolean isInScope(Object awardObject) {
        LOG.debug((Object)String.format("default %s.isInScope called on %s.", this, awardObject.getClass()));
        return true;
    }

    public boolean isInScope(AwardTemplateReportTerm report) {
        String reportCode = report.getReportCode();
        String reportClassCode = report.getReportClassCode();
        LOG.debug((Object)String.format("%s.isInScope called for AwardTemplateReportTerm ( code = %s, class = %s ).", this, reportCode, reportClassCode));
        boolean result = this.isReportTermInScope(reportCode, reportClassCode);
        return result;
    }

    public static boolean isInScope(AwardTemplateReportTerm report, AwardTemplateSyncScope[] scopes) {
        String reportCode = report.getReportCode();
        String reportClassCode = report.getReportClassCode();
        LOG.debug((Object)String.format("isInScope called for AwardTemplateReportTerm ( code = %s, reportTermClass = %s ) with scopes = %s", reportCode, reportClassCode, ArrayUtils.toString((Object)scopes)));
        for (AwardTemplateSyncScope scope : scopes) {
            if (!scope.isInScope(report)) continue;
            return true;
        }
        LOG.debug((Object)String.format("isInScope called for AwardTemplateReportTerm ( code = %s, class = %s ) with scopes = %s returning false.", reportCode, reportClassCode, ArrayUtils.toString((Object)scopes)));
        return false;
    }

    public boolean isInScope(AwardReportTerm report) {
        String reportCode = report.getReportCode();
        String reportClassCode = report.getReportClassCode();
        boolean result = this.isReportTermInScope(reportCode, reportClassCode);
        return result;
    }

    public static boolean isInScope(AwardReportTerm report, AwardTemplateSyncScope[] scopes) {
        for (AwardTemplateSyncScope scope : scopes) {
            if (!scope.isInScope(report)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInScope(AwardSponsorContact sponsorContact, AwardTemplateSyncScope[] scopes) {
        for (AwardTemplateSyncScope scope : scopes) {
            if (!scope.isInScope(sponsorContact)) continue;
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("isInScope called for AwardSponsorContact (contactType=%s) with scopes = %s returning false.", sponsorContact.getContactType().getContactTypeCode(), ArrayUtils.toString((Object)scopes)));
        }
        return false;
    }

    public boolean isInScope(AwardSponsorContact sponsorContact) {
        boolean result = false;
        if (this.equals((Object)SPONSOR_CONTACTS_TAB)) {
            result = true;
        }
        return result;
    }

    public static boolean isInScope(AwardTemplateContact templateContact, AwardTemplateSyncScope[] scopes) {
        for (AwardTemplateSyncScope scope : scopes) {
            if (!scope.isInScope(templateContact)) continue;
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("isInScope called for AwardTemplateContact (contactType=%s) with scopes = %s returning false.", templateContact.getContactType().getContactTypeCode(), ArrayUtils.toString((Object)scopes)));
        }
        return false;
    }

    public boolean isInScope(AwardTemplateContact templateContact) {
        boolean result = false;
        if (this.equals((Object)SPONSOR_CONTACTS_TAB)) {
            result = true;
        }
        return result;
    }

    private boolean isReportTermInScope(String reportCode, String reportClassCode) {
        boolean result = false;
        result = ArrayUtils.contains((Object[])this.getSyncScopeParameters("AwardReportTerm", "reportClassCode"), (Object)reportClassCode);
        return result;
    }

    private boolean isAwardCommentInScope(String commentTypeCode) {
        boolean result = false;
        result = ArrayUtils.contains((Object[])this.getSyncScopeParameters("AwardComment", "commentTypeCode"), (Object)commentTypeCode);
        return result;
    }

    public String[] getSyncScopeParameters(String syncClass, String syncField) {
        String[] values = new String[]{};
        try {
            String settingValue = ((ParameterService)KraServiceLocator.getService(ParameterService.class)).getParameterValueAsString(AwardDocument.class, String.format("scope.sync.%s.%s.%s", this.toString(), syncClass, syncField));
            values = settingValue == null ? new String[]{} : StringUtils.split((String)settingValue, (String)",");
        }
        catch (Error e) {
            LOG.error((Object)String.format("Error returned from parameter lookup scope.sync.%s.%s.%s failed, defaulting to empty list.  Error: %s", this.toString(), syncClass, syncField, e.getMessage()));
        }
        return values;
    }

    static {
        LOG = LogFactory.getLog(AwardTemplateSyncScope.class);
    }
}

