/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.awardhierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.bo.versioning.VersionHistory;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.ServiceHelper;
import org.kuali.kra.service.VersionHistoryService;
import org.kuali.rice.krad.service.BusinessObjectService;

/*
 * Exception performing whole class analysis ignored.
 */
public class AwardHierarchy
extends KraPersistableBusinessObjectBase
implements Cloneable {
    public static final String ROOTS_PARENT_AWARD_NUMBER = "000000-00000";
    public static final String UNIQUE_IDENTIFIER_FIELD = "awardNumber";
    private static final long serialVersionUID = 1L;
    private Long awardHierarchyId;
    private String rootAwardNumber;
    private String awardNumber;
    private String parentAwardNumber;
    private String originatingAwardNumber = "000000-00000";
    private AwardHierarchy root;
    private AwardHierarchy parent;
    private Boolean active = true;
    private transient Award award;
    private transient List<AwardHierarchy> children = new ArrayList();
    private transient BusinessObjectService boService;
    private transient VersionHistoryService versionHistoryService;

    public AwardHierarchy() {
    }

    public AwardHierarchy(AwardHierarchy rootNode, AwardHierarchy parentNode, String awardNumber, String originatingAwardNumber) {
        this();
        this.setRoot(rootNode);
        this.setParent(parentNode);
        this.setAwardNumber(awardNumber);
        this.setOriginatingAwardNumber(originatingAwardNumber);
    }

    public AwardHierarchy(String rootAwardNumber, String parentAwardNumber, String awardNumber, String originatingAwardNumber) {
        this();
        this.rootAwardNumber = rootAwardNumber;
        this.parentAwardNumber = parentAwardNumber;
        this.awardNumber = awardNumber;
        this.originatingAwardNumber = originatingAwardNumber;
    }

    public AwardHierarchy(String rootAwardNumber, String parentAwardNumber, String awardNumber) {
        this(rootAwardNumber, parentAwardNumber, awardNumber, awardNumber);
    }

    public int childCount() {
        return this.getChildren().size();
    }

    public static AwardHierarchy createRootNode(Award award) {
        AwardHierarchy rootNode = AwardHierarchy.createRootNode((String)award.getAwardNumber());
        rootNode.setAward(award);
        return rootNode;
    }

    public static AwardHierarchy createRootNode(String awardNumber) {
        return new AwardHierarchy(awardNumber, "000000-00000", awardNumber, awardNumber);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwardHierarchy)) {
            return false;
        }
        AwardHierarchy other = (AwardHierarchy)obj;
        if (this.awardNumber == null ? other.awardNumber != null : !this.awardNumber.equals(other.awardNumber)) {
            return false;
        }
        if (this.parentAwardNumber == null ? other.parentAwardNumber != null : !this.parentAwardNumber.equals(other.parentAwardNumber)) {
            return false;
        }
        return !(this.rootAwardNumber == null ? other.rootAwardNumber != null : !this.rootAwardNumber.equals(other.rootAwardNumber));
    }

    public Award getAward() {
        if (this.award == null) {
            this.lazyLoadAward();
        }
        return this.award;
    }

    public Long getAwardHierarchyId() {
        return this.awardHierarchyId;
    }

    public String getAwardNumber() {
        return this.awardNumber;
    }

    public List<AwardHierarchy> getChildren() {
        return this.children;
    }

    public String getOriginatingAwardNumber() {
        return this.originatingAwardNumber;
    }

    public AwardHierarchy getParent() {
        if (!this.isRootNode() && this.parent == null && this.parentAwardNumber != null) {
            this.parent = this.findAwardHierarchyMatchingAwardNumber(this.parentAwardNumber);
        }
        return this.parent;
    }

    public String getParentAwardNumber() {
        return this.parentAwardNumber;
    }

    public AwardHierarchy getRoot() {
        if (this.isRootNode()) {
            this.root = this;
        } else if (this.root == null && this.rootAwardNumber != null) {
            this.root = this.findAwardHierarchyMatchingAwardNumber(this.rootAwardNumber);
        }
        return this.root;
    }

    public List<AwardHierarchy> getFlattenedListOfNodesInHierarchy() {
        ArrayList<AwardHierarchy> list = new ArrayList<AwardHierarchy>();
        this.addNodeToFlattenedList(list, this.findRootNode());
        return list;
    }

    public Map<String, AwardHierarchy> getMapOfNodesInHierarchy() {
        TreeMap<String, AwardHierarchy> nodeMap = new TreeMap<String, AwardHierarchy>();
        List nodes = this.getFlattenedListOfNodesInHierarchy();
        for (AwardHierarchy node : nodes) {
            nodeMap.put(node.getAwardNumber(), node);
        }
        return nodeMap;
    }

    public String getRootAwardNumber() {
        return this.rootAwardNumber;
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.awardNumber == null ? 0 : this.awardNumber.hashCode());
        result = 31 * result + (this.parentAwardNumber == null ? 0 : this.parentAwardNumber.hashCode());
        result = 31 * result + (this.rootAwardNumber == null ? 0 : this.rootAwardNumber.hashCode());
        return result;
    }

    public boolean isRootNode() {
        return this.awardNumber.equals(this.rootAwardNumber);
    }

    public AwardHierarchy findNodeInHierarchy(String awardNumber) {
        AwardHierarchy rootNode = this.findRootNode(this);
        return this.findNode(rootNode, awardNumber);
    }

    public String generateNextAwardNumberInSequence() {
        List list = this.getFlattenedListOfNodesInHierarchy();
        TreeSet<String> awardNumberSet = new TreeSet<String>();
        for (AwardHierarchy node : list) {
            awardNumberSet.add(node.getAwardNumber());
        }
        ArrayList orderedList = new ArrayList(awardNumberSet);
        String maximumAwardNumber = (String)orderedList.get(orderedList.size() - 1);
        String[] parts = maximumAwardNumber.split("-");
        Integer nextVal = Integer.valueOf(parts[1]) + 1;
        return String.format("%s-%05d", parts[0], nextVal);
    }

    public void setAward(Award award) {
        this.award = award;
    }

    public void setAwardHierarchyId(Long awardHierarchyId) {
        this.awardHierarchyId = awardHierarchyId;
    }

    public void setAwardNumber(String awardNumber) {
        this.awardNumber = awardNumber;
    }

    public void setChildren(List<AwardHierarchy> children) {
        this.children = children;
    }

    public void setOriginatingAwardNumber(String originatingDocumentNumber) {
        this.originatingAwardNumber = originatingDocumentNumber;
    }

    public void setParent(AwardHierarchy parent) {
        this.parent = parent;
        this.parentAwardNumber = parent != null ? parent.getAwardNumber() : "000000-00000";
    }

    public void setParentAwardNumber(String parentAwardNumber) {
        this.parentAwardNumber = parentAwardNumber;
    }

    public void setRoot(AwardHierarchy root) {
        this.root = root;
        this.rootAwardNumber = root != null ? root.getAwardNumber() : null;
    }

    public void setRootAwardNumber(String rootAwardNumber) {
        this.rootAwardNumber = rootAwardNumber;
    }

    public int hierarchySize() {
        return this.getFlattenedListOfNodesInHierarchy().size();
    }

    public boolean isNew() {
        return this.awardHierarchyId == null;
    }

    public boolean isPersisted() {
        return !this.isNew();
    }

    void addNodeToFlattenedList(List<AwardHierarchy> list, AwardHierarchy parentNode) {
        list.add(parentNode);
        if (parentNode.hasChildren()) {
            for (AwardHierarchy childNode : parentNode.getChildren()) {
                this.addNodeToFlattenedList(list, childNode);
            }
        }
    }

    void setBusinessObjectService(BusinessObjectService boService) {
        this.boService = boService;
    }

    void setVersionHistoryService(VersionHistoryService versionHistoryService) {
        this.versionHistoryService = versionHistoryService;
    }

    BusinessObjectService getBusinessObjectService() {
        if (this.boService == null) {
            this.boService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        }
        return this.boService;
    }

    VersionHistoryService getVersionHistoryService() {
        if (this.versionHistoryService == null) {
            this.versionHistoryService = (VersionHistoryService)KraServiceLocator.getService(VersionHistoryService.class);
        }
        return this.versionHistoryService;
    }

    AwardHierarchy findNode(AwardHierarchy testNode, String awardNumber) {
        AwardHierarchy foundNode;
        block2: {
            AwardHierarchy node;
            block1: {
                foundNode = null;
                if (!testNode.getAwardNumber().equals(awardNumber)) break block1;
                foundNode = testNode;
                break block2;
            }
            if (!testNode.hasChildren()) break block2;
            Iterator i$ = testNode.getChildren().iterator();
            while (i$.hasNext() && (foundNode = this.findNode(node = (AwardHierarchy)i$.next(), awardNumber)) == null) {
            }
        }
        return foundNode;
    }

    AwardHierarchy findRootNode() {
        return this.findRootNode(this);
    }

    private AwardHierarchy findAwardHierarchyMatchingAwardNumber(String searchAwardNumber) {
        Map map = ServiceHelper.getInstance().buildCriteriaMap(new String[]{"awardNumber", "active"}, new Object[]{searchAwardNumber, Boolean.TRUE});
        Collection c = this.getBusinessObjectService().findMatching(AwardHierarchy.class, map);
        return c.size() == 1 ? (AwardHierarchy)c.iterator().next() : null;
    }

    private AwardHierarchy findRootNode(AwardHierarchy testNode) {
        return testNode.isRootNode() ? testNode : this.findRootNode(testNode.getParent());
    }

    private void lazyLoadAward() {
        List histories;
        VersionHistory vh = this.getVersionHistoryService().findActiveVersion(Award.class, this.awardNumber);
        this.award = vh != null ? (Award)vh.getSequenceOwner() : ((histories = this.getVersionHistoryService().loadVersionHistory(Award.class, this.awardNumber)).size() == 1 ? (Award)((VersionHistory)histories.get(0)).getSequenceOwner() : null);
    }

    public AwardHierarchy clone() {
        AwardHierarchy copy = null;
        try {
            copy = (AwardHierarchy)super.clone();
            ArrayList<AwardHierarchy> copyChildren = new ArrayList<AwardHierarchy>();
            for (AwardHierarchy child : this.getChildren()) {
                copyChildren.add(child.clone());
            }
            copy.setChildren(copyChildren);
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return copy;
    }

    public Boolean isActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }
}

