/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.awardhierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.SequenceOwner;
import org.kuali.kra.award.AwardAmountInfoService;
import org.kuali.kra.award.AwardNumberService;
import org.kuali.kra.award.awardhierarchy.AwardHierarchy;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyService;
import org.kuali.kra.award.awardhierarchy.MissingHierarchyException;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.home.AwardComment;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.award.paymentreports.ReportClass;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTerm;
import org.kuali.kra.award.version.service.AwardVersionService;
import org.kuali.kra.bo.versioning.VersionHistory;
import org.kuali.kra.bo.versioning.VersionStatus;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.ServiceHelper;
import org.kuali.kra.service.VersionException;
import org.kuali.kra.service.VersionHistoryService;
import org.kuali.kra.service.VersioningService;
import org.kuali.kra.service.impl.ObjectCopyUtils;
import org.kuali.kra.timeandmoney.AwardHierarchyNode;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.kra.timeandmoney.service.ActivePendingTransactionsService;
import org.kuali.kra.timeandmoney.transactions.PendingTransaction;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class AwardHierarchyServiceImpl
implements AwardHierarchyService {
    private static final Log LOG = LogFactory.getLog(AwardHierarchyServiceImpl.class);
    private static final String DOCUMENT_DESCRIPTION_FIELD_NAME = "documentDescription";
    AwardNumberService awardNumberService;
    BusinessObjectService businessObjectService;
    DocumentService documentService;
    VersioningService versioningService;
    VersionHistoryService versionHistoryService;
    AwardAmountInfoService awardAmountInfoService;
    ActivePendingTransactionsService activePendingTransactionsService;
    ParameterService parameterService;
    private AwardService awardService;
    AwardVersionService awardVersionService;

    public AwardHierarchy copyAwardAndAllDescendantsAsNewHierarchy(AwardHierarchy targetNode) {
        String newRootAwardNumber = this.awardNumberService.getNextAwardNumber();
        AwardHierarchy newRootNode = this.createBasicHierarchy(newRootAwardNumber);
        Award newRootAward = this.copyAward(targetNode.getAward(), newRootAwardNumber);
        newRootNode.setAward(newRootAward);
        this.finalizeAward(newRootAward);
        for (AwardHierarchy childNode : targetNode.getChildren()) {
            this.copyNodeRecursively(childNode, newRootNode, newRootNode);
        }
        return newRootNode;
    }

    public AwardHierarchy copyAwardAndDescendantsAsChildOfAnAwardInAnotherHierarchy(AwardHierarchy sourceNode, AwardHierarchy targetParentNode) {
        return this.copyAwardAndDescendantsAsChildOfAnotherNode(sourceNode, targetParentNode);
    }

    public AwardHierarchy copyAwardAndDescendantsAsChildOfAnAwardInCurrentHierarchy(AwardHierarchy sourceNode, AwardHierarchy targetParentNode) {
        return this.copyAwardAndDescendantsAsChildOfAnotherNode(sourceNode, targetParentNode);
    }

    public AwardHierarchy copyAwardAsChildOfAnAwardInAnotherHierarchy(AwardHierarchy sourceNode, AwardHierarchy targetParentNode) {
        return this.copyAwardAsChildOfAnotherNode(sourceNode, targetParentNode);
    }

    public AwardHierarchy copyAwardAsChildOfAnAwardInCurrentHierarchy(AwardHierarchy sourceNode, AwardHierarchy targetParentNode) {
        return this.copyAwardAsChildOfAnotherNode(sourceNode, targetParentNode);
    }

    public AwardHierarchy copyAwardAsNewHierarchy(AwardHierarchy targetNode) {
        String nextAwardNumber = this.awardNumberService.getNextAwardNumber();
        Award newAward = this.copyAward(targetNode.getAward(), nextAwardNumber);
        newAward.setAwardEffectiveDate(null);
        int indexOfLatestAwardVersion = newAward.getAwardAmountInfos().size() - 1;
        ((AwardAmountInfo)newAward.getAwardAmountInfos().get(indexOfLatestAwardVersion)).setFinalExpirationDate(null);
        ((AwardAmountInfo)newAward.getAwardAmountInfos().get(indexOfLatestAwardVersion)).setObligationExpirationDate(null);
        ((AwardAmountInfo)newAward.getAwardAmountInfos().get(indexOfLatestAwardVersion)).setCurrentFundEffectiveDate(null);
        newAward.setAwardDirectFandADistributions(new ArrayList());
        AwardHierarchy newNode = this.createBasicHierarchy(nextAwardNumber);
        newNode.setAward(newAward);
        return newNode;
    }

    public AwardHierarchy createBasicHierarchy(String awardNumber) {
        return new AwardHierarchy(awardNumber, "000000-00000", awardNumber, awardNumber);
    }

    public AwardHierarchy createNewAwardBasedOnAnotherAwardInHierarchy(AwardHierarchy nodeToCopyFrom, AwardHierarchy targetParentNode) {
        return this.copyAwardAsChildOfAnotherNode(nodeToCopyFrom, targetParentNode);
    }

    public void copyAwardAmountDateInfo(Award source, Award copy) {
        ArrayList<AwardAmountInfo> awardAmountInfoList = new ArrayList<AwardAmountInfo>();
        AwardAmountInfo initialInfo = new AwardAmountInfo();
        AwardAmountInfo awardAmount = source.getLastAwardAmountInfo();
        AwardAmountInfo awardAmountInfo = new AwardAmountInfo();
        awardAmountInfo.setFinalExpirationDate(awardAmount.getFinalExpirationDate());
        awardAmountInfo.setCurrentFundEffectiveDate(awardAmount.getCurrentFundEffectiveDate());
        awardAmountInfo.setObligationExpirationDate(awardAmount.getObligationExpirationDate());
        initialInfo.setFinalExpirationDate(awardAmount.getFinalExpirationDate());
        initialInfo.setCurrentFundEffectiveDate(awardAmount.getCurrentFundEffectiveDate());
        initialInfo.setObligationExpirationDate(awardAmount.getObligationExpirationDate());
        awardAmountInfo.setAward(copy);
        initialInfo.setAward(copy);
        if (awardAmount.getOriginatingAwardVersion() != null) {
            awardAmountInfo.setOriginatingAwardVersion(Integer.valueOf(1));
        }
        awardAmountInfoList.add(initialInfo);
        awardAmountInfoList.add(awardAmountInfo);
        copy.setAwardAmountInfos(awardAmountInfoList);
    }

    public AwardHierarchy createNewAwardBasedOnParent(AwardHierarchy targetNode) {
        String nextAwardNumber = targetNode.generateNextAwardNumberInSequence();
        Award newAward = this.copyAward(targetNode.getAward(), nextAwardNumber);
        AwardHierarchy newNode = new AwardHierarchy(targetNode.getRoot(), targetNode, nextAwardNumber, targetNode.getAward().getAwardNumber());
        newNode.setAward(newAward);
        targetNode.getChildren().add(newNode);
        return newNode;
    }

    public void copyAwardAmountDateInfoToNewChild(Award source, Award copy) {
        AwardAmountInfo parentAai = (AwardAmountInfo)source.getAwardAmountInfos().get(source.getAwardAmountInfos().size() - 1);
        AwardAmountInfo awardAmountInfo = new AwardAmountInfo();
        awardAmountInfo.setFinalExpirationDate(parentAai.getFinalExpirationDate());
        awardAmountInfo.setCurrentFundEffectiveDate(parentAai.getCurrentFundEffectiveDate());
        awardAmountInfo.setObligationExpirationDate(parentAai.getObligationExpirationDate());
        awardAmountInfo.setAward(copy);
        copy.setAwardAmountInfos(new ArrayList());
        copy.getAwardAmountInfos().add(awardAmountInfo);
    }

    public AwardHierarchy createNewChildAward(AwardHierarchy targetNode) {
        Award newAward = new Award();
        Award copyDateAward = targetNode.getAward();
        newAward.setAwardNumber(targetNode.generateNextAwardNumberInSequence());
        AwardHierarchy newNode = new AwardHierarchy(targetNode.getRoot(), targetNode, newAward.getAwardNumber(), newAward.getAwardNumber());
        this.copyAwardAmountDateInfoToNewChild(copyDateAward, newAward);
        newNode.setAward(newAward);
        targetNode.getChildren().add(newNode);
        return newNode;
    }

    public AwardHierarchy loadAwardHierarchy(String awardNumber) {
        return awardNumber == null || awardNumber.equals("000000-00000") ? null : this.loadAwardHierarchyBranch(awardNumber);
    }

    public AwardHierarchy loadAwardHierarchyBranch(String awardNumber) {
        Map hierarchy = this.getAwardHierarchy(awardNumber, new ArrayList());
        return (AwardHierarchy)hierarchy.get(awardNumber);
    }

    public Map<String, AwardHierarchy> getAwardHierarchy(AwardHierarchy anyNode, List<String> order) {
        HashMap<String, AwardHierarchy> result = new HashMap<String, AwardHierarchy>();
        if (anyNode == null) {
            return result;
        }
        HashMap<String, Object> values = new HashMap<String, Object>();
        String rootAwardNumber = StringUtils.equals((String)"000000-00000", (String)anyNode.getRootAwardNumber()) ? anyNode.getAwardNumber() : anyNode.getRootAwardNumber();
        values.put("rootAwardNumber", rootAwardNumber);
        values.put("active", true);
        List hierarchyList = (List)this.businessObjectService.findMatchingOrderBy(AwardHierarchy.class, values, "awardNumber", true);
        if (!hierarchyList.isEmpty()) {
            for (AwardHierarchy hierarchy : hierarchyList) {
                result.put(hierarchy.getAwardNumber(), hierarchy);
                hierarchy.getChildren().clear();
            }
            AwardHierarchy rootNode = (AwardHierarchy)result.get(rootAwardNumber);
            for (AwardHierarchy hierarchy : result.values()) {
                hierarchy.setRoot(rootNode);
                AwardHierarchy parent = (AwardHierarchy)result.get(hierarchy.getParentAwardNumber());
                if (parent == null) continue;
                parent.getChildren().add(hierarchy);
                hierarchy.setParent(parent);
            }
            LinkedList<AwardHierarchy> queue = new LinkedList<AwardHierarchy>();
            queue.add(rootNode);
            while (!queue.isEmpty()) {
                AwardHierarchy node = (AwardHierarchy)queue.poll();
                order.add(node.getAwardNumber());
                queue.addAll(node.getChildren());
            }
        }
        return result;
    }

    public Map<String, AwardHierarchy> getAwardHierarchy(String awardNumber, List<String> order) {
        return this.getAwardHierarchy(this.loadSingleAwardHierarchyNode(awardNumber), order);
    }

    public AwardHierarchy loadFullHierarchyFromAnyNode(String awardNumber) {
        ArrayList order = new ArrayList();
        Map hierarchy = this.getAwardHierarchy(awardNumber, order);
        if (!order.isEmpty()) {
            return (AwardHierarchy)hierarchy.get(order.get(0));
        }
        return null;
    }

    public AwardDocument loadPlaceholderDocument() {
        DocumentHeader header = this.findPlaceholderDocumentHeader();
        try {
            return header != null ? (AwardDocument)this.documentService.getByDocumentHeaderId(header.getDocumentNumber()) : this.createPlaceholderDocument();
        }
        catch (WorkflowException e) {
            throw this.uncheckedException((Exception)((Object)e));
        }
    }

    public void persistAwardHierarchy(AwardHierarchy node) {
        if (node.isNew()) {
            this.businessObjectService.save((PersistableBusinessObject)node);
        }
    }

    public void persistAwardHierarchies(Collection<AwardHierarchy> rootNodes) {
        if (rootNodes == null || rootNodes.size() == 0) {
            return;
        }
        for (AwardHierarchy rootNode : rootNodes) {
            this.persistAwardHierarchy(rootNode, true);
        }
    }

    public void persistAwardHierarchy(AwardHierarchy branchNode, boolean recurse) {
        AwardDocument placeholderDocument = this.loadPlaceholderDocument();
        if (placeholderDocument != null) {
            int startingAwardCount = placeholderDocument.getAwardList().size();
            if (branchNode.hasChildren() && recurse) {
                List nodes = branchNode.getFlattenedListOfNodesInHierarchy();
                for (AwardHierarchy node : nodes) {
                    this.saveNodeWithAward(node, placeholderDocument);
                }
            } else {
                this.saveNodeWithAward(branchNode, placeholderDocument);
            }
            if (placeholderDocument.getAwardList().size() > startingAwardCount) {
                this.savePlaceholderDocument(placeholderDocument);
            }
        }
    }

    public void setAwardNumberService(AwardNumberService awardNumberService) {
        this.awardNumberService = awardNumberService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setVersioningService(VersioningService versioningService) {
        this.versioningService = versioningService;
    }

    protected AwardHierarchy getRootNode(String rootAwardNumber) {
        return this.loadAwardHierarchy(rootAwardNumber);
    }

    Award copyAward(Award award, String nextAwardNumber) {
        Award newAward;
        try {
            String originalAwardNumber = award.getAwardNumber();
            Integer originalSequenceNumber = award.getSequenceNumber();
            ObjectCopyUtils.prepareObjectForDeepCopy((PersistableBusinessObject)award);
            AwardDocument document = award.getAwardDocument();
            award.setAwardDocument(null);
            newAward = this.useOriginalAwardAsTemplateForCopy(award, nextAwardNumber);
            this.restoreOriginalAwardPropertiesAfterCopy(award, originalAwardNumber, originalSequenceNumber);
            award.setAwardDocument(document);
            this.copyAwardAmountDateInfo(award, newAward);
            ArrayList awardSpecialReviews = new ArrayList();
            newAward.setSpecialReviews(awardSpecialReviews);
            this.clearFilteredAttributes(newAward);
            this.getAwardService().synchNewCustomAttributes(newAward, award);
        }
        catch (Exception e) {
            throw this.uncheckedException(e);
        }
        return newAward;
    }

    protected void clearFilteredAttributes(Award newAward) {
        newAward.setAccountNumber(null);
        newAward.setFinancialAccountCreationDate(null);
        newAward.setFinancialAccountDocumentNumber(null);
        newAward.setFinancialChartOfAccountsCode(null);
        newAward.setNoticeDate(null);
        newAward.getFundingProposals().clear();
        newAward.setAwardApprovedSubawards(new ArrayList());
        newAward.setApprovedEquipmentItems(new ArrayList());
        newAward.setApprovedForeignTravelTrips(new ArrayList());
        newAward.setAwardNotepads(new ArrayList());
        try {
            String defaultTxnTypeStr = this.parameterService.getParameterValueAsString("KC-AWARD", "Document", "TXN_TYPE_DEF_COPIED_AWARD");
            if (StringUtils.isNotEmpty((String)defaultTxnTypeStr)) {
                newAward.setAwardTransactionTypeCode(Integer.valueOf(Integer.parseInt(defaultTxnTypeStr)));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        newAward.setAwardCloseoutItems(new ArrayList());
        for (AwardComment comment : newAward.getAwardComments()) {
            if (!StringUtils.equals((String)"21", (String)comment.getCommentType().getCommentTypeCode())) continue;
            comment.setComments("Copied Award");
        }
        newAward.getAwardAttachments().clear();
        newAward.getSyncChanges().clear();
        newAward.getSyncStatuses().clear();
        newAward.getAwardBudgetLimits().clear();
        ArrayList<AwardReportTerm> newTerms = new ArrayList<AwardReportTerm>();
        String paymentReportClassCode = this.getPaymentAndInvoicesReportClass().getReportClassCode();
        for (AwardReportTerm term : newAward.getAwardReportTermItems()) {
            if (StringUtils.equals((String)paymentReportClassCode, (String)term.getReportClassCode())) continue;
            newTerms.add(term);
        }
        newAward.setAwardReportTermItems(newTerms);
        newAward.getPaymentScheduleItems().clear();
    }

    protected ReportClass getPaymentAndInvoicesReportClass() {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("DESCRIPTION", "Payment/Invoice");
        ReportClass reportClass = (ReportClass)this.businessObjectService.findMatching(ReportClass.class, param).iterator().next();
        return reportClass;
    }

    AwardHierarchy copyAwardAsChildOfAnotherNode(AwardHierarchy sourceNode, AwardHierarchy targetParentNode) {
        String newAwardNumber = targetParentNode.generateNextAwardNumberInSequence();
        AwardHierarchy newLeafNode = new AwardHierarchy(targetParentNode.getRoot(), targetParentNode, newAwardNumber, sourceNode.getOriginatingAwardNumber());
        Award newLeafAward = this.copyAward(sourceNode.getAward(), newAwardNumber);
        newLeafNode.setAward(newLeafAward);
        targetParentNode.getChildren().add(newLeafNode);
        return newLeafNode;
    }

    protected AwardHierarchy getCopyOfSourceNode(AwardHierarchy sourceNode) {
        AwardHierarchy newSource = sourceNode.clone();
        return newSource;
    }

    AwardHierarchy copyAwardAndDescendantsAsChildOfAnotherNode(AwardHierarchy sourceNode, AwardHierarchy targetParentNode) {
        String newAwardNumber = targetParentNode.generateNextAwardNumberInSequence();
        AwardHierarchy newSource = this.getCopyOfSourceNode(sourceNode);
        List<AwardHierarchy> sourceChildren = Collections.unmodifiableList(newSource.getChildren());
        AwardHierarchy newBranchNode = new AwardHierarchy(targetParentNode.getRoot(), targetParentNode, newAwardNumber, sourceNode.getOriginatingAwardNumber());
        Award newBranchAward = this.copyAward(sourceNode.getAward(), newAwardNumber);
        this.finalizeAward(newBranchAward);
        targetParentNode.getChildren().add(newBranchNode);
        newBranchNode.setAward(newBranchAward);
        for (AwardHierarchy childNode : sourceChildren) {
            this.copyNodeRecursively(childNode, newBranchNode, targetParentNode.getRoot());
        }
        return newBranchNode;
    }

    protected void finalizeAward(Award newAward) {
        this.versionHistoryService.updateVersionHistory((SequenceOwner)newAward, VersionStatus.ACTIVE, GlobalVariables.getUserSession().getPrincipalName());
        this.awardService.updateAwardSequenceStatus(newAward, VersionStatus.ACTIVE);
    }

    void copyNodeRecursively(AwardHierarchy sourceNode, AwardHierarchy newParentNode, AwardHierarchy newRootNode) {
        String nextAwardNumberInHierarchy = newParentNode.generateNextAwardNumberInSequence();
        List<AwardHierarchy> sourceChildren = Collections.unmodifiableList(sourceNode.getChildren());
        AwardHierarchy newNode = new AwardHierarchy(newRootNode, newParentNode, nextAwardNumberInHierarchy, sourceNode.getOriginatingAwardNumber());
        Award newAward = this.copyAward(sourceNode.getAward(), nextAwardNumberInHierarchy);
        newNode.setAward(newAward);
        newParentNode.getChildren().add(newNode);
        this.finalizeAward(newAward);
        for (AwardHierarchy childNode : sourceChildren) {
            this.copyNodeRecursively(childNode, newNode, newRootNode);
        }
    }

    AwardDocument createPlaceholderDocument() throws WorkflowException {
        AwardDocument document = (AwardDocument)this.documentService.getNewDocument(AwardDocument.class);
        if (document != null) {
            document.getDocumentHeader().setDocumentDescription("*****PLACEHOLDER*****");
            document.getAwardList().clear();
            this.documentService.saveDocument((Document)document);
            LOG.info((Object)("Created Placeholder Document #" + document.getDocumentNumber()));
        }
        return document;
    }

    DocumentHeader findPlaceholderDocumentHeader() {
        Collection c = this.businessObjectService.findMatching(DocumentHeader.class, this.getDocumentDescriptionCriteriaMap());
        return !c.isEmpty() ? (DocumentHeader)c.iterator().next() : null;
    }

    AwardHierarchy loadSingleAwardHierarchyNode(String awardNumber) {
        return (AwardHierarchy)this.businessObjectService.findByPrimaryKey(AwardHierarchy.class, this.getAwardHierarchyCriteriaMap(awardNumber));
    }

    Map<String, Object> getDocumentDescriptionCriteriaMap() {
        return ServiceHelper.getInstance().buildCriteriaMap(DOCUMENT_DESCRIPTION_FIELD_NAME, (Object)"*****PLACEHOLDER*****");
    }

    protected void addNewAwardToPlaceholderDocument(AwardDocument doc, AwardHierarchy node) {
        Award award = node.getAward();
        if (award.isNew()) {
            doc.getAwardList().add(award);
        }
    }

    protected AwardHierarchy getAwardHierarchyRootNode(String someNodeAwardNumberInHierarchy) {
        Collection c = this.businessObjectService.findMatching(AwardHierarchy.class, this.getAwardHierarchyCriteriaMap(someNodeAwardNumberInHierarchy));
        AwardHierarchy someNodeInHierarchy = null;
        if (c.size() == 1) {
            someNodeInHierarchy = (AwardHierarchy)c.iterator().next();
        }
        if (someNodeInHierarchy == null) {
            throw new MissingHierarchyException(someNodeAwardNumberInHierarchy);
        }
        return this.getRootNode(someNodeInHierarchy.getRootAwardNumber());
    }

    protected Map<String, Object> getAwardHierarchyCriteriaMap(String awardNumber) {
        return ServiceHelper.getInstance().buildCriteriaMap(new String[]{"awardNumber", "active"}, new Object[]{awardNumber, Boolean.TRUE});
    }

    protected void restoreOriginalAwardPropertiesAfterCopy(Award award, String originalAwardNumber, Integer originalSequenceNumber) {
        award.setAwardNumber(originalAwardNumber);
        award.setSequenceNumber(originalSequenceNumber);
    }

    protected void saveNodeWithAward(AwardHierarchy node, AwardDocument doc) {
        if (node.isNew()) {
            this.persistAwardHierarchy(node);
            this.addNewAwardToPlaceholderDocument(doc, node);
        }
    }

    protected void savePlaceholderDocument(AwardDocument doc) {
        try {
            this.documentService.saveDocument((Document)doc);
        }
        catch (WorkflowException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected RuntimeException uncheckedException(Exception e) {
        return new RuntimeException(e.getMessage(), e);
    }

    protected Award useOriginalAwardAsTemplateForCopy(Award award, String nextAwardNumber) throws VersionException {
        award.setAwardNumber(nextAwardNumber);
        award.setSequenceNumber(Integer.valueOf(0));
        return (Award)this.versioningService.createNewVersion((SequenceOwner)award);
    }

    public void populateAwardHierarchyNodes(Map<String, AwardHierarchy> awardHierarchyItems, Map<String, AwardHierarchyNode> awardHierarchyNodes, String currentAwardNumber, String currentSequenceNumber) {
        String tmpAwardNumber = null;
        for (Map.Entry<String, AwardHierarchy> awardHierarchy : awardHierarchyItems.entrySet()) {
            tmpAwardNumber = awardHierarchy.getValue().getAwardNumber();
            if (awardHierarchyNodes.get(tmpAwardNumber) != null) continue;
            AwardHierarchyNode awardHierarchyNode = this.createAwardHierarchyNode(awardHierarchy.getValue(), currentAwardNumber, currentSequenceNumber);
            awardHierarchyNodes.put(awardHierarchyNode.getAwardNumber(), awardHierarchyNode);
        }
    }

    public AwardHierarchyNode createAwardHierarchyNode(AwardHierarchy awardHierarchy, String currentAwardNumber, String currentSequenceNumber) {
        String awardNumber = awardHierarchy.getAwardNumber();
        AwardHierarchyNode awardHierarchyNode = new AwardHierarchyNode();
        awardHierarchyNode.setAwardNumber(awardNumber);
        awardHierarchyNode.setParentAwardNumber(awardHierarchy.getParentAwardNumber());
        awardHierarchyNode.setRootAwardNumber(awardHierarchy.getRootAwardNumber());
        VersionHistory pendingVersionHistory = this.versionHistoryService.findPendingVersion(Award.class, awardNumber);
        VersionHistory activeVersionHistory = this.versionHistoryService.findActiveVersion(Award.class, awardNumber);
        Award award = this.awardVersionService.getWorkingAwardVersion(awardNumber);
        if (award == null) {
            award = this.getAwardFromDatabase(awardNumber);
        }
        AwardAmountInfo awardAmountInfo = this.awardAmountInfoService.fetchAwardAmountInfoWithHighestTransactionId(award.getAwardAmountInfos());
        awardHierarchyNode.setFinalExpirationDate(awardAmountInfo.getFinalExpirationDate());
        awardHierarchyNode.setLeadUnitName(award.getUnitName());
        awardHierarchyNode.setPrincipalInvestigatorName(award.getPrincipalInvestigatorName());
        awardHierarchyNode.setAccountNumber(award.getAccountNumber());
        awardHierarchyNode.setAwardStatusCode(award.getStatusCode());
        awardHierarchyNode.setObliDistributableAmount(awardAmountInfo.getObliDistributableAmount());
        awardHierarchyNode.setAmountObligatedToDate(awardAmountInfo.getAmountObligatedToDate());
        awardHierarchyNode.setObligatedTotalDirect(awardAmountInfo.getObligatedTotalDirect());
        awardHierarchyNode.setObligatedTotalIndirect(awardAmountInfo.getObligatedTotalIndirect());
        awardHierarchyNode.setAnticipatedTotalAmount(awardAmountInfo.getAnticipatedTotalAmount());
        awardHierarchyNode.setAnticipatedTotalDirect(awardAmountInfo.getAnticipatedTotalDirect());
        awardHierarchyNode.setAnticipatedTotalIndirect(awardAmountInfo.getAnticipatedTotalIndirect());
        awardHierarchyNode.setAntDistributableAmount(awardAmountInfo.getAntDistributableAmount());
        awardHierarchyNode.setCurrentFundEffectiveDate(awardAmountInfo.getCurrentFundEffectiveDate());
        awardHierarchyNode.setObligationExpirationDate(awardAmountInfo.getObligationExpirationDate());
        awardHierarchyNode.setProjectStartDate(award.getAwardEffectiveDate());
        awardHierarchyNode.setTitle(award.getTitle());
        awardHierarchyNode.setAwardId(award.getAwardId());
        awardHierarchyNode.setAwardDocumentNumber(award.getAwardDocument().getDocumentNumber());
        awardHierarchyNode.setHasChildren(Boolean.valueOf(!awardHierarchy.getChildren().isEmpty()));
        awardHierarchyNode.setAwardDocumentFinalStatus(Boolean.valueOf(pendingVersionHistory == null && activeVersionHistory != null));
        return awardHierarchyNode;
    }

    private Award getAwardFromDatabase(String awardNumber) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("awardNumber", awardNumber);
        List awardList = (List)this.businessObjectService.findMatchingOrderBy(Award.class, map, "sequenceNumber", true);
        Award returnVal = (Award)awardList.get(awardList.size() - 1);
        return returnVal;
    }

    public void populateAwardHierarchyNodesForTandMDoc(Map<String, AwardHierarchy> awardHierarchyItems, Map<String, AwardHierarchyNode> awardHierarchyNodes, String currentAwardNumber, String currentSequenceNumber, TimeAndMoneyDocument timeAndMoneyDocument) {
        String tmpAwardNumber = null;
        for (Map.Entry<String, AwardHierarchy> awardHierarchy : awardHierarchyItems.entrySet()) {
            tmpAwardNumber = awardHierarchy.getValue().getAwardNumber();
            AwardHierarchyNode awardHierarchyNode = new AwardHierarchyNode();
            awardHierarchyNode.setAwardNumber(tmpAwardNumber);
            awardHierarchyNode.setParentAwardNumber(awardHierarchy.getValue().getParentAwardNumber());
            awardHierarchyNode.setRootAwardNumber(awardHierarchy.getValue().getRootAwardNumber());
            VersionHistory pendingVersionHistory = this.versionHistoryService.findPendingVersion(Award.class, tmpAwardNumber);
            VersionHistory activeVersionHistory = this.versionHistoryService.findActiveVersion(Award.class, tmpAwardNumber);
            Award award = this.awardVersionService.getWorkingAwardVersion(tmpAwardNumber);
            AwardAmountInfo awardAmountInfo = this.awardAmountInfoService.fetchLastAwardAmountInfoForDocNum(award, timeAndMoneyDocument.getDocumentNumber());
            awardHierarchyNode.setFinalExpirationDate(awardAmountInfo.getFinalExpirationDate());
            awardHierarchyNode.setLeadUnitName(award.getUnitName());
            awardHierarchyNode.setPrincipalInvestigatorName(award.getPrincipalInvestigatorName());
            awardHierarchyNode.setAccountNumber(award.getAccountNumber());
            awardHierarchyNode.setAwardStatusCode(award.getStatusCode());
            awardHierarchyNode.setObliDistributableAmount(awardAmountInfo.getObliDistributableAmount());
            awardHierarchyNode.setAntDistributableAmount(awardAmountInfo.getAntDistributableAmount());
            KualiDecimal obligatedTotal = awardAmountInfo.getAmountObligatedToDate();
            KualiDecimal obligatedTotalDirect = awardAmountInfo.getObligatedTotalDirect();
            KualiDecimal obligatedTotalIndirect = awardAmountInfo.getObligatedTotalIndirect();
            KualiDecimal anticipatedTotalAmount = awardAmountInfo.getAnticipatedTotalAmount();
            KualiDecimal anticipatedTotalDirect = awardAmountInfo.getAnticipatedTotalDirect();
            KualiDecimal anticipatedTotalIndirect = awardAmountInfo.getAnticipatedTotalIndirect();
            for (PendingTransaction pendingTransaction : timeAndMoneyDocument.getPendingTransactions()) {
                if (pendingTransaction.getProcessedFlag().booleanValue() || !pendingTransaction.isSingleNodeTransaction()) continue;
                obligatedTotal = (KualiDecimal)obligatedTotal.add((AbstractKualiDecimal)pendingTransaction.getObligatedAmount());
                obligatedTotalDirect = (KualiDecimal)obligatedTotalDirect.add((AbstractKualiDecimal)pendingTransaction.getObligatedDirectAmount());
                obligatedTotalIndirect = (KualiDecimal)obligatedTotalIndirect.add((AbstractKualiDecimal)pendingTransaction.getObligatedIndirectAmount());
                anticipatedTotalAmount = (KualiDecimal)anticipatedTotalAmount.add((AbstractKualiDecimal)pendingTransaction.getAnticipatedAmount());
                anticipatedTotalDirect = (KualiDecimal)anticipatedTotalDirect.add((AbstractKualiDecimal)pendingTransaction.getAnticipatedDirectAmount());
                anticipatedTotalIndirect = (KualiDecimal)anticipatedTotalIndirect.add((AbstractKualiDecimal)pendingTransaction.getAnticipatedIndirectAmount());
            }
            awardHierarchyNode.setAmountObligatedToDate(obligatedTotal);
            awardHierarchyNode.setObligatedTotalDirect(obligatedTotalDirect);
            awardHierarchyNode.setObligatedTotalIndirect(obligatedTotalIndirect);
            awardHierarchyNode.setAnticipatedTotalAmount(anticipatedTotalAmount);
            awardHierarchyNode.setAnticipatedTotalDirect(anticipatedTotalDirect);
            awardHierarchyNode.setAnticipatedTotalIndirect(anticipatedTotalIndirect);
            awardHierarchyNode.setCurrentFundEffectiveDate(awardAmountInfo.getCurrentFundEffectiveDate());
            awardHierarchyNode.setObligationExpirationDate(awardAmountInfo.getObligationExpirationDate());
            awardHierarchyNode.setProjectStartDate(award.getAwardEffectiveDate());
            awardHierarchyNode.setTitle(award.getTitle());
            awardHierarchyNode.setAwardId(award.getAwardId());
            awardHierarchyNode.setAwardDocumentFinalStatus(Boolean.valueOf(pendingVersionHistory == null && activeVersionHistory != null));
            awardHierarchyNodes.put(awardHierarchyNode.getAwardNumber(), awardHierarchyNode);
        }
    }

    public AwardVersionService getAwardVersionService() {
        this.awardVersionService = (AwardVersionService)KraServiceLocator.getService(AwardVersionService.class);
        return this.awardVersionService;
    }

    public void createNodeMapsOnFormForSummaryPanel(Map<String, AwardHierarchyNode> awardHierarchyNodes, Map<String, String> previousNodeMap, Map<String, String> nextNodeMap) {
        ArrayList<AwardHierarchy> sortedList = new ArrayList<AwardHierarchy>();
        AwardHierarchy rootNode = this.loadFullHierarchyFromAnyNode(this.getRootNode(awardHierarchyNodes).getAwardNumber());
        sortedList.add(rootNode);
        for (AwardHierarchy ah : rootNode.getChildren()) {
            sortedList.add(ah);
            this.addChildrenToSortedList(ah, sortedList);
        }
        nextNodeMap.clear();
        previousNodeMap.clear();
        previousNodeMap.put(rootNode.getAwardNumber(), "000000-00000");
        this.addSubNodesToPreviousNodeMap(sortedList, previousNodeMap);
        this.addNodesToNextNodeMap(sortedList, nextNodeMap);
    }

    private void addChildrenToSortedList(AwardHierarchy ah, List<AwardHierarchy> sortedList) {
        if (ah.hasChildren()) {
            for (AwardHierarchy awardHierarchy : ah.getChildren()) {
                sortedList.add(awardHierarchy);
                this.addChildrenToSortedList(awardHierarchy, sortedList);
            }
        }
    }

    private void addSubNodesToPreviousNodeMap(List<AwardHierarchy> sortedList, Map<String, String> previousNodeMap) {
        String previousNodeNumber = null;
        String nextNodeNumber = null;
        for (int index = 0; index < sortedList.size() - 1; ++index) {
            previousNodeNumber = sortedList.get(index).getAwardNumber();
            nextNodeNumber = sortedList.get(index + 1).getAwardNumber();
            previousNodeMap.put(nextNodeNumber, previousNodeNumber);
        }
    }

    private void addNodesToNextNodeMap(List<AwardHierarchy> sortedList, Map<String, String> nextNodeMap) {
        int index;
        String previousNodeNumber = null;
        String nextNodeNumber = null;
        for (index = 0; index < sortedList.size() - 1; ++index) {
            previousNodeNumber = sortedList.get(index).getAwardNumber();
            nextNodeNumber = sortedList.get(index + 1).getAwardNumber();
            nextNodeMap.put(previousNodeNumber, nextNodeNumber);
        }
        nextNodeMap.put(sortedList.get(index).getAwardNumber(), "lastNodeNextValue");
    }

    private AwardHierarchyNode getRootNode(Map<String, AwardHierarchyNode> awardHierarchyNodes) {
        AwardHierarchyNode returnValue = null;
        for (String awardNumber : awardHierarchyNodes.keySet()) {
            if (!awardNumber.endsWith("-00001")) continue;
            returnValue = awardHierarchyNodes.get(awardNumber);
        }
        return returnValue;
    }

    public AwardAmountInfoService getAwardAmountInfoService() {
        return this.awardAmountInfoService;
    }

    public void setAwardAmountInfoService(AwardAmountInfoService awardAmountInfoService) {
        this.awardAmountInfoService = awardAmountInfoService;
    }

    public ActivePendingTransactionsService getActivePendingTransactionsService() {
        return this.activePendingTransactionsService;
    }

    public void setActivePendingTransactionsService(ActivePendingTransactionsService activePendingTransactionsService) {
        this.activePendingTransactionsService = activePendingTransactionsService;
    }

    public void setVersionHistoryService(VersionHistoryService versionHistoryService) {
        this.versionHistoryService = versionHistoryService;
    }

    public AwardService getAwardService() {
        return this.awardService;
    }

    public void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }

    public void setAwardVersionService(AwardVersionService awardVersionService) {
        this.awardVersionService = awardVersionService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

