/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.awardhierarchy.sync;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForward;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.awardhierarchy.AwardHierarchy;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyService;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncPendingChangeBean;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncStatus;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncType;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.workflow.service.WorkflowDocumentService;

public class AwardSyncBean
implements Serializable {
    private static final long serialVersionUID = 6645717325064929518L;
    private AwardForm awardForm;
    private ActionForward currentForward;
    private String statusAwardNumber;
    private List<AwardSyncPendingChangeBean> pendingChanges;
    private List<AwardSyncPendingChangeBean> confirmedPendingChanges;

    public AwardSyncBean(AwardForm awardForm) {
        this.awardForm = awardForm;
        this.pendingChanges = new ArrayList();
        this.confirmedPendingChanges = new ArrayList();
    }

    public ActionForward getCurrentForward() {
        return this.currentForward;
    }

    public void setCurrentForward(ActionForward currentForward) {
        this.currentForward = currentForward;
    }

    public AwardSyncStatus getParentAwardStatus() {
        for (AwardSyncStatus status : this.awardForm.getAwardDocument().getAward().getSyncStatuses()) {
            if (status.getAwardNumber() != null) continue;
            return status;
        }
        return null;
    }

    public Map<String, AwardSyncStatus> getAwardStatuses() {
        HashMap<String, AwardSyncStatus> statuses = new HashMap<String, AwardSyncStatus>();
        for (AwardSyncStatus status : this.awardForm.getAwardDocument().getAward().getSyncStatuses()) {
            if (status.getAwardNumber() == null) continue;
            statuses.put(status.getAwardNumber(), status);
        }
        return statuses;
    }

    public List<AwardHierarchy> getHierarchyList() {
        AwardHierarchy awardHierarchy = ((AwardHierarchyService)KraServiceLocator.getService(AwardHierarchyService.class)).loadAwardHierarchyBranch(this.awardForm.getAwardDocument().getAward().getAwardNumber());
        ArrayList<AwardHierarchy> listOrder = new ArrayList<AwardHierarchy>();
        if (awardHierarchy != null) {
            for (AwardHierarchy hierarchy : awardHierarchy.getChildren()) {
                this.getHierarchyList(hierarchy, listOrder);
            }
        }
        return listOrder;
    }

    protected void getHierarchyList(AwardHierarchy hierarchy, List<AwardHierarchy> listOrder) {
        listOrder.add(hierarchy);
        for (AwardHierarchy child : hierarchy.getChildren()) {
            this.getHierarchyList(child, listOrder);
        }
    }

    public boolean isOnValidationNode() {
        WorkflowDocumentService workflowDocumentService = KRADServiceLocatorWeb.getWorkflowDocumentService();
        return StringUtils.equals((String)"SyncValidationApproval", (String)workflowDocumentService.getCurrentRouteNodeNames(this.awardForm.getAwardDocument().getDocumentHeader().getWorkflowDocument()));
    }

    public String getStatusAwardNumber() {
        return this.statusAwardNumber;
    }

    public void setStatusAwardNumber(String statusAwardNumber) {
        this.statusAwardNumber = statusAwardNumber;
    }

    public void setPendingChanges(List<AwardSyncPendingChangeBean> pendingChanges) {
        this.pendingChanges = pendingChanges;
    }

    public List<AwardSyncPendingChangeBean> getPendingChanges() {
        return this.pendingChanges;
    }

    public void addPendingChange(AwardSyncType type, PersistableBusinessObject object, String awardAttr, String attrName) {
        AwardSyncPendingChangeBean pendingBean = new AwardSyncPendingChangeBean(type, object, awardAttr, attrName);
        this.getPendingChanges().add(pendingBean);
    }

    public void addPendingChange(AwardSyncType type, PersistableBusinessObject object, String awardAttr) {
        AwardSyncPendingChangeBean pendingBean = new AwardSyncPendingChangeBean(type, object, awardAttr);
        this.getPendingChanges().add(pendingBean);
    }

    public List<AwardSyncPendingChangeBean> getConfirmedPendingChanges() {
        return this.confirmedPendingChanges;
    }

    public void setConfirmedPendingChanges(List<AwardSyncPendingChangeBean> confirmedPendingChanges) {
        this.confirmedPendingChanges = confirmedPendingChanges;
    }

    public void addConfirmedPendingChange(AwardSyncType type, PersistableBusinessObject object, String awardAttr, String attrName) {
        AwardSyncPendingChangeBean pendingBean = new AwardSyncPendingChangeBean(type, object, awardAttr, attrName);
        this.getConfirmedPendingChanges().add(pendingBean);
    }

    public void addConfirmedPendingChange(AwardSyncType type, PersistableBusinessObject object, String awardAttr) {
        AwardSyncPendingChangeBean pendingBean = new AwardSyncPendingChangeBean(type, object, awardAttr);
        this.getConfirmedPendingChanges().add(pendingBean);
    }

    public void confirmPendingChanges() {
        this.getConfirmedPendingChanges().addAll(this.getPendingChanges());
        this.getPendingChanges().clear();
    }
}

