/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.awardhierarchy.sync.helpers;

import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncChange;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncType;
import org.kuali.kra.award.awardhierarchy.sync.helpers.AwardSyncHelperBase;
import org.kuali.kra.award.home.Award;
import org.kuali.rice.krad.bo.PersistableBusinessObject;

public class AwardSyncAwardHelper
extends AwardSyncHelperBase {
    public static final String SPONSOR_CODE_ATTR = "sponsorCode";
    public static final String STATUS_CODE_ATTR = "statusCode";

    public void applySyncChange(Award award, AwardSyncChange change) throws NoSuchFieldException {
        if (StringUtils.equals((String)change.getSyncType(), (String)AwardSyncType.ADD_SYNC.getSyncValue())) {
            if (StringUtils.equalsIgnoreCase((String)change.getAttrName(), (String)SPONSOR_CODE_ATTR)) {
                award.setSponsorCode((String)change.getXmlExport().getValues().get(change.getAttrName()));
            } else if (StringUtils.equalsIgnoreCase((String)change.getAttrName(), (String)STATUS_CODE_ATTR)) {
                award.setStatusCode((Integer)change.getXmlExport().getValues().get(change.getAttrName()));
            } else {
                throw new NoSuchFieldException();
            }
        }
    }

    protected String getObjectDesc(PersistableBusinessObject syncableObject, String attrName) {
        if (StringUtils.equalsIgnoreCase((String)attrName, (String)SPONSOR_CODE_ATTR)) {
            return "Sponsor";
        }
        if (StringUtils.equalsIgnoreCase((String)attrName, (String)STATUS_CODE_ATTR)) {
            return "Award Status";
        }
        return null;
    }

    protected String getDataDesc(PersistableBusinessObject syncableObject, String attrName) {
        Award award = (Award)syncableObject;
        if (StringUtils.equalsIgnoreCase((String)attrName, (String)SPONSOR_CODE_ATTR)) {
            return award.getSponsorCode() + " : " + award.getSponsorName();
        }
        if (StringUtils.equalsIgnoreCase((String)attrName, (String)STATUS_CODE_ATTR)) {
            award.refreshReferenceObject("awardStatus");
            return award.getAwardStatus().getDescription();
        }
        return null;
    }
}

