/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.awardhierarchy.sync.service;

import java.lang.reflect.InvocationTargetException;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncChange;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncPendingChangeBean;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncType;
import org.kuali.kra.award.awardhierarchy.sync.AwardSyncXmlExport;
import org.kuali.kra.award.awardhierarchy.sync.helpers.AwardSyncHelper;
import org.kuali.kra.award.awardhierarchy.sync.service.AwardSyncCreationService;
import org.kuali.kra.award.awardhierarchy.sync.service.AwardSyncHelpersService;
import org.kuali.kra.award.home.Award;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.XmlObjectSerializerService;

public class AwardSyncCreationServiceImpl
implements AwardSyncCreationService {
    private AwardSyncHelpersService awardSyncHelpersService;
    private XmlObjectSerializerService xmlSerializerService;
    private BusinessObjectService businessObjectService;

    public AwardSyncChange createAwardSyncChange(AwardSyncPendingChangeBean pendingChange) throws NoSuchFieldException, IllegalAccessException, InvocationTargetException {
        AwardSyncChange change = this.getSyncHelper(pendingChange.getObject().getClass().getCanonicalName()).createAwardSyncChange(pendingChange.getSyncType(), pendingChange.getObject(), pendingChange.getAwardAttr(), pendingChange.getAttrName());
        change.setXml(this.getXmlSerializerService().toXml((Object)change.getXmlExport()));
        return change;
    }

    public void addAwardSyncChange(Award award, AwardSyncPendingChangeBean pendingChange) throws Exception {
        AwardSyncChange syncChange = this.createAwardSyncChange(pendingChange);
        this.addAwardSyncChange(award, syncChange);
    }

    public void addAwardSyncChange(Award award, AwardSyncChange syncChange) {
        ListIterator iter = award.getSyncChanges().listIterator();
        while (iter.hasNext()) {
            AwardSyncChange origChange = (AwardSyncChange)iter.next();
            if (!this.changeOnSameObject(origChange, syncChange)) continue;
            this.getBusinessObjectService().delete((PersistableBusinessObject)origChange);
            iter.remove();
        }
        syncChange.setAwardId(award.getAwardId());
        award.getSyncChanges().add(syncChange);
    }

    public AwardSyncXmlExport getXmlExport(AwardSyncChange change) {
        return (AwardSyncXmlExport)this.getXmlSerializerService().fromXml(change.getXml());
    }

    protected boolean changeOnSameObject(AwardSyncChange change1, AwardSyncChange change2) {
        return StringUtils.equals((String)change1.getClassName(), (String)change2.getClassName()) && StringUtils.equals((String)change1.getAttrName(), (String)change2.getAttrName()) && StringUtils.equals((String)change1.getSyncType(), (String)change2.getSyncType()) && this.sameObject(this.getXmlExport(change1), this.getXmlExport(change2));
    }

    protected boolean sameObject(AwardSyncXmlExport change1, AwardSyncXmlExport change2) {
        if (StringUtils.equals((String)change1.getClassName(), (String)change2.getClassName()) && ObjectUtils.equals((Object)change1.getKeys(), (Object)change2.getKeys())) {
            boolean result = true;
            for (Map.Entry entry : change1.getValues().entrySet()) {
                if (!(entry.getValue() instanceof AwardSyncXmlExport) || !((AwardSyncXmlExport)entry.getValue()).isPartOfObjectKey() || change2.getValues().get(entry.getKey()) instanceof AwardSyncXmlExport && this.sameObject((AwardSyncXmlExport)entry.getValue(), (AwardSyncXmlExport)change2.getValues().get(entry.getKey()))) continue;
                result = false;
            }
            return result;
        }
        return false;
    }

    protected String generateAwardSyncData(AwardSyncType syncType, PersistableBusinessObject syncable, String attrName) throws NoSuchFieldException, IllegalAccessException, InvocationTargetException {
        return this.getXmlSerializerService().toXml((Object)this.getSyncHelper(syncable.getClass().getCanonicalName()).buildXmlExport(syncable, attrName));
    }

    protected AwardSyncHelper getSyncHelper(String className) {
        return this.getAwardSyncHelpersService().getSyncHelper(className);
    }

    protected AwardSyncHelpersService getAwardSyncHelpersService() {
        return this.awardSyncHelpersService;
    }

    public void setAwardSyncHelpersService(AwardSyncHelpersService awardSyncHelpersService) {
        this.awardSyncHelpersService = awardSyncHelpersService;
    }

    protected XmlObjectSerializerService getXmlSerializerService() {
        return this.xmlSerializerService;
    }

    public void setXmlSerializerService(XmlObjectSerializerService xmlSerializerService) {
        this.xmlSerializerService = xmlSerializerService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

