/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.budget;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import org.kuali.kra.award.budget.AwardBudgetLimit;
import org.kuali.kra.award.budget.AwardBudgetLineItemExt;
import org.kuali.kra.award.budget.AwardBudgetPeriodExt;
import org.kuali.kra.award.budget.AwardBudgetPersonnelDetailsExt;
import org.kuali.kra.award.budget.AwardBudgetStatus;
import org.kuali.kra.award.budget.AwardBudgetType;
import org.kuali.kra.award.budget.AwardBudgetVersionOverviewExt;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.core.CostElement;
import org.kuali.kra.budget.nonpersonnel.BudgetLineItem;
import org.kuali.kra.budget.parameters.BudgetPeriod;
import org.kuali.kra.budget.personnel.BudgetPersonnelDetails;
import org.kuali.kra.budget.rates.RateType;
import org.kuali.kra.budget.versions.BudgetDocumentVersion;
import org.kuali.kra.budget.versions.BudgetVersionOverview;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.coreservice.framework.CoreFrameworkServiceLocator;

public class AwardBudgetExt
extends Budget {
    private static final long serialVersionUID = 1L;
    private String awardBudgetStatusCode;
    private String awardBudgetTypeCode;
    private BudgetDecimal obligatedTotal;
    private BudgetDecimal obligatedAmount = BudgetDecimal.ZERO;
    private AwardBudgetStatus awardBudgetStatus;
    private AwardBudgetType awardBudgetType;
    private String description;
    private String budgetInitiator;
    private BudgetVersionOverview prevBudget;
    private List<BudgetDecimal> budgetsTotals;
    private List<AwardBudgetLimit> awardBudgetLimits = new ArrayList();
    private BudgetVersionOverview firstBudget;
    private SortedMap<CostElement, BudgetDecimal> objectCodeBudgetTotals;
    private SortedMap<RateType, BudgetDecimal> calculatedExpenseBudgetTotals;
    private SortedMap<String, BudgetDecimal> totalBudgetSummaryTotals;
    private SortedMap<String, BudgetDecimal> objectCodePersonnelFringeBudgetTotals;
    private SortedMap<RateType, BudgetDecimal> personnelCalculatedExpenseBudgetTotals;
    private SortedMap<RateType, BudgetDecimal> nonPersonnelCalculatedExpenseBudgetTotals;

    public AwardBudgetPeriodExt getNewBudgetPeriod() {
        return new AwardBudgetPeriodExt();
    }

    public BudgetLineItem getNewBudgetLineItem() {
        return new AwardBudgetLineItemExt();
    }

    public BudgetPersonnelDetails getNewBudgetPersonnelLineItem() {
        return new AwardBudgetPersonnelDetailsExt();
    }

    public String getAwardBudgetStatusCode() {
        return this.awardBudgetStatusCode;
    }

    public void setAwardBudgetStatusCode(String awardBudgetStatusCode) {
        this.awardBudgetStatusCode = awardBudgetStatusCode;
    }

    public String getAwardBudgetTypeCode() {
        return this.awardBudgetTypeCode;
    }

    public void setAwardBudgetTypeCode(String awardBudgetTypeCode) {
        this.awardBudgetTypeCode = awardBudgetTypeCode;
    }

    public AwardBudgetStatus getAwardBudgetStatus() {
        return this.awardBudgetStatus;
    }

    public void setAwardBudgetStatus(AwardBudgetStatus awardBudgetStatus) {
        this.awardBudgetStatus = awardBudgetStatus;
    }

    public AwardBudgetType getAwardBudgetType() {
        return this.awardBudgetType;
    }

    public void setAwardBudgetType(AwardBudgetType awardBudgetType) {
        this.awardBudgetType = awardBudgetType;
    }

    public boolean getOhRatesNonEditable() {
        Award award = (Award)this.getBudgetDocument().getParentDocument().getBudgetParent();
        return !award.getAwardFandaRate().isEmpty();
    }

    public boolean getEbRatesNonEditable() {
        Award award = (Award)this.getBudgetDocument().getParentDocument().getBudgetParent();
        return award.getSpecialEbRateOffCampus() != null && award.getSpecialEbRateOffCampus().isPositive() || award.getSpecialEbRateOnCampus() != null && award.getSpecialEbRateOnCampus().isPositive();
    }

    public BudgetDecimal getObligatedTotal() {
        return this.obligatedTotal == null ? BudgetDecimal.ZERO : this.obligatedTotal;
    }

    public void setObligatedTotal(BudgetDecimal obligatedAmount) {
        this.obligatedTotal = obligatedAmount;
    }

    public BudgetDecimal getObligatedAmount() {
        return this.obligatedAmount == null ? BudgetDecimal.ZERO : this.obligatedAmount;
    }

    public void setObligatedAmount(BudgetDecimal obligatedAmount) {
        this.obligatedAmount = obligatedAmount;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getBudgetInitiator() {
        return this.budgetInitiator;
    }

    public void setBudgetInitiator(String budgetInitiator) {
        this.budgetInitiator = budgetInitiator;
    }

    public BudgetVersionOverview getPrevBudget() {
        if (this.prevBudget == null && this.getBudgetDocument() != null) {
            Integer version = 0;
            for (BudgetDocumentVersion budgetDocumentVersion : this.getBudgetDocument().getParentDocument().getBudgetDocumentVersions()) {
                for (BudgetVersionOverview budgetVersionOverview : budgetDocumentVersion.getBudgetVersionOverviews()) {
                    if (budgetVersionOverview == null || budgetVersionOverview.getBudgetVersionNumber() <= version || !this.getParameterValue("awardBudgetStatusPosted").equals(((AwardBudgetVersionOverviewExt)budgetVersionOverview).getAwardBudgetStatusCode()) || budgetVersionOverview.getBudgetVersionNumber() >= this.getBudgetVersionNumber()) continue;
                    version = budgetVersionOverview.getBudgetVersionNumber();
                    this.prevBudget = budgetVersionOverview;
                }
            }
            if (this.prevBudget == null) {
                this.prevBudget = new BudgetVersionOverview();
                this.prevBudget.setCostSharingAmount(BudgetDecimal.ZERO);
                this.prevBudget.setTotalCost(BudgetDecimal.ZERO);
                this.prevBudget.setTotalCostLimit(BudgetDecimal.ZERO);
                this.prevBudget.setTotalDirectCost(BudgetDecimal.ZERO);
                this.prevBudget.setTotalIndirectCost(BudgetDecimal.ZERO);
                this.prevBudget.setUnderrecoveryAmount(BudgetDecimal.ZERO);
            }
        }
        return this.prevBudget;
    }

    public BudgetVersionOverview getFirstBudget() {
        if (this.firstBudget == null && this.getBudgetDocument() != null) {
            Integer version = 0;
            for (BudgetDocumentVersion budgetDocumentVersion : this.getBudgetDocument().getParentDocument().getBudgetDocumentVersions()) {
                for (BudgetVersionOverview budgetVersionOverview : budgetDocumentVersion.getBudgetVersionOverviews()) {
                    if (budgetVersionOverview == null || !this.getParameterValue("awardBudgetStatusPosted").equals(((AwardBudgetVersionOverviewExt)budgetVersionOverview).getAwardBudgetStatusCode())) continue;
                    this.firstBudget = budgetVersionOverview;
                    return this.firstBudget;
                }
            }
            if (this.firstBudget == null) {
                this.firstBudget = new BudgetVersionOverview();
                this.firstBudget.setCostSharingAmount(this.getCostSharingAmount());
                this.firstBudget.setTotalCost(this.getTotalCost());
                this.firstBudget.setTotalCostLimit(this.getTotalCostLimit());
                this.firstBudget.setTotalDirectCost(this.getTotalDirectCost());
                this.firstBudget.setTotalIndirectCost(this.getTotalIndirectCost());
                this.firstBudget.setUnderrecoveryAmount(this.getUnderrecoveryAmount());
            }
        }
        return this.firstBudget;
    }

    public void setPrevBudget(BudgetVersionOverview prevBudget) {
        this.prevBudget = prevBudget;
    }

    public List<BudgetDecimal> getBudgetsTotals() {
        this.addBudgetTotals();
        return this.budgetsTotals;
    }

    public void setBudgetsTotals(List<BudgetDecimal> budgetsTotals) {
        this.budgetsTotals = budgetsTotals;
    }

    private void addBudgetTotals() {
        ArrayList<AbstractKualiDecimal> totals = new ArrayList<AbstractKualiDecimal>();
        totals.add(this.getTotalCost().add((AbstractKualiDecimal)this.getPrevBudget().getTotalCost()));
        totals.add(this.getTotalDirectCost().add((AbstractKualiDecimal)this.getPrevBudget().getTotalDirectCost()));
        totals.add(this.getTotalIndirectCost().add((AbstractKualiDecimal)this.getPrevBudget().getTotalIndirectCost()));
        totals.add(this.getUnderrecoveryAmount().add((AbstractKualiDecimal)this.getPrevBudget().getUnderrecoveryAmount()));
        totals.add(this.getCostSharingAmount().add((AbstractKualiDecimal)this.getPrevBudget().getCostSharingAmount()));
        this.setBudgetsTotals(totals);
    }

    public String getRebudgetFlag() {
        String rebudgetTypeCode = this.getParameterValue("awardBudgetTypeRebudget");
        return Boolean.toString(this.getAwardBudgetTypeCode().equals(rebudgetTypeCode));
    }

    private String getParameterValue(String parameter) {
        return CoreFrameworkServiceLocator.getParameterService().getParameterValueAsString(AwardBudgetDocument.class, parameter);
    }

    public List<AwardBudgetLimit> getAwardBudgetLimits() {
        return this.awardBudgetLimits;
    }

    public void setAwardBudgetLimits(List<AwardBudgetLimit> awardBudgetLimits) {
        this.awardBudgetLimits = awardBudgetLimits;
    }

    public SortedMap<CostElement, BudgetDecimal> getObjectCodeBudgetTotals() {
        return this.objectCodeBudgetTotals;
    }

    public void setObjectCodeBudgetTotals(SortedMap<CostElement, BudgetDecimal> objectCodeBudgetTotals) {
        this.objectCodeBudgetTotals = objectCodeBudgetTotals;
    }

    public SortedMap<RateType, BudgetDecimal> getCalculatedExpenseBudgetTotals() {
        return this.calculatedExpenseBudgetTotals;
    }

    public void setCalculatedExpenseBudgetTotals(SortedMap<RateType, BudgetDecimal> calculatedExpenseBudgetTotals) {
        this.calculatedExpenseBudgetTotals = calculatedExpenseBudgetTotals;
    }

    public SortedMap<String, BudgetDecimal> getTotalBudgetSummaryTotals() {
        return this.totalBudgetSummaryTotals;
    }

    public void setTotalBudgetSummaryTotals(SortedMap<String, BudgetDecimal> totalBudgetSummaryTotals) {
        this.totalBudgetSummaryTotals = totalBudgetSummaryTotals;
    }

    public SortedMap<String, BudgetDecimal> getObjectCodePersonnelFringeBudgetTotals() {
        return this.objectCodePersonnelFringeBudgetTotals;
    }

    public void setObjectCodePersonnelFringeBudgetTotals(SortedMap<String, BudgetDecimal> objectCodePersonnelFringeBudgetTotals) {
        this.objectCodePersonnelFringeBudgetTotals = objectCodePersonnelFringeBudgetTotals;
    }

    public SortedMap<RateType, BudgetDecimal> getPersonnelCalculatedExpenseBudgetTotals() {
        return this.personnelCalculatedExpenseBudgetTotals;
    }

    public void setPersonnelCalculatedExpenseBudgetTotals(SortedMap<RateType, BudgetDecimal> personnelCalculatedExpenseBudgetTotals) {
        this.personnelCalculatedExpenseBudgetTotals = personnelCalculatedExpenseBudgetTotals;
    }

    public SortedMap<RateType, BudgetDecimal> getNonPersonnelCalculatedExpenseBudgetTotals() {
        return this.nonPersonnelCalculatedExpenseBudgetTotals;
    }

    public void setNonPersonnelCalculatedExpenseBudgetTotals(SortedMap<RateType, BudgetDecimal> nonPersonnelCalculatedExpenseBudgetTotals) {
        this.nonPersonnelCalculatedExpenseBudgetTotals = nonPersonnelCalculatedExpenseBudgetTotals;
    }

    public List buildListOfDeletionAwareLists() {
        List deletionAwareList = super.buildListOfDeletionAwareLists();
        ArrayList awardBudgetPeriodSummaryCalculatedAmounts = new ArrayList();
        for (BudgetPeriod persistableBusinessObject : this.getBudgetPeriods()) {
            awardBudgetPeriodSummaryCalculatedAmounts.addAll(((AwardBudgetPeriodExt)persistableBusinessObject).getAwardBudgetPeriodFringeAmounts());
            awardBudgetPeriodSummaryCalculatedAmounts.addAll(((AwardBudgetPeriodExt)persistableBusinessObject).getAwardBudgetPeriodFnAAmounts());
        }
        deletionAwareList.add(awardBudgetPeriodSummaryCalculatedAmounts);
        deletionAwareList.add(this.awardBudgetLimits);
        return deletionAwareList;
    }

    public BudgetDecimal getSumDirectCostAmountFromPeriods() {
        BudgetDecimal amount = BudgetDecimal.ZERO;
        for (BudgetPeriod period : this.getBudgetPeriods()) {
            amount = (BudgetDecimal)amount.add((AbstractKualiDecimal)period.getTotalDirectCost());
        }
        return amount;
    }
}

