/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.budget;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.award.budget.AwardBudgetPeriodSummaryCalculatedAmount;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.kra.award.budget.document.AwardBudgetDocumentVersion;
import org.kuali.kra.award.budget.document.authorization.AwardBudgetTask;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.document.authorization.BudgetTask;
import org.kuali.kra.budget.web.struts.form.BudgetForm;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kns.datadictionary.HeaderNavigation;
import org.kuali.rice.kns.web.ui.ExtraButton;
import org.kuali.rice.kns.web.ui.HeaderField;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardBudgetForm
extends BudgetForm {
    private static final long serialVersionUID = 9001767909548738932L;
    private String awardInMultipleNodeHierarchy;
    private String budgetParentId;
    private AwardBudgetPeriodSummaryCalculatedAmount awardBudgetPeriodSummaryCalculatedAmount = new AwardBudgetPeriodSummaryCalculatedAmount();

    protected String getDefaultDocumentTypeName() {
        return "AwardBudgetDocument";
    }

    public void initialize() {
        super.initialize();
        this.getBudgetDocument().initialize();
    }

    public String getAwardInMultipleNodeHierarchy() {
        return this.awardInMultipleNodeHierarchy;
    }

    public void setAwardInMultipleNodeHierarchy(String awardInMultipleNodeHierarchy) {
        this.awardInMultipleNodeHierarchy = awardInMultipleNodeHierarchy;
    }

    public String getActionPrefix() {
        return "awardBudget";
    }

    public AwardBudgetDocument getAwardBudgetDocument() {
        return (AwardBudgetDocument)super.getBudgetDocument();
    }

    public List<ExtraButton> getExtraActionsButtons() {
        this.extraButtons.clear();
        AwardBudgetDocument doc = this.getAwardBudgetDocument();
        String externalImageURL = "kra.externalizable.images.url";
        String krImageURL = "kr.externalizable.images.url";
        ConfigurationService configurationService = KRADServiceLocator.getKualiConfigurationService();
        TaskAuthorizationService tas = (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class);
        if (tas.isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), (Task)new AwardBudgetTask("toggleAwardBudgetStatus", doc))) {
            String toggleAwardStatusButtonImage = this.buildExtraButtonSourceURI("buttonsmall_toggleBudgetStatus.gif");
            this.addExtraButton("methodToCall.toggleAwardBudgetStatus", toggleAwardStatusButtonImage, "Toggle Budget Status");
        }
        if (tas.isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), (Task)new AwardBudgetTask("postAwardBudget", doc))) {
            String postAwardBudgetImage = this.buildExtraButtonSourceURI("buttonsmall_postawardbudget.gif");
            this.addExtraButton("methodToCall.postAwardBudget", postAwardBudgetImage, "Post Budget");
        }
        if (tas.isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), (Task)new BudgetTask("awardBudget", "rejectBudget", (BudgetDocument)doc))) {
            this.addExtraButton("methodToCall.reject", configurationService.getPropertyValueAsString(externalImageURL) + "buttonsmall_reject.gif", "Reject");
        }
        if (tas.isAuthorized(GlobalVariables.getUserSession().getPrincipalId(), (Task)new BudgetTask("awardBudget", "cancelBudget", (BudgetDocument)doc))) {
            this.addExtraButton("methodToCall.cancel", configurationService.getPropertyValueAsString(krImageURL) + "buttonsmall_cancel.gif", "Cancel");
        }
        return this.extraButtons;
    }

    protected void addExtraButton(String property, String source, String altText) {
        ExtraButton newButton = new ExtraButton();
        newButton.setExtraButtonProperty(property);
        newButton.setExtraButtonSource(source);
        newButton.setExtraButtonAltText(altText);
        this.extraButtons.add(newButton);
    }

    public void setBudgetParentId(String budgetParentId) {
        this.budgetParentId = budgetParentId;
    }

    public String getBudgetParentId() {
        return this.budgetParentId;
    }

    public String getFnARateFlagEditable() {
        return Boolean.toString(!this.getAwardBudgetDocument().getAwardBudget().getOhRatesNonEditable());
    }

    protected HeaderField getHeaderDocNumber() {
        return new HeaderField("DataDictionary.DocumentHeader.attributes.documentNumber", this.getBudgetDocument() == null ? null : this.getBudgetDocument().getDocumentNumber());
    }

    protected HeaderField getHeaderDocStatus(WorkflowDocument parentWorkflowDocument) {
        AwardBudgetExt abe = this.getAwardBudgetDocument().getAwardBudget();
        return new HeaderField("DataDictionary.AttributeReferenceDummy.attributes.workflowDocumentStatus", abe.getAwardBudgetStatus().getDescription());
    }

    protected HeaderField getHeaderDocInitiator(WorkflowDocument parentWorkflowDocument) {
        WorkflowDocument doc = this.getBudgetDocument().getDocumentHeader().getWorkflowDocument();
        return new HeaderField("DataDictionary.AttributeReferenceDummy.attributes.initiatorNetworkId", doc.getInitiatorPrincipalId());
    }

    protected HeaderField getHeaderDocCreateDate(WorkflowDocument parentWorkflowDocument) {
        Date ts = this.getBudgetDocument().getDocumentHeader().getWorkflowDocument().getDateCreated().toDate();
        String updateDateStr = CoreApiServiceLocator.getDateTimeService().toString(ts, "hh:mm a MM/dd/yyyy");
        return new HeaderField("DataDictionary.AttributeReferenceDummy.attributes.createDate", updateDateStr);
    }

    public AwardBudgetPeriodSummaryCalculatedAmount getAwardBudgetPeriodSummaryCalculatedAmount() {
        return this.awardBudgetPeriodSummaryCalculatedAmount;
    }

    public void setAwardBudgetPeriodSummaryCalculatedAmount(AwardBudgetPeriodSummaryCalculatedAmount awardBudgetPeriodSummaryCalculatedAmount) {
        this.awardBudgetPeriodSummaryCalculatedAmount = awardBudgetPeriodSummaryCalculatedAmount;
    }

    public HeaderNavigation[] getHeaderNavigationTabs() {
        HeaderNavigation[] navigation = super.getHeaderNavigationTabs();
        ArrayList<HeaderNavigation> resultList = new ArrayList<HeaderNavigation>();
        for (HeaderNavigation nav : navigation) {
            if (StringUtils.equals((String)nav.getHeaderTabNavigateTo(), (String)"modularBudget")) continue;
            resultList.add(nav);
        }
        HeaderNavigation[] result = new HeaderNavigation[resultList.size()];
        resultList.toArray(result);
        return result;
    }

    public boolean getCanModifyBudgetRates() {
        boolean retVal = this.getEditingMode().containsKey("modifyBudgets");
        return retVal;
    }

    public Award getAward() {
        AwardDocument ad = (AwardDocument)this.getAwardBudgetDocument().getParentDocument();
        ad.getBudgetDocumentVersions();
        Award award = ad.getAward();
        return award;
    }

    public BudgetDecimal getObligatedTotal() {
        return (BudgetDecimal)this.getPreviousObligatedTotal().add((AbstractKualiDecimal)this.getObligatedChange());
    }

    public BudgetDecimal getPreviousObligatedTotal() {
        AwardBudgetExt awardBudgetExt = this.getAwardBudgetDocument().getAwardBudget();
        AwardDocument ad = (AwardDocument)this.getAwardBudgetDocument().getParentDocument();
        ArrayList<Budget> allBudgets = new ArrayList<Budget>();
        List awardBudgetDocuments = ad.getBudgetDocumentVersions();
        for (AwardBudgetDocumentVersion version : awardBudgetDocuments) {
            allBudgets.add(version.findBudget());
        }
        return this.getSumOfAllPreviousBudgetChanges(awardBudgetExt, allBudgets);
    }

    protected BudgetDecimal getSumOfAllPreviousBudgetChanges(AwardBudgetExt curentAwardBudgetExt, List<Budget> allBudgets) {
        if (curentAwardBudgetExt != null && curentAwardBudgetExt.getPrevBudget() != null) {
            BudgetDecimal previousTotalCost = curentAwardBudgetExt.getPrevBudget().getTotalCostLimit();
            AwardBudgetExt previousAwardBudget = this.findAwardBudgetExt(curentAwardBudgetExt.getPrevBudget().getBudgetId(), allBudgets);
            return (BudgetDecimal)previousTotalCost.add((AbstractKualiDecimal)this.getSumOfAllPreviousBudgetChanges(previousAwardBudget, allBudgets));
        }
        return BudgetDecimal.ZERO;
    }

    protected AwardBudgetExt findAwardBudgetExt(Long budgetId, List<Budget> allBudgets) {
        for (Budget budget : allBudgets) {
            if (!budget.getBudgetId().equals(budgetId)) continue;
            return (AwardBudgetExt)budget;
        }
        return null;
    }

    public BudgetDecimal getObligatedChange() {
        AwardBudgetExt budget = this.getAwardBudgetDocument().getAwardBudget();
        if (budget != null && budget.getTotalCostLimit() != null) {
            return budget.getTotalCostLimit();
        }
        return BudgetDecimal.ZERO;
    }
}

