/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.budget;

import java.io.Serializable;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.budget.AwardBudgetLimit;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class AwardBudgetLimitsBean
implements Serializable {
    private AwardForm awardForm;

    public AwardBudgetLimitsBean(AwardForm awardForm) {
        this.awardForm = awardForm;
    }

    public KualiDecimal getTotalCostBudgetLimit() {
        return this.getSpecificBudgetLimit(AwardBudgetLimit.LIMIT_TYPE.TOTAL_COST).getLimit();
    }

    public void setTotalCostBudgetLimit(KualiDecimal newLimit) {
        this.setSpecificBudgetLimit(newLimit, AwardBudgetLimit.LIMIT_TYPE.TOTAL_COST);
    }

    public KualiDecimal getDirectCostBudgetLimit() {
        return this.getSpecificBudgetLimit(AwardBudgetLimit.LIMIT_TYPE.DIRECT_COST).getLimit();
    }

    public void setDirectCostBudgetLimit(KualiDecimal newLimit) {
        this.setSpecificBudgetLimit(newLimit, AwardBudgetLimit.LIMIT_TYPE.DIRECT_COST);
    }

    public KualiDecimal getIndirectCostBudgetLimit() {
        return this.getSpecificBudgetLimit(AwardBudgetLimit.LIMIT_TYPE.INDIRECT_COST).getLimit();
    }

    public void setIndirectCostBudgetLimit(KualiDecimal newLimit) {
        this.setSpecificBudgetLimit(newLimit, AwardBudgetLimit.LIMIT_TYPE.INDIRECT_COST);
    }

    protected AwardBudgetLimit getSpecificBudgetLimit(AwardBudgetLimit.LIMIT_TYPE type) {
        for (AwardBudgetLimit limit : this.awardForm.getAwardDocument().getAward().getAwardBudgetLimits()) {
            if (limit.getLimitType() != type) continue;
            return limit;
        }
        return new AwardBudgetLimit(type);
    }

    protected void setSpecificBudgetLimit(KualiDecimal newLimit, AwardBudgetLimit.LIMIT_TYPE type) {
        for (AwardBudgetLimit limit : this.awardForm.getAwardDocument().getAward().getAwardBudgetLimits()) {
            if (limit.getLimitType() != type) continue;
            limit.setLimit(newLimit);
            return;
        }
        AwardBudgetLimit limit = new AwardBudgetLimit(type);
        limit.setLimit(newLimit);
        this.awardForm.getAwardDocument().getAward().getAwardBudgetLimits().add(limit);
    }
}

