/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.budget.document;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.award.budget.AwardBudgetService;
import org.kuali.kra.award.commitments.FandaRateType;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.budget.BudgetDecimal;
import org.kuali.kra.budget.calculator.RateClassType;
import org.kuali.kra.budget.core.Budget;
import org.kuali.kra.budget.document.BudgetDocument;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.budget.rates.BudgetRate;
import org.kuali.kra.budget.rates.RateType;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.kew.KraDocumentRejectionService;
import org.kuali.rice.coreservice.framework.parameter.ParameterConstants;
import org.kuali.rice.kew.api.action.ActionTaken;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.framework.postprocessor.ActionTakenEvent;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

@ParameterConstants.NAMESPACE(namespace="KC-AB")
@ParameterConstants.COMPONENT(component="Document")
public class AwardBudgetDocument
extends BudgetDocument<Award> {
    private static final String AWARD_BUDGET_DOCUMENT_TYPE_CODE = "ABGT";
    private static Log LOG = LogFactory.getLog(AwardBudgetDocument.class);
    private BudgetDecimal obligatedTotal;
    private boolean budgetRateTypePopulated;
    private transient BudgetParentDocument<Award> newestBudgetParentDocument;
    private transient AwardBudgetService awardBudgetService;
    private Award currentAward;
    private static final long serialVersionUID = 3564659576355229703L;

    public void initialize() {
        Award award = (Award)this.getParentDocument().getBudgetParent();
        this.setCurrentAward(award);
        AwardBudgetExt awardBudget = this.getAwardBudget();
        awardBudget.setObligatedTotal(new BudgetDecimal(award.getBudgetTotalCostLimit().bigDecimalValue()));
        List budgetRates = awardBudget.getBudgetRates();
        this.populateBudgetRateTypes((Budget)awardBudget, budgetRates);
    }

    public BudgetParentDocument<Award> getParentDocument() {
        BudgetParentDocument parent = super.getParentDocument();
        if (parent == null) {
            return null;
        }
        if (parent.getBudgetParent() == null) {
            return parent;
        }
        Award currentAward = this.getAwardBudgetService().getActiveOrNewestAward(((Award)parent.getBudgetParent()).getAwardNumber());
        this.newestBudgetParentDocument = currentAward.getAwardDocument();
        return this.newestBudgetParentDocument;
    }

    public Award getCurrentAward() {
        return this.currentAward;
    }

    public void setCurrentAward(Award currentAward) {
        this.currentAward = currentAward;
    }

    public String getDocumentTypeCode() {
        return AWARD_BUDGET_DOCUMENT_TYPE_CODE;
    }

    public Budget getBudget() {
        if (this.getBudgets().isEmpty()) {
            this.getBudgets().add(new AwardBudgetExt());
        }
        Budget budget = (Budget)this.getBudgets().get(0);
        return budget;
    }

    private void populateBudgetRateTypes(Budget budget, List<BudgetRate> budgetRates) {
        for (BudgetRate budgetRate : budgetRates) {
            if (!RateClassType.OVERHEAD.getRateClassType().equals(budgetRate.getRateClassType())) continue;
            budgetRate.setBudget(budget);
            if (!budgetRate.getNonEditableRateFlag()) continue;
            budgetRate.setRateType(this.createAwardRateType(budgetRate));
        }
    }

    private RateType createAwardRateType(BudgetRate rate) {
        FandaRateType awardRateType = (FandaRateType)this.getBusinesssObjectService().findBySinglePrimaryKey(FandaRateType.class, (Object)rate.getRateTypeCode());
        RateType newRateType = new RateType();
        newRateType.setRateClassCode(rate.getRateClassCode());
        newRateType.setRateTypeCode(awardRateType.getFandaRateTypeCode().toString());
        newRateType.setDescription(awardRateType.getDescription());
        return newRateType;
    }

    private BusinessObjectService getBusinesssObjectService() {
        return (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
    }

    public AwardBudgetExt getAwardBudget() {
        return (AwardBudgetExt)this.getBudget();
    }

    public BudgetDecimal getObligatedTotal() {
        return this.obligatedTotal;
    }

    public void setObligatedTotal(BudgetDecimal obligatedTotal) {
        this.obligatedTotal = obligatedTotal;
    }

    public void doRouteStatusChange(DocumentRouteStatusChange dto) {
        super.doRouteStatusChange(dto);
        String newStatus = dto.getNewRouteStatus();
        String oldStatus = dto.getOldRouteStatus();
        boolean changeStatus = false;
        this.setCurrentAward((Award)this.getParentDocument().getBudgetParent());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Route status change on AwardBudgetDocument #%s from %s to %s.", this.getDocumentNumber(), oldStatus, newStatus));
        }
        if (StringUtils.equals((String)newStatus, (String)"D")) {
            this.getAwardBudget().setAwardBudgetStatusCode("13");
        } else if (StringUtils.equals((String)newStatus, (String)"X")) {
            this.getAwardBudget().setAwardBudgetStatusCode("14");
        } else if (StringUtils.equals((String)newStatus, (String)"F")) {
            this.getAwardBudget().setAwardBudgetStatusCode("10");
            changeStatus = true;
        }
        if (changeStatus) {
            try {
                ((DocumentService)KraServiceLocator.getService(DocumentService.class)).saveDocument((Document)this);
            }
            catch (WorkflowException e) {
                throw new RuntimeException("Could not save award document on action  taken.");
            }
        }
    }

    public void doActionTaken(ActionTakenEvent event) {
        super.doActionTaken(event);
        ActionTaken actionTaken = event.getActionTaken();
        KraDocumentRejectionService documentRejectionService = (KraDocumentRejectionService)KraServiceLocator.getService(KraDocumentRejectionService.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("Action taken on document %s: event code %s, action taken is %s", this.getDocumentNumber(), event.getDocumentEventCode(), actionTaken.getActionTaken().getCode()));
        }
        if (StringUtils.equals((String)"A", (String)actionTaken.getActionTaken().getCode()) && documentRejectionService.isDocumentOnInitialNode((Document)this)) {
            this.getAwardBudget().setAwardBudgetStatusCode("1");
            try {
                ((DocumentService)KraServiceLocator.getService(DocumentService.class)).saveDocument((Document)this);
            }
            catch (WorkflowException e) {
                throw new RuntimeException("Could not save award document on action  taken.");
            }
        }
    }

    public void documentHasBeenRejected(String reason) {
        this.getAwardBudget().setAwardBudgetStatusCode("8");
        try {
            ((DocumentService)KraServiceLocator.getService(DocumentService.class)).saveDocument((Document)this);
        }
        catch (WorkflowException e) {
            throw new RuntimeException("Could not save award document on action  taken.");
        }
    }

    public void prepareForSave() {
        if (this.getBudget() != null && this.getBudget().getBudgetId() != null) {
            AwardBudgetExt awardBudgetExt = (AwardBudgetExt)((BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class)).findBySinglePrimaryKey(AwardBudgetExt.class, (Object)this.getBudget().getBudgetId());
        }
        super.prepareForSave();
    }

    protected AwardBudgetService getAwardBudgetService() {
        if (this.awardBudgetService == null) {
            this.awardBudgetService = (AwardBudgetService)KraServiceLocator.getService(AwardBudgetService.class);
        }
        return this.awardBudgetService;
    }

    public void setAwardBudgetService(AwardBudgetService awardBudgetService) {
        this.awardBudgetService = awardBudgetService;
    }
}

