/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.budget.document.authorization;

import java.util.HashSet;
import java.util.Set;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.award.budget.AwardBudgetExt;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.kra.award.budget.document.authorization.AwardBudgetTask;
import org.kuali.kra.budget.document.BudgetParentDocument;
import org.kuali.kra.budget.document.authorization.BudgetDocumentAuthorizer;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.document.Document;

public class AwardBudgetDocumentAuthorizer
extends BudgetDocumentAuthorizer {
    public Set<String> getEditModes(Document document, Person user, Set<String> currentEditModes) {
        HashSet<String> editModes = new HashSet<String>();
        AwardBudgetDocument awardBudgetDocument = (AwardBudgetDocument)document;
        BudgetParentDocument parentDocument = awardBudgetDocument.getParentDocument();
        String userId = user.getPrincipalId();
        if (this.canExecuteAwardBudgetTask(user, awardBudgetDocument, "modifyBudget")) {
            editModes.add("fullEntry");
            editModes.add("modifyBudgets");
            editModes.add("viewBudgets");
            this.setPermissions(userId, parentDocument, editModes);
        } else if (this.canExecuteAwardBudgetTask(user, awardBudgetDocument, "viewBudget")) {
            editModes.add("viewOnly");
            editModes.add("viewBudgets");
            this.setPermissions(userId, parentDocument, editModes);
        } else {
            editModes.add("unviewable");
        }
        if (this.canExecuteAwardBudgetTask(user, awardBudgetDocument, "viewSalaries")) {
            editModes.add("viewSalaries");
        }
        return editModes;
    }

    public boolean canOpen(Document document, Person user) {
        return this.canExecuteAwardBudgetTask(user, (AwardBudgetDocument)document, "viewBudget");
    }

    private boolean canExecuteAwardBudgetTask(Person user, AwardBudgetDocument doc, String taskName) {
        AwardBudgetTask task = new AwardBudgetTask(taskName, doc);
        return this.getTaskAuthorizationService().isAuthorized(user.getPrincipalId(), (Task)task);
    }

    private boolean canCreateAwardBudget(Document document, Person user) {
        return this.canExecuteAwardBudgetTask(user, (AwardBudgetDocument)document, "addBudget");
    }

    public boolean canEdit(Document document, Person user) {
        return this.canExecuteAwardBudgetTask(user, (AwardBudgetDocument)document, "modifyBudget");
    }

    public boolean canSave(Document document, Person user) {
        return this.canEdit(document, user);
    }

    public boolean canReload(Document document, Person user) {
        WorkflowDocument workflow = document.getDocumentHeader().getWorkflowDocument();
        return this.canEdit(document, user) || workflow.isCanceled();
    }

    public boolean canApprove(Document document, Person user) {
        return super.canApprove(document, user) && this.canExecuteAwardBudgetTask(user, (AwardBudgetDocument)document, "approveAwardBudget");
    }

    public boolean canDisapprove(Document document, Person user) {
        return super.canDisapprove(document, user) && this.canExecuteAwardBudgetTask(user, (AwardBudgetDocument)document, "disapproveAwardBudget");
    }

    public boolean canRoute(Document document, Person user) {
        return this.canExecuteAwardBudgetTask(user, (AwardBudgetDocument)document, "submitToWorkflow");
    }

    private boolean isRebudget(AwardBudgetDocument awardBudgetDocument) {
        AwardBudgetExt budget = awardBudgetDocument.getAwardBudget();
        String rebudgetTypeCode = this.getParameterService().getParameterValueAsString(AwardBudgetDocument.class, "awardBudgetTypeRebudget");
        return budget.getAwardBudgetTypeCode().equals(rebudgetTypeCode);
    }

    public boolean canCancel(Document document, Person user) {
        WorkflowDocument workflow = document.getDocumentHeader().getWorkflowDocument();
        return super.canCancel(document) && this.canEdit(document) && !workflow.isEnroute();
    }
}

