/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.commitments;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.commitments.AwardCostShare;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;

public class AwardCostShareAuditRule
implements DocumentAuditRule {
    private static final String AUDIT_CLUSTER = "costShareAuditErrors";
    private List<AuditError> auditErrors;

    public boolean processRunAuditBusinessRules(Document document) {
        boolean retval = true;
        AwardDocument awardDocument = (AwardDocument)document;
        Award award = awardDocument.getAward();
        if (!(retval &= this.validateCostShareDoesNotViolateUniqueConstraint(award.getAwardCostShares()))) {
            this.reportAndCreateAuditCluster();
        }
        return retval;
    }

    public boolean validateCostShareDoesNotViolateUniqueConstraint(List<AwardCostShare> awardCostShares) {
        boolean valid = true;
        for (AwardCostShare costShare1 : awardCostShares) {
            for (AwardCostShare costShare2 : awardCostShares) {
                if (costShare1 == costShare2 || !StringUtils.equals((String)costShare1.getProjectPeriod(), (String)costShare2.getProjectPeriod()) || !costShare1.getCostShareTypeCode().equals(costShare2.getCostShareTypeCode()) || !StringUtils.equalsIgnoreCase((String)costShare1.getSource(), (String)costShare2.getSource()) || !StringUtils.equalsIgnoreCase((String)costShare1.getDestination(), (String)costShare2.getDestination())) continue;
                valid = false;
                this.addAuditError(new AuditError("document.awardList[0].awardCostShares[" + awardCostShares.indexOf(costShare1) + "].fiscalYear", "error.awardCostShare.duplicate.entry", "commitments.CostShare"));
            }
        }
        return valid;
    }

    private void addAuditError(AuditError auditError) {
        if (this.auditErrors == null) {
            this.auditErrors = new ArrayList();
        }
        this.auditErrors.add(auditError);
    }

    protected void reportAndCreateAuditCluster() {
        if (this.auditErrors.size() > 0) {
            KNSGlobalVariables.getAuditErrorMap().put(AUDIT_CLUSTER, new AuditCluster("Cost Share", this.auditErrors, "Validation Errors"));
        }
    }
}

