/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.commitments;

import java.util.HashMap;
import org.kuali.kra.award.commitments.AwardCostShare;
import org.kuali.kra.award.commitments.AwardCostShareRule;
import org.kuali.kra.award.commitments.AwardCostShareRuleEvent;
import org.kuali.kra.bo.CostShareType;
import org.kuali.kra.costshare.CostShareRuleResearchDocumentBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.service.BusinessObjectService;

public class AwardCostShareRuleImpl
extends CostShareRuleResearchDocumentBase
implements AwardCostShareRule {
    private AwardCostShare awardCostShare;
    private String fieldStarter = "";

    public boolean processCostShareBusinessRules(AwardCostShareRuleEvent awardCostShareRuleEvent, int i) {
        this.fieldStarter = "document.awardList[0].awardCostShares[" + i + "]";
        this.awardCostShare = awardCostShareRuleEvent.getCostShareForValidation();
        return this.processCommonValidations(this.awardCostShare);
    }

    public boolean processAddCostShareBusinessRules(AwardCostShareRuleEvent awardCostShareRuleEvent) {
        this.awardCostShare = awardCostShareRuleEvent.getCostShareForValidation();
        this.fieldStarter = "costShareFormHelper.newAwardCostShare";
        boolean isValid = this.processCommonValidations(this.awardCostShare);
        isValid &= this.validatePercentage(this.awardCostShare.getCostSharePercentage());
        isValid &= this.validateCostShareType(this.awardCostShare.getCostShareTypeCode());
        isValid &= this.validateCommitmentAmount(this.awardCostShare.getCommitmentAmount());
        return isValid &= this.validateCostShareMet(this.awardCostShare.getCostShareMet());
    }

    public boolean processCommonValidations(AwardCostShare awardCostShare) {
        boolean validSourceAndDestination = this.validateCostShareSourceAndDestinationForEquality(awardCostShare);
        boolean validFiscalYearRange = this.validateCostShareFiscalYearRange(awardCostShare);
        return validSourceAndDestination && validFiscalYearRange;
    }

    public boolean validateCostShareSourceAndDestinationForEquality(AwardCostShare awardCostShare) {
        boolean valid = true;
        if (awardCostShare.getSource() != null && awardCostShare.getDestination() != null && awardCostShare.getSource().equals(awardCostShare.getDestination())) {
            valid = false;
            this.reportError(this.fieldStarter + ".source", "error.awardCostShare.source.destination", new String[0]);
        }
        return valid;
    }

    public boolean validateCostShareFiscalYearRange(AwardCostShare awardCostShare) {
        String projectPeriodField = this.fieldStarter + ".projectPeriod";
        return this.validateProjectPeriod((Object)awardCostShare.getProjectPeriod(), projectPeriodField);
    }

    private boolean validatePercentage(KualiDecimal percentage) {
        boolean isValid = true;
        if (percentage != null && percentage.isLessThan((AbstractKualiDecimal)new KualiDecimal(0))) {
            isValid = false;
            this.reportError(this.fieldStarter + ".costSharePercentage", "error.awardCostShare.percentage.range", new String[0]);
        }
        return isValid;
    }

    private boolean validateCostShareType(Integer costShareTypeCode) {
        boolean isValid = true;
        String costShareTypeCodeField = this.fieldStarter + ".costShareTypeCode";
        if (costShareTypeCode == null) {
            isValid = false;
            this.reportError(costShareTypeCodeField, "error.awardCostShare.costShareTypeCode.required", new String[0]);
        } else {
            BusinessObjectService businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
            HashMap<String, Integer> fieldValues = new HashMap<String, Integer>();
            fieldValues.put("costShareTypeCode", costShareTypeCode);
            if (businessObjectService.countMatching(CostShareType.class, fieldValues) != 1) {
                isValid = false;
                this.reportError(costShareTypeCodeField, "error.awardCostShare.costShareTypeCode.invalid", new String[]{costShareTypeCode.toString()});
            }
        }
        return isValid;
    }

    private boolean validateCommitmentAmount(KualiDecimal commitmentAmount) {
        boolean isValid = true;
        String commitmentAmountField = this.fieldStarter + ".commitmentAmount";
        if (commitmentAmount == null) {
            isValid = false;
            this.reportError(commitmentAmountField, "error.awardCostShare.commitmentAmount.required", new String[0]);
        } else if (commitmentAmount.isLessThan((AbstractKualiDecimal)new KualiDecimal(0))) {
            isValid = false;
            this.reportError(commitmentAmountField, "error.awardCostShare.commitmentAmount.invalid", new String[]{commitmentAmount.toString()});
        }
        return isValid;
    }

    private boolean validateCostShareMet(KualiDecimal costShareMet) {
        boolean isValid = true;
        if (costShareMet != null && costShareMet.isLessThan((AbstractKualiDecimal)new KualiDecimal(0))) {
            isValid = false;
            this.reportError(this.fieldStarter + ".costShareMet", "error.awardCostShare.costShareMet.invalid", new String[]{costShareMet.toString()});
        }
        return isValid;
    }
}

