/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.commitments;

import java.sql.Date;
import java.util.HashMap;
import org.kuali.kra.award.AwardAssociate;
import org.kuali.kra.award.budget.document.AwardBudgetDocument;
import org.kuali.kra.budget.rates.BudgetRate;
import org.kuali.kra.budget.rates.RateType;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;

public class AwardFandaRate
extends AwardAssociate {
    private static final long serialVersionUID = 1L;
    private Long awardFandaRateId;
    private KualiDecimal applicableFandaRate;
    private String fandaRateTypeCode;
    private String fiscalYear;
    private String onCampusFlag;
    private KualiDecimal underrecoveryOfIndirectCost;
    private String sourceAccount;
    private String destinationAccount;
    private Date startDate;
    private Date endDate;

    public Long getAwardFandaRateId() {
        return this.awardFandaRateId;
    }

    public void setAwardFandaRateId(Long awardFandaRateId) {
        this.awardFandaRateId = awardFandaRateId;
    }

    public KualiDecimal getApplicableFandaRate() {
        return this.applicableFandaRate;
    }

    public void resetPersistenceState() {
        this.awardFandaRateId = null;
    }

    public void setApplicableFandaRate(KualiDecimal applicableFandaRate) {
        this.applicableFandaRate = applicableFandaRate;
    }

    public String getFandaRateTypeCode() {
        return this.fandaRateTypeCode;
    }

    public void setFandaRateTypeCode(String fandaRateTypeCode) {
        this.fandaRateTypeCode = fandaRateTypeCode;
    }

    public String getFiscalYear() {
        return this.fiscalYear;
    }

    public void setFiscalYear(String fiscalYear) {
        this.fiscalYear = fiscalYear;
    }

    public String getOnCampusFlag() {
        return this.onCampusFlag;
    }

    public Boolean getOnOffCampusFlag() {
        return this.onCampusFlag.equals("N");
    }

    public void setOnCampusFlag(String onCampusFlag) {
        this.onCampusFlag = onCampusFlag;
    }

    public KualiDecimal getUnderrecoveryOfIndirectCost() {
        return this.underrecoveryOfIndirectCost;
    }

    public long getUnderrecoveryOfIndirectCostLongValue() {
        return this.underrecoveryOfIndirectCost != null ? this.underrecoveryOfIndirectCost.longValue() : 0L;
    }

    public void setUnderrecoveryOfIndirectCost(KualiDecimal underrecoveryOfIndirectCost) {
        this.underrecoveryOfIndirectCost = underrecoveryOfIndirectCost;
    }

    public String getSourceAccount() {
        return this.sourceAccount;
    }

    public void setSourceAccount(String sourceAccount) {
        this.sourceAccount = sourceAccount;
    }

    public String getDestinationAccount() {
        return this.destinationAccount;
    }

    public void setDestinationAccount(String destinationAccount) {
        this.destinationAccount = destinationAccount;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.applicableFandaRate == null ? 0 : this.applicableFandaRate.hashCode());
        result = 31 * result + (this.destinationAccount == null ? 0 : this.destinationAccount.hashCode());
        result = 31 * result + (this.endDate == null ? 0 : this.endDate.hashCode());
        result = 31 * result + (this.fandaRateTypeCode == null ? 0 : this.fandaRateTypeCode.hashCode());
        result = 31 * result + (this.fiscalYear == null ? 0 : this.fiscalYear.hashCode());
        result = 31 * result + (this.onCampusFlag == null ? 0 : this.onCampusFlag.hashCode());
        result = 31 * result + (this.sourceAccount == null ? 0 : this.sourceAccount.hashCode());
        result = 31 * result + (this.startDate == null ? 0 : this.startDate.hashCode());
        result = 31 * result + (this.underrecoveryOfIndirectCost == null ? 0 : this.underrecoveryOfIndirectCost.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwardFandaRate)) {
            return false;
        }
        return this.equals((AwardFandaRate)obj);
    }

    public boolean equals(AwardFandaRate awardFandaRate) {
        if (!super.equals((Object)awardFandaRate)) {
            return false;
        }
        if (this.applicableFandaRate == null ? awardFandaRate.applicableFandaRate != null : !this.applicableFandaRate.equals((Object)awardFandaRate.applicableFandaRate)) {
            return false;
        }
        if (this.destinationAccount == null ? awardFandaRate.destinationAccount != null : !this.destinationAccount.equals(awardFandaRate.destinationAccount)) {
            return false;
        }
        if (this.endDate == null ? awardFandaRate.endDate != null : !this.endDate.equals(awardFandaRate.endDate)) {
            return false;
        }
        if (this.fandaRateTypeCode == null ? awardFandaRate.fandaRateTypeCode != null : !this.fandaRateTypeCode.equals(awardFandaRate.fandaRateTypeCode)) {
            return false;
        }
        if (this.fiscalYear == null ? awardFandaRate.fiscalYear != null : !this.fiscalYear.equals(awardFandaRate.fiscalYear)) {
            return false;
        }
        if (this.onCampusFlag == null ? awardFandaRate.onCampusFlag != null : !this.onCampusFlag.equals(awardFandaRate.onCampusFlag)) {
            return false;
        }
        if (this.sourceAccount == null ? awardFandaRate.sourceAccount != null : !this.sourceAccount.equals(awardFandaRate.sourceAccount)) {
            return false;
        }
        if (this.startDate == null ? awardFandaRate.startDate != null : !this.startDate.equals(awardFandaRate.startDate)) {
            return false;
        }
        return !(this.underrecoveryOfIndirectCost == null ? awardFandaRate.underrecoveryOfIndirectCost != null : !this.underrecoveryOfIndirectCost.equals((Object)awardFandaRate.underrecoveryOfIndirectCost));
    }

    public boolean equals(BudgetRate budgetRate) {
        if (this.applicableFandaRate == null ? budgetRate.getApplicableRate() != null : !this.applicableFandaRate.equals((Object)budgetRate.getApplicableRate())) {
            return false;
        }
        if (this.fandaRateTypeCode == null ? budgetRate.getRateTypeCode() != null : !this.fandaRateTypeCode.toString().equals(budgetRate.getRateTypeCode())) {
            return false;
        }
        if (this.fiscalYear == null ? budgetRate.getFiscalYear() != null : !this.fiscalYear.equals(budgetRate.getFiscalYear())) {
            return false;
        }
        if (this.onCampusFlag == null ? budgetRate.getOnOffCampusFlag() != null : !this.getOnOffCampusFlag().equals(budgetRate.getOnOffCampusFlag())) {
            return false;
        }
        return !(this.startDate == null ? budgetRate.getStartDate() != null : !this.startDate.equals(budgetRate.getStartDate()));
    }

    public RateType getFandaRateType() {
        BusinessObjectService businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        ParameterService parameterService = (ParameterService)KraServiceLocator.getService(ParameterService.class);
        String rateClassCode = parameterService.getParameterValueAsString(AwardBudgetDocument.class, "awardBudgetDefaultFnARateClassCode");
        HashMap<String, String> qMap = new HashMap<String, String>();
        qMap.put("rateClassCode", rateClassCode);
        qMap.put("rateTypeCode", this.getFandaRateTypeCode());
        return (RateType)businessObjectService.findByPrimaryKey(RateType.class, qMap);
    }
}

