/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.contacts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.AwardPersonCreditSplit;
import org.kuali.kra.award.contacts.AwardPersonUnit;
import org.kuali.kra.award.contacts.AwardPersonUnitCreditSplit;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.CreditSplit;
import org.kuali.kra.proposaldevelopment.bo.InvestigatorCreditType;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;
import org.kuali.rice.krad.service.BusinessObjectService;

public class AwardPersonCreditSplitAuditRule
implements DocumentAuditRule {
    private static final String PERSON_TOTALS_KEY = "personTotalsKey";
    private static final long serialVersionUID = 1330497293834315534L;
    private static final String YES = "Y";
    private static final String AWARD_CREDIT_SPLIT_PARM_NAME = "award.creditsplit.enabled";
    private static final KualiDecimal ZERO_VALUE = new KualiDecimal(0);
    private static final KualiDecimal MAX_VALUE = new KualiDecimal(100.0);
    private static final KualiDecimal MAX_TOTAL_VALUE = new KualiDecimal(100.0);
    public static final String AWARD_CREDIT_SPLIT_LIST_ERROR_KEY = "document.awardList[0].projectPersons.awardPersonCreditSplits";
    public static final String AWARD_PERSON_CREDIT_SPLIT_ERROR_MSG_KEY = "error.award.person.credit.split.error";
    public static final String AWARD_UNIT_CREDIT_SPLIT_LIST_ERROR_KEY = "document.awardList[0].projectPersons.awardPersonUnitCreditSplits";
    public static final String AWARD_PERSON_UNIT_CREDIT_SPLIT_ERROR_MSG_KEY = "error.award.person.unit.credit.split.error";
    private static final String CONTACTS_AUDIT_ERRORS = "contactsCreditSplitAuditErrors";
    private transient Collection<InvestigatorCreditType> investigatorCreditTypes;
    private transient ParameterService parameterService;
    private List<AuditError> auditErrors = new ArrayList();

    public Collection<InvestigatorCreditType> getInvestigatorCreditTypes() {
        if (this.investigatorCreditTypes == null || this.investigatorCreditTypes.size() == 0) {
            this.investigatorCreditTypes = this.loadInvestigatorCreditTypes();
        }
        return this.investigatorCreditTypes;
    }

    public List<AwardPerson> getProjectPersons(AwardDocument awardDocument) {
        Collection creditTypes = this.getInvestigatorCreditTypes();
        List projectPersons = awardDocument.getAward().getProjectPersons();
        for (AwardPerson p : projectPersons) {
            this.createDefaultCreditSplitMapForProjectPerson(creditTypes, p);
            for (AwardPersonUnit apu : p.getUnits()) {
                this.createDefaultCreditSplitMapForPersonUnit(creditTypes, apu);
            }
        }
        return awardDocument.getAward().getProjectPersons();
    }

    public boolean isAwardCreditsLimitApplicable() {
        try {
            String parmValue = this.fetchParameterValue(AWARD_CREDIT_SPLIT_PARM_NAME);
            return parmValue.equalsIgnoreCase(YES);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean recalculateCreditSplit(AwardDocument awardDocument) {
        boolean noErrors = true;
        if (this.isAwardCreditsLimitApplicable()) {
            Map totalsMap = this.calculateCreditSplitTotals(awardDocument);
            noErrors = this.checkIfPersonTotalsAreValid(awardDocument, totalsMap);
            noErrors &= this.checkIfPersonUnitsTotalsAreValid(awardDocument, totalsMap);
        }
        return noErrors;
    }

    protected String fetchParameterValue(String parmName) {
        return this.getParameterService().getParameterValueAsString(AwardDocument.class, parmName);
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = (ParameterService)KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
    }

    Map<String, Map<String, KualiDecimal>> calculateCreditSplitTotals(AwardDocument awardDocument) {
        HashMap<String, Map<String, KualiDecimal>> allCreditSplitTotals = new HashMap<String, Map<String, KualiDecimal>>();
        this.calculatePersonTotals(awardDocument, allCreditSplitTotals);
        this.calculatePersonUnitTotals(awardDocument, allCreditSplitTotals);
        return allCreditSplitTotals;
    }

    Collection<InvestigatorCreditType> loadInvestigatorCreditTypes() {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        valueMap.put("active", "true");
        return this.getBusinessObjectService().findMatching(InvestigatorCreditType.class, valueMap);
    }

    private void calculatePersonTotalForCreditSplitType(AwardPerson projectPerson, InvestigatorCreditType creditType, Map<String, KualiDecimal> personCreditSplitTotalMap) {
        String creditTypeCode = creditType.getInvCreditTypeCode();
        KualiDecimal personsTotalCredit = personCreditSplitTotalMap.get(creditTypeCode);
        if (personsTotalCredit == null) {
            personsTotalCredit = ZERO_VALUE;
        }
        for (CreditSplit personCreditSplit : projectPerson.getCreditSplits()) {
            if (!personCreditSplit.getInvCreditTypeCode().equals(creditTypeCode)) continue;
            personCreditSplitTotalMap.put(creditTypeCode, (KualiDecimal)personsTotalCredit.add((AbstractKualiDecimal)personCreditSplit.getCredit()));
        }
    }

    private void calculatePersonTotals(AwardDocument awardDocument, Map<String, Map<String, KualiDecimal>> allCreditSplitTotals) {
        Collection creditTypes = this.getInvestigatorCreditTypes();
        Map personCreditSplitTotalMap = this.initializePersonCreditSplitTotalMap(allCreditSplitTotals);
        for (AwardPerson projectPerson : this.getProjectPersons(awardDocument)) {
            for (InvestigatorCreditType creditType : creditTypes) {
                this.calculatePersonTotalForCreditSplitType(projectPerson, creditType, personCreditSplitTotalMap);
            }
        }
    }

    private void calculatePersonUnitTotals(AwardDocument awardDocument, Map<String, Map<String, KualiDecimal>> allCreditSplitTotals) {
        Collection creditTypes = this.getInvestigatorCreditTypes();
        for (AwardPerson projectPerson : this.getProjectPersons(awardDocument)) {
            String personKey = this.getPersonKey(projectPerson);
            Map<String, KualiDecimal> personUnitCreditTotals = allCreditSplitTotals.get(personKey);
            if (personUnitCreditTotals == null) {
                personUnitCreditTotals = new HashMap<String, KualiDecimal>();
                allCreditSplitTotals.put(personKey, personUnitCreditTotals);
            }
            for (InvestigatorCreditType creditType : creditTypes) {
                String creditTypeCode;
                KualiDecimal totalCredit = personUnitCreditTotals.get(creditTypeCode = creditType.getInvCreditTypeCode());
                personUnitCreditTotals.put(creditTypeCode, totalCredit != null ? totalCredit : ZERO_VALUE);
            }
            this.calculateUnitCreditSplitTotals(projectPerson, personUnitCreditTotals);
        }
    }

    private void calculateUnitCreditSplitTotals(AwardPerson projectPerson, Map<String, KualiDecimal> personUnitCreditTotals) {
        if (projectPerson.isKeyPerson() && projectPerson.getUnits().size() == 0) {
            this.handleKeyPersonWithNoUnits(personUnitCreditTotals);
        } else {
            for (AwardPersonUnit unit : projectPerson.getUnits()) {
                for (CreditSplit creditSplit : unit.getCreditSplits()) {
                    KualiDecimal totalCredit = personUnitCreditTotals.get(creditSplit.getInvCreditTypeCode());
                    if (totalCredit == null) {
                        totalCredit = ZERO_VALUE;
                    }
                    personUnitCreditTotals.put(creditSplit.getInvCreditTypeCode(), (KualiDecimal)totalCredit.add((AbstractKualiDecimal)creditSplit.getCredit()));
                }
            }
        }
    }

    private void handleKeyPersonWithNoUnits(Map<String, KualiDecimal> personUnitCreditTotals) {
        Collection creditTypes = this.getInvestigatorCreditTypes();
        for (InvestigatorCreditType creditType : creditTypes) {
            personUnitCreditTotals.put(creditType.getInvCreditTypeCode(), MAX_VALUE);
        }
    }

    private boolean checkIfPersonTotalsAreValid(AwardDocument awardDocument, Map<String, Map<String, KualiDecimal>> totalsMap) {
        int errorCount = 0;
        for (InvestigatorCreditType creditType : this.loadInvestigatorCreditTypes()) {
            if (!creditType.addsToHundred().booleanValue()) continue;
            KualiDecimal value = totalsMap.get(PERSON_TOTALS_KEY).get(creditType.getInvCreditTypeCode());
            if (value == null) break;
            if (((KualiDecimal)MAX_TOTAL_VALUE.subtract((AbstractKualiDecimal)value)).isZero()) continue;
            this.auditErrors.add(new AuditError(AWARD_CREDIT_SPLIT_LIST_ERROR_KEY, AWARD_PERSON_CREDIT_SPLIT_ERROR_MSG_KEY, "contacts.Contacts", new String[]{creditType.getDescription()}));
            ++errorCount;
        }
        return errorCount == 0;
    }

    private boolean checkIfPersonUnitsTotalsAreValid(AwardDocument awardDocument, Map<String, Map<String, KualiDecimal>> totalsMap) {
        boolean success = true;
        for (AwardPerson person : awardDocument.getAward().getProjectPersons()) {
            int errorCount = 0;
            Map<String, KualiDecimal> totalsByCreditSplitType = totalsMap.get(this.getPersonKey(person));
            for (InvestigatorCreditType creditType : this.loadInvestigatorCreditTypes()) {
                if (!creditType.addsToHundred().booleanValue()) continue;
                KualiDecimal value = totalsByCreditSplitType.get(creditType.getInvCreditTypeCode());
                if (value == null) break;
                if (((KualiDecimal)MAX_TOTAL_VALUE.subtract((AbstractKualiDecimal)value)).isZero()) continue;
                this.auditErrors.add(new AuditError(AWARD_UNIT_CREDIT_SPLIT_LIST_ERROR_KEY, AWARD_PERSON_UNIT_CREDIT_SPLIT_ERROR_MSG_KEY, "contacts.Contacts", new String[]{creditType.getDescription(), person.getFullName()}));
                ++errorCount;
            }
            success &= errorCount == 0;
        }
        return success;
    }

    private void createDefaultCreditSplitMapForPersonUnit(Collection<InvestigatorCreditType> creditTypes, AwardPersonUnit apu) {
        HashMap<InvestigatorCreditType, AwardPersonUnitCreditSplit> personUnitCreditMap = new HashMap<InvestigatorCreditType, AwardPersonUnitCreditSplit>();
        for (AwardPersonUnitCreditSplit apuCreditSplit : apu.getCreditSplits()) {
            personUnitCreditMap.put(apuCreditSplit.getInvestigatorCreditType(), apuCreditSplit);
        }
        for (InvestigatorCreditType creditType : creditTypes) {
            if (personUnitCreditMap.get(creditType) != null) continue;
            apu.add(new AwardPersonUnitCreditSplit(creditType, ZERO_VALUE));
        }
    }

    private void createDefaultCreditSplitMapForProjectPerson(Collection<InvestigatorCreditType> creditTypes, AwardPerson projectPerson) {
        HashMap<InvestigatorCreditType, AwardPersonCreditSplit> personCreditMap = new HashMap<InvestigatorCreditType, AwardPersonCreditSplit>();
        for (AwardPersonCreditSplit creditSplit : projectPerson.getCreditSplits()) {
            personCreditMap.put(creditSplit.getInvestigatorCreditType(), creditSplit);
        }
        for (InvestigatorCreditType creditType : creditTypes) {
            if (personCreditMap.get(creditType) != null) continue;
            projectPerson.add(new AwardPersonCreditSplit(creditType, ZERO_VALUE));
        }
    }

    private String getPersonKey(AwardPerson projectPerson) {
        String personKey = "";
        if (projectPerson != null) {
            personKey = projectPerson.getIsRolodexPerson() ? projectPerson.getRolodex().getOrganization() : projectPerson.getFullName();
        }
        return personKey;
    }

    private Map<String, KualiDecimal> initializePersonCreditSplitTotalMap(Map<String, Map<String, KualiDecimal>> allCreditSplitTotals) {
        Map<String, KualiDecimal> personCreditTypeTotals = allCreditSplitTotals.get(PERSON_TOTALS_KEY);
        if (personCreditTypeTotals == null) {
            personCreditTypeTotals = new HashMap<String, KualiDecimal>();
            allCreditSplitTotals.put(PERSON_TOTALS_KEY, personCreditTypeTotals);
        }
        return personCreditTypeTotals;
    }

    public boolean processRunAuditBusinessRules(Document document) {
        AwardDocument awardDocument = (AwardDocument)document;
        boolean valid = this.recalculateCreditSplit(awardDocument);
        this.reportAndCreateAuditCluster();
        return valid;
    }

    protected void reportAndCreateAuditCluster() {
        if (this.auditErrors.size() > 0) {
            KNSGlobalVariables.getAuditErrorMap().put(CONTACTS_AUDIT_ERRORS, new AuditCluster("Contacts", this.auditErrors, "Validation Errors"));
        }
    }
}

