/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.contacts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.contacts.AwardContactsProjectRoleValuesFinder;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.ContactRole;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.logging.BufferedLogger;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonRole;
import org.kuali.kra.proposaldevelopment.service.KeyPersonnelService;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.kns.util.KNSGlobalVariables;

public class AwardPersonProjectRolesValuesFinder
extends AwardContactsProjectRoleValuesFinder {
    private KeyPersonnelService keyPersonnelService;

    public List getKeyValues() {
        Collection roles = this.getKeyValuesService().findAll(ProposalPersonRole.class);
        AwardDocument awardDocument = ((AwardForm)KNSGlobalVariables.getKualiForm()).getAwardDocument();
        Award sponsorable = awardDocument.getAward();
        Map roleDescriptions = this.getKeyPersonnelService().loadKeyPersonnelRoleDescriptions(sponsorable.isSponsorNihMultiplePi());
        ArrayList<ConcreteKeyValue> keyValues = new ArrayList<ConcreteKeyValue>();
        keyValues.add(new ConcreteKeyValue("", "select"));
        for (ProposalPersonRole role : roles) {
            boolean showRole = true;
            BufferedLogger.info((Object[])new Object[]{"showRole = ", showRole});
            if (showRole) {
                String roleDescription = (String)roleDescriptions.get(role.getRoleCode());
                keyValues.add(new ConcreteKeyValue(role.getProposalPersonRoleId(), roleDescription));
                BufferedLogger.info((Object[])new Object[]{"Added role ", role.getProposalPersonRoleId()});
                BufferedLogger.info((Object[])new Object[]{"With description ", roleDescription});
            }
            BufferedLogger.info((Object[])new Object[]{"Returning ", keyValues});
        }
        return keyValues;
    }

    protected KeyPersonnelService getKeyPersonnelService() {
        if (this.keyPersonnelService == null) {
            this.keyPersonnelService = (KeyPersonnelService)KraServiceLocator.getService(KeyPersonnelService.class);
        }
        return this.keyPersonnelService;
    }

    protected Class<? extends ContactRole> getRoleType() {
        return ProposalPersonRole.class;
    }

    protected void setKeyPersonnelService(KeyPersonnelService keyPersonnelService) {
        this.keyPersonnelService = keyPersonnelService;
    }
}

