/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.contacts;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.contacts.AwardContact;
import org.kuali.kra.award.contacts.AwardContactsBean;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.AwardPersonUnit;
import org.kuali.kra.award.contacts.AwardPersonUnitAddRuleImpl;
import org.kuali.kra.award.contacts.AwardPersonUnitRuleAddEvent;
import org.kuali.kra.award.contacts.AwardProjectPersonAddRuleImpl;
import org.kuali.kra.award.contacts.AwardProjectPersonRuleAddEvent;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.ContactRole;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonRole;
import org.kuali.rice.krad.document.Document;

public class AwardProjectPersonnelBean
extends AwardContactsBean {
    private static final long serialVersionUID = -8213637358006756203L;
    private AwardPersonUnit[] newAwardPersonUnits;
    private transient String selectedLeadUnit;

    public AwardProjectPersonnelBean(AwardForm awardForm) {
        super(awardForm);
    }

    public AwardPersonUnit addNewProjectPersonUnit(int projectPersonIndex) {
        AwardPerson person = (AwardPerson)this.getAward().getProjectPersons().get(projectPersonIndex);
        AwardPersonUnitRuleAddEvent event = this.generateAddPersonUnitEvent(person, projectPersonIndex);
        AwardPersonUnit newUnit = this.newAwardPersonUnits[projectPersonIndex];
        boolean success = new AwardPersonUnitAddRuleImpl().processAddAwardPersonUnitBusinessRules(event);
        if (success) {
            person.add(this.newAwardPersonUnits[projectPersonIndex]);
            if (this.newAwardPersonUnits[projectPersonIndex].isLeadUnit()) {
                this.getAward().setLeadUnit(this.newAwardPersonUnits[projectPersonIndex].getUnit());
                this.setSelectedLeadUnit(this.newAwardPersonUnits[projectPersonIndex].getUnitName());
            }
            this.initNewAwardPersonUnits();
        }
        return newUnit;
    }

    public AwardPerson addProjectPerson() {
        AwardProjectPersonRuleAddEvent event = this.generateAddProjectPersonEvent();
        boolean success = new AwardProjectPersonAddRuleImpl().processAddAwardProjectPersonBusinessRules(event);
        if (success) {
            AwardPerson awardPerson = this.getNewProjectPerson();
            this.getAward().add(awardPerson);
            this.init();
            if (awardPerson.isPrincipalInvestigator()) {
                awardPerson.getUnits().add(new AwardPersonUnit(awardPerson, this.getAward().getLeadUnit(), true));
            } else if (awardPerson.isEmployee() && !awardPerson.isKeyPerson()) {
                if (awardPerson.getPerson().getUnit() != null) {
                    awardPerson.getUnits().add(new AwardPersonUnit(awardPerson, awardPerson.getPerson().getUnit(), false));
                }
            } else if (!awardPerson.isEmployee()) {
                awardPerson.getUnits().add(new AwardPersonUnit(awardPerson, awardPerson.getRolodex().getUnit(), false));
            }
            return awardPerson;
        }
        return null;
    }

    public void deleteProjectPerson(int lineToDelete) {
        List projectPersons = this.getProjectPersonnel();
        if (projectPersons.size() > lineToDelete) {
            projectPersons.remove(lineToDelete);
        }
    }

    public void deleteProjectPersonUnit(int projectPersonIndex, int unitIndex) {
        ((AwardPerson)this.getAward().getProjectPersons().get(projectPersonIndex)).getUnits().remove(unitIndex);
    }

    public AwardPersonUnit getNewAwardPersonUnit(int projectPersonIndex) {
        if (this.newAwardPersonUnits == null || this.newAwardPersonUnits.length < projectPersonIndex + 1) {
            this.initNewAwardPersonUnits();
        }
        return this.newAwardPersonUnits[projectPersonIndex];
    }

    public AwardPersonUnit[] getNewAwardPersonUnits() {
        for (AwardPersonUnit apu : this.newAwardPersonUnits) {
            this.lazyLoadUnit(apu);
        }
        return this.newAwardPersonUnits;
    }

    public AwardPerson getNewProjectPerson() {
        return (AwardPerson)this.newAwardContact;
    }

    public String getNewUnitNumber(int projectPersonIndex) {
        return this.newAwardPersonUnits[projectPersonIndex].getUnit() != null ? this.newAwardPersonUnits[projectPersonIndex].getUnit().getUnitNumber() : null;
    }

    public List<AwardPerson> getProjectPersonnel() {
        return this.getAward().getProjectPersons();
    }

    public int getProjectPersonnelCount() {
        return this.getProjectPersonnel().size();
    }

    public String getSelectedLeadUnit() {
        this.selectedLeadUnit = "";
        for (AwardPerson p : this.getProjectPersonnel()) {
            if (!p.isPrincipalInvestigator()) continue;
            for (AwardPersonUnit apu : p.getUnits()) {
                if (!apu.isLeadUnit()) continue;
                this.selectedLeadUnit = apu.getUnitName();
            }
        }
        return this.selectedLeadUnit;
    }

    public String getUnitName(int projectPersonIndex) {
        return this.newAwardPersonUnits[projectPersonIndex].getUnit() != null ? this.newAwardPersonUnits[projectPersonIndex].getUnit().getUnitName() : null;
    }

    public String getUnitNumber(int projectPersonIndex) {
        return this.getNewUnitNumber(projectPersonIndex);
    }

    public void setSelectedLeadUnit(String unitName) {
        this.selectedLeadUnit = unitName;
        this.setLeadUnitSelectionStates(unitName);
    }

    protected AwardContact createNewContact() {
        return new AwardPerson();
    }

    protected Class<? extends ContactRole> getContactRoleType() {
        return ProposalPersonRole.class;
    }

    protected void init() {
        super.init();
        this.initNewAwardPersonUnits();
    }

    private AwardPerson findPrincipalInvestigator() {
        AwardPerson awardPerson = null;
        for (AwardContact person : this.getAward().getProjectPersons()) {
            if (!"PI".equals(person.getContactRole().getRoleCode())) continue;
            awardPerson = (AwardPerson)person;
            break;
        }
        return awardPerson;
    }

    private AwardPersonUnitRuleAddEvent generateAddPersonUnitEvent(AwardPerson projectPerson, int addUnitPersonIndex) {
        return new AwardPersonUnitRuleAddEvent("AwardPersonUnitRuleAddEvent", "projectPersonnelBean.newAwardPersonUnit", (Document)this.getDocument(), projectPerson, this.newAwardPersonUnits[addUnitPersonIndex], addUnitPersonIndex);
    }

    private AwardProjectPersonRuleAddEvent generateAddProjectPersonEvent() {
        return new AwardProjectPersonRuleAddEvent("AddAwardProjectPersonRuleEvent", "projectPersonnelBean.newAwardContact", (Document)this.getDocument(), (AwardPerson)this.newAwardContact);
    }

    private void initNewAwardPersonUnits() {
        this.newAwardPersonUnits = new AwardPersonUnit[this.getAward().getProjectPersons().size()];
        int personIndex = 0;
        for (AwardPerson p : this.getAward().getProjectPersons()) {
            this.newAwardPersonUnits[personIndex++] = new AwardPersonUnit(p);
        }
    }

    private void lazyLoadUnit(AwardPersonUnit awardPersonUnit) {
        if (awardPersonUnit.getUnitNumber() != null && awardPersonUnit.getUnit() == null) {
            HashMap<String, String> identifiers = new HashMap<String, String>();
            identifiers.put("unitNumber", awardPersonUnit.getUnitNumber());
            Unit newUnit = (Unit)this.getBusinessObjectService().findByPrimaryKey(Unit.class, identifiers);
            awardPersonUnit.setUnit(newUnit);
        }
    }

    private void setLeadUnitSelectionStates(String unitName) {
        AwardPerson awardPerson = this.findPrincipalInvestigator();
        if (awardPerson != null) {
            for (AwardPersonUnit associatedUnit : awardPerson.getUnits()) {
                associatedUnit.setLeadUnit(unitName.equals(associatedUnit.getUnit().getUnitName()));
            }
        }
    }

    public void updateLeadUnit() {
        Award award = this.awardForm.getAwardDocument().getAward();
        AwardPerson pi = this.findPrincipalInvestigator();
        if (pi == null) {
            return;
        }
        String leadUnitNumber = award.getLeadUnitNumber();
        boolean foundLeadUnit = false;
        for (AwardPersonUnit curUnit : pi.getUnits()) {
            if (StringUtils.equals((String)curUnit.getUnitNumber(), (String)leadUnitNumber)) {
                if (!curUnit.isLeadUnit()) {
                    curUnit.setLeadUnit(true);
                    award.refreshReferenceObject("leadUnit");
                }
                foundLeadUnit = true;
                continue;
            }
            curUnit.setLeadUnit(false);
        }
        if (!foundLeadUnit) {
            AwardPersonUnit newLeadUnit = new AwardPersonUnit();
            newLeadUnit.setUnitNumber(leadUnitNumber);
            newLeadUnit.setLeadUnit(true);
            pi.add(newLeadUnit);
            award.refreshReferenceObject("leadUnit");
        }
    }

    public void addUnitDetails(AwardPerson person) {
        person.setOptInUnitStatus(true);
        if (person.getPerson() != null && person.getPerson().getUnit() != null) {
            person.add(new AwardPersonUnit(person, person.getPerson().getUnit(), true));
        }
    }

    public void removeUnitDetails(AwardPerson person) {
        person.setOptInUnitStatus(false);
        person.getUnits().clear();
    }
}

