/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.contacts;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.contacts.AwardContact;
import org.kuali.kra.award.home.ContactRole;
import org.kuali.kra.award.home.ContactType;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.NonOrganizationalRolodex;
import org.kuali.kra.bo.UnitAdministrator;
import org.kuali.kra.bo.UnitAdministratorType;
import org.kuali.kra.bo.UnitContactType;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.krad.service.BusinessObjectService;

public class AwardUnitContact
extends AwardContact {
    public static final String OSP_ADMINISTRATOR = "OSP_ADMINISTRATOR";
    private static final String UNIT_ADMINISTRATOR_TYPE_CODE = "UNIT_ADMINISTRATOR_TYPE_CODE";
    private static final String CONTACT_TYPE_CODE = "CONTACT_TYPE_CODE";
    private static final long serialVersionUID = -9168956728201616266L;
    private UnitContactType unitContactType;
    private UnitAdministratorType unitAdministratorType;
    private String unitAdministratorTypeCode;
    private String unitAdministratorUnitNumber;
    private boolean defaultUnitContact;

    public AwardUnitContact() {
    }

    public AwardUnitContact(NonOrganizationalRolodex rolodex, ContactRole role, UnitContactType unitContactType) {
        super(rolodex, role);
        this.unitContactType = unitContactType;
    }

    public AwardUnitContact(KcPerson person, ContactRole role, UnitContactType unitContactType) {
        super(person, role);
        this.unitContactType = unitContactType;
        this.unitAdministratorUnitNumber = person.getUnit() != null ? person.getUnit().getUnitNumber() : null;
    }

    AwardUnitContact(UnitContactType unitContactType) {
        this.unitContactType = unitContactType;
    }

    public void setPersonId(String personId) {
        super.setPersonId(personId);
        if (this.getPerson() != null && this.getPerson().getUnit() != null) {
            this.setUnitAdministratorUnitNumber(this.getPerson().getUnit().getUnitNumber());
        }
    }

    public void setPerson(KcPerson person) {
        super.setPerson(person);
        if (this.getPerson() != null && this.getPerson().getUnit() != null) {
            this.setUnitAdministratorUnitNumber(this.getPerson().getUnit().getUnitNumber());
        }
    }

    public String getUnitAdministratorUnitNumberByPersonId() {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("unitNumber", this.getAward().getLeadUnitNumber());
        criteria.put("personId", this.getPerson().getPersonId());
        ArrayList results = new ArrayList(this.getBusinessObjectService().findMatching(UnitAdministrator.class, criteria));
        if (results.size() == 0) {
            return this.getPerson().getUnit().getUnitNumber();
        }
        return ((UnitAdministrator)results.get(0)).getUnitNumber();
    }

    public String getUnitNumberForDisplay() {
        if (this.unitAdministratorUnitNumber == null) {
            try {
                return this.getPerson().getUnit().getUnitNumber();
            }
            catch (NullPointerException nxp) {
                return "";
            }
        }
        return this.unitAdministratorUnitNumber;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return (BusinessObjectService)KraServiceLocator.getService((String)"businessObjectService");
    }

    public UnitContactType getUnitContactType() {
        return this.unitContactType;
    }

    public UnitAdministratorType getUnitAdministratorType() {
        return this.unitAdministratorType;
    }

    public void setUnitAdministratorType(UnitAdministratorType unitAdministratorType) {
        this.unitAdministratorType = unitAdministratorType;
    }

    public String getUnitAdministratorTypeCode() {
        return this.unitAdministratorTypeCode;
    }

    public void setUnitAdministratorTypeCode(String unitAdministratorTypeCode) {
        this.unitAdministratorTypeCode = unitAdministratorTypeCode;
    }

    public String getUnitAdministratorUnitNumber() {
        return this.unitAdministratorUnitNumber;
    }

    public void setUnitAdministratorUnitNumber(String unitAdministratorUnitNumber) {
        this.unitAdministratorUnitNumber = unitAdministratorUnitNumber;
    }

    public boolean isOspAdministrator() {
        return this.getUnitAdministratorType() != null && StringUtils.equals((String)this.getUnitAdministratorType().getDescription(), (String)OSP_ADMINISTRATOR);
    }

    public void setUnitContactType(UnitContactType contactType) {
        this.unitContactType = contactType;
    }

    protected Class<? extends ContactRole> getContactRoleType() {
        return this.getUnitContactType() == UnitContactType.ADMINISTRATOR ? UnitAdministratorType.class : ContactType.class;
    }

    protected String getContactRoleTypeIdentifier() {
        return this.getUnitContactType() == UnitContactType.ADMINISTRATOR ? UNIT_ADMINISTRATOR_TYPE_CODE : CONTACT_TYPE_CODE;
    }

    public boolean isDefaultUnitContact() {
        return this.defaultUnitContact;
    }

    public void setDefaultUnitContact(boolean defaultUnitContact) {
        this.defaultUnitContact = defaultUnitContact;
    }
}

