/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.contacts;

import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.contacts.AwardUnitContact;
import org.kuali.kra.award.contacts.BaseAwardContactAddRule;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.bo.UnitAdministratorType;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardUnitContactAddRuleImpl
extends BaseAwardContactAddRule {
    public static final String AWARD_UNIT_CONTACT_LIST_ERROR_KEY = "unitContactsBean.unitContact.unitAdministratorTypeCode";
    public static final String ERROR_AWARD_UNIT_CONTACT_EXISTS = "error.awardUnitContact.person.exists";
    private static final String PERSON_ERROR_KEY = "unitContactsBean.newAwardContact.fullName";

    public boolean processAddAwardUnitContactBusinessRules(Award award, AwardUnitContact newUnitContact) {
        boolean valid = this.checkForSelectedContactAdministratorTypeCode(newUnitContact);
        valid &= this.checkForDuplicatePerson(award, newUnitContact);
        return valid &= this.checkForSelectedPerson(newUnitContact);
    }

    public boolean checkForSelectedContactAdministratorTypeCode(AwardUnitContact newContact) {
        boolean valid;
        AwardUnitContact awardUnitContact = newContact;
        boolean bl = valid = awardUnitContact.getUnitAdministratorTypeCode() != null;
        if (!valid) {
            GlobalVariables.getMessageMap().putError(AWARD_UNIT_CONTACT_LIST_ERROR_KEY, "error.award.contact.person.role.required", new String[0]);
        }
        return valid;
    }

    private boolean checkForSelectedPerson(AwardUnitContact newContact) {
        boolean valid = true;
        if (StringUtils.isBlank((String)newContact.getPersonId())) {
            if (StringUtils.isBlank((String)newContact.getFullName())) {
                GlobalVariables.getMessageMap().putError(PERSON_ERROR_KEY, "error.unitContact.missing.person", new String[0]);
            } else {
                GlobalVariables.getMessageMap().putError(PERSON_ERROR_KEY, "error.unitContact.invalid.person", new String[0]);
            }
            valid = false;
        }
        return valid;
    }

    boolean checkForDuplicatePerson(Award award, AwardUnitContact newUnitContact) {
        boolean valid = true;
        for (AwardUnitContact unitContact : award.getAwardUnitContacts()) {
            valid = !StringUtils.equals((String)unitContact.getPersonId(), (String)newUnitContact.getPersonId()) || !StringUtils.equals((String)unitContact.getUnitAdministratorTypeCode(), (String)newUnitContact.getUnitAdministratorTypeCode());
            if (valid) continue;
            this.registerError(newUnitContact);
            break;
        }
        return valid;
    }

    private void registerError(AwardUnitContact newUnitContact) {
        String roleDescription = this.getRoleDescription(newUnitContact);
        GlobalVariables.getMessageMap().putError(PERSON_ERROR_KEY, ERROR_AWARD_UNIT_CONTACT_EXISTS, new String[]{newUnitContact.getContact().getFullName(), roleDescription});
    }

    private String getRoleDescription(AwardUnitContact newUnitContact) {
        String roleDescription = "";
        BusinessObjectService boService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        UnitAdministratorType aType = (UnitAdministratorType)boService.findBySinglePrimaryKey(UnitAdministratorType.class, (Object)newUnitContact.getUnitAdministratorTypeCode());
        if (aType != null) {
            roleDescription = aType.getDescription();
        }
        return roleDescription;
    }
}

