/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.contacts;

import org.kuali.kra.award.home.ContactRole;
import org.kuali.kra.award.home.ContactType;
import org.kuali.kra.bo.UnitAdministratorType;
import org.kuali.kra.bo.UnitContactType;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonRole;

public final class ContactRoleFixtureFactory {
    public static final ContactRole MOCK_PI = ContactRoleFixtureFactory.getProposalPersonRole((String)"PI", (String)"Principal Investigator");
    public static final ContactRole MOCK_COI = ContactRoleFixtureFactory.getProposalPersonRole((String)"COI", (String)"Co-Investigator");
    public static final ContactRole MOCK_KEY_PERSON = ContactRoleFixtureFactory.getProposalPersonRole((String)"KP", (String)"Key Person");
    static final ContactRole MOCK_ACCOUNTANT = ContactRoleFixtureFactory.getUnitAdministratorType((String)"11", (String)"Accountant", (UnitContactType)UnitContactType.CONTACT);
    static final ContactRole MOCK_ADMIN_ASSISTANT = ContactRoleFixtureFactory.getUnitAdministratorType((String)"12", (String)"Admin Assistant", (UnitContactType)UnitContactType.CONTACT);
    static final ContactRole MOCK_BUSINESS_MANAGER = ContactRoleFixtureFactory.getUnitAdministratorType((String)"13", (String)"Business Manager", (UnitContactType)UnitContactType.CONTACT);
    static final ContactRole MOCK_SENIOR_ACCOUNTANT = ContactRoleFixtureFactory.getContactType((String)"16", (String)"Senior Accountant");
    static final ContactRole MOCK_ADMINISTRATIVE_CONTACT1 = ContactRoleFixtureFactory.getContactType((String)"17", (String)"Administrative Contact - 1");
    static final ContactRole MOCK_ADMINISTRATIVE_CONTACT2 = ContactRoleFixtureFactory.getContactType((String)"18", (String)"Administrative Contact - 2");
    static final ContactRole MOCK_AWARD_OFFICE_CONTACT1 = ContactRoleFixtureFactory.getContactType((String)"19", (String)"Award Office Contact - 1");
    static final ContactRole MOCK_AWARD_OFFICE_CONTACT2 = ContactRoleFixtureFactory.getContactType((String)"20", (String)"Award Office Contact - 2");
    static final ContactRole MOCK_CLOSEOUT_CONTACT = ContactRoleFixtureFactory.getContactType((String)"21", (String)"Closeout Contact");
    static final ContactRole MOCK_AUDITOR = ContactRoleFixtureFactory.getUnitAdministratorType((String)"14", (String)"Auditor", (UnitContactType)UnitContactType.ADMINISTRATOR);
    static final ContactRole MOCK_FUND_ACCOUNTANT = ContactRoleFixtureFactory.getUnitAdministratorType((String)"15", (String)"Fund Accountant", (UnitContactType)UnitContactType.ADMINISTRATOR);

    private ContactRoleFixtureFactory() {
    }

    private static ContactRole getProposalPersonRole(String code, String description) {
        ProposalPersonRole role = new ProposalPersonRole();
        role.setProposalPersonRoleId(code);
        role.setDescription(description);
        return role;
    }

    private static ContactRole getUnitAdministratorType(String code, String description, UnitContactType unitContactType) {
        UnitAdministratorType type = new UnitAdministratorType();
        type.setUnitAdministratorTypeCode(code);
        type.setDescription(description);
        type.setUnitContactType(unitContactType);
        return type;
    }

    private static ContactRole getContactType(String code, String description) {
        ContactType role = new ContactType();
        role.setContactTypeCode(code);
        role.setDescription(description);
        return role;
    }
}

