/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.document.authorization;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.authorization.ApplicationTask;
import org.kuali.kra.authorization.KcTransactionalDocumentAuthorizerBase;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.award.awardhierarchy.AwardHierarchy;
import org.kuali.kra.award.awardhierarchy.AwardHierarchyService;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.document.authorization.AwardTask;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.infrastructure.AwardTaskNames;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.timeandmoney.AwardHierarchyNode;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardDocumentAuthorizer
extends KcTransactionalDocumentAuthorizerBase {
    private AwardHierarchyService awardHierarchyService;

    public Set<String> getEditModes(Document document, Person user, Set<String> currentEditModes) {
        HashSet<String> editModes = new HashSet<String>();
        AwardDocument awardDocument = (AwardDocument)document;
        if (awardDocument.getAward().getAwardId() == null) {
            if (this.canCreateAward(user.getPrincipalId())) {
                editModes.add("fullEntry");
                if (this.canViewChartOfAccountsElement(awardDocument)) {
                    editModes.add("viewChartOfAccountsElement");
                }
                if (this.canViewAccountElement(awardDocument)) {
                    editModes.add("viewAccountElement");
                }
            } else {
                editModes.add("unviewable");
            }
        } else {
            boolean isCanceled = awardDocument.isCanceled();
            if (!awardDocument.isCanceled() && this.canExecuteAwardTask(user.getPrincipalId(), awardDocument, AwardTaskNames.MODIFY_AWARD.getAwardTaskName())) {
                editModes.add("fullEntry");
            } else if (this.canExecuteAwardTask(user.getPrincipalId(), awardDocument, AwardTaskNames.VIEW_AWARD.getAwardTaskName())) {
                editModes.add("viewOnly");
            } else {
                editModes.add("unviewable");
            }
            if (!isCanceled && this.canExecuteAwardTask(user.getPrincipalId(), awardDocument, "addBudget")) {
                editModes.add("addBudget");
            }
            if (this.canExecuteAwardTask(user.getPrincipalId(), awardDocument, "openBudgets")) {
                editModes.add("openBudgets");
            }
            if (!isCanceled && this.canExecuteAwardTask(user.getPrincipalId(), awardDocument, "modifyBudget")) {
                editModes.add("modifyAwardBudget");
            }
            if (this.canCreateAward(user.getPrincipalId())) {
                editModes.add("canCreateAward");
            }
            if (this.canCreateAwardAccount(document, user)) {
                editModes.add("createAwardAccount");
            }
            if (this.awardHasHierarchyChildren(document)) {
                editModes.add("awardSync");
            }
            if (this.canViewChartOfAccountsElement(awardDocument)) {
                editModes.add("viewChartOfAccountsElement");
            }
            if (this.canViewAccountElement(awardDocument)) {
                editModes.add("viewAccountElement");
            }
        }
        return editModes;
    }

    public boolean canInitiate(String documentTypeName, Person user) {
        return this.canCreateAward(user.getPrincipalId());
    }

    public boolean canCreateAwardAccount(Document document, Person user) {
        AwardDocument awardDocument = (AwardDocument)document;
        Award award = awardDocument.getAward();
        boolean hasPermission = false;
        String status = document.getDocumentHeader().getWorkflowDocument().getStatus().getCode();
        if ((status.equalsIgnoreCase("P") || status.equalsIgnoreCase("F")) && this.isFinancialSystemIntegrationParameterOn()) {
            hasPermission = this.hasCreateAccountPermission(awardDocument);
            if (award.getFinancialAccountDocumentNumber() != null) {
                hasPermission = true;
            }
        }
        return hasPermission;
    }

    protected boolean isFinancialSystemIntegrationParameterOn() {
        Boolean awardAccountParameter = this.getParameterService().getParameterValueAsBoolean("KC-AWARD", "Document", "FIN_SYSTEM_INTEGRATION_ON");
        return awardAccountParameter;
    }

    public boolean hasCreateAccountPermission(AwardDocument document) {
        return this.canExecuteAwardTask(GlobalVariables.getUserSession().getPrincipalId(), document, AwardTaskNames.CREATE_AWARD_ACCOUNT.getAwardTaskName());
    }

    public boolean canViewChartOfAccountsElement(AwardDocument document) {
        return this.hasCreateAccountPermission(document) && this.isFinancialSystemIntegrationParameterOn();
    }

    public boolean canViewAccountElement(AwardDocument document) {
        boolean hasPermission = true;
        if (this.isFinancialSystemIntegrationParameterOn() && !this.hasCreateAccountPermission(document)) {
            hasPermission = false;
        }
        return hasPermission;
    }

    public boolean canOpen(Document document, Person user) {
        AwardDocument awardDocument = (AwardDocument)document;
        if (awardDocument.getAward().getAwardId() == null) {
            return this.canCreateAward(user.getPrincipalId());
        }
        return this.canExecuteAwardTask(user.getPrincipalId(), (AwardDocument)document, AwardTaskNames.VIEW_AWARD.getAwardTaskName());
    }

    public boolean canEdit(Document document, Person user) {
        boolean isCanceled = ((AwardDocument)document).isCanceled();
        return !isCanceled && this.canExecuteAwardTask(user.getPrincipalId(), (AwardDocument)document, AwardTaskNames.MODIFY_AWARD.getAwardTaskName());
    }

    public boolean canSave(Document document, Person user) {
        return this.canEdit(document, user);
    }

    public boolean canCopy(Document document, Person user) {
        return false;
    }

    private boolean doesAwardHierarchyContainFinalChildren(AwardHierarchy currentAward, Map<String, AwardHierarchyNode> awardHierarchyNodes) {
        for (AwardHierarchy child : currentAward.getChildren()) {
            AwardHierarchyNode childInfo = awardHierarchyNodes.get(child.getAwardNumber());
            if (childInfo.isAwardDocumentFinalStatus().booleanValue()) {
                return true;
            }
            this.doesAwardHierarchyContainFinalChildren((AwardHierarchy)childInfo, awardHierarchyNodes);
        }
        return false;
    }

    private boolean isCurrentAwardTheFirstVersion(Award currentAward) {
        return currentAward.getSequenceNumber() == 1;
    }

    public boolean canCancel(Document document, Person user) {
        if (!this.canEdit(document, user)) {
            return false;
        }
        boolean canCancel = true;
        DocumentHeader docHeader = document.getDocumentHeader();
        WorkflowDocument workflowDoc = docHeader.getWorkflowDocument();
        if (workflowDoc.isSaved()) {
            AwardDocument awardDocument = (AwardDocument)document;
            AwardHierarchyService awardHierarchyService = (AwardHierarchyService)KraServiceLocator.getService(AwardHierarchyService.class);
            Award currentAward = awardDocument.getAward();
            HashMap awardHierarchyNodes = new HashMap();
            Map awardHierarchyItems = awardHierarchyService.getAwardHierarchy(awardDocument.getAward().getAwardNumber(), new ArrayList());
            AwardHierarchy currentAwardNode = (AwardHierarchy)awardHierarchyItems.get(currentAward.getAwardNumber());
            if (currentAwardNode.isRootNode() && this.isCurrentAwardTheFirstVersion(currentAward)) {
                awardHierarchyService.populateAwardHierarchyNodes(awardHierarchyItems, awardHierarchyNodes, currentAward.getAwardNumber(), currentAward.getSequenceNumber().toString());
                canCancel = !this.doesAwardHierarchyContainFinalChildren(currentAwardNode, awardHierarchyNodes);
            }
        }
        return canCancel;
    }

    public boolean canApprove(Document document, Person user) {
        return this.isEnroute(document) && super.canApprove(document, user);
    }

    public boolean canDisapprove(Document document, Person user) {
        return this.canApprove(document, user);
    }

    public boolean canBlanketApprove(Document document, Person user) {
        if (!this.isFinal(document) && this.isAuthorizedByTemplate((BusinessObject)document, "KR-WKFLW", "Blanket Approve Document", user.getPrincipalId()) && super.canBlanketApprove(document, user)) {
            try {
                if (this.getParameterService().getParameterValueAsBoolean("KR-NS", "Document", "ALLOW_ENROUTE_BLANKET_APPROVE_WITHOUT_APPROVAL_REQUEST_IND").booleanValue()) {
                    return this.canEdit(document);
                }
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
            WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
            if (this.canRoute(document) && StringUtils.equals((String)workflowDocument.getInitiatorPrincipalId(), (String)GlobalVariables.getUserSession().getPrincipalId())) {
                return true;
            }
            if (workflowDocument.isApprovalRequested()) {
                return true;
            }
        }
        return false;
    }

    private boolean canCreateAward(String userId) {
        ApplicationTask task = new ApplicationTask("createAward");
        return this.getTaskAuthorizationService().isAuthorized(userId, (Task)task);
    }

    private boolean canExecuteAwardTask(String userId, AwardDocument doc, String taskName) {
        AwardTask task = new AwardTask(taskName, doc.getAward());
        return this.getTaskAuthorizationService().isAuthorized(userId, (Task)task);
    }

    protected boolean awardHasHierarchyChildren(Document document) {
        AwardDocument awardDocument = (AwardDocument)document;
        AwardHierarchy hierarchy = this.getAwardHierarchyService().loadAwardHierarchyBranch(awardDocument.getAward().getAwardNumber());
        return hierarchy != null && hierarchy.hasChildren();
    }

    public AwardHierarchyService getAwardHierarchyService() {
        if (this.awardHierarchyService == null) {
            this.awardHierarchyService = (AwardHierarchyService)KraServiceLocator.getService(AwardHierarchyService.class);
        }
        return this.awardHierarchyService;
    }

    public boolean canSendNoteFyi(Document document, Person user) {
        return false;
    }

    public boolean canFyi(Document document, Person user) {
        return false;
    }
}

