/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.document.authorizer;

import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.document.authorization.AwardTask;
import org.kuali.kra.award.document.authorizer.AwardAuthorizer;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.infrastructure.AwardPermissionConstants;
import org.kuali.rice.krad.document.Document;

public class ModifyAwardAuthorizer
extends AwardAuthorizer {
    public boolean isAuthorized(String userId, AwardTask task) {
        AwardDocument doc = task.getAward().getAwardDocument();
        Award award = task.getAward();
        return award.isNew() ? this.canUserCreateAward(userId, award) : this.canUserModifyAward(userId, award, doc);
    }

    protected boolean canUserCreateAward(String userId, Award award) {
        return this.hasUnitPermission(userId, "KC-AWARD", AwardPermissionConstants.CREATE_AWARD.getAwardPermission());
    }

    protected boolean canUserModifyAward(String userId, Award award, AwardDocument doc) {
        return !award.getAwardDocument().isViewOnly() && this.hasPermission(userId, award, AwardPermissionConstants.MODIFY_AWARD.getAwardPermission()) && !this.kraWorkflowService.isInWorkflow((Document)doc);
    }
}

