/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.home;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.kuali.kra.SequenceOwner;
import org.kuali.kra.award.customdata.AwardCustomData;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.award.notesandattachments.attachments.AwardAttachment;
import org.kuali.kra.bo.CustomAttributeDocument;
import org.kuali.kra.bo.versioning.VersionHistory;
import org.kuali.kra.bo.versioning.VersionStatus;
import org.kuali.kra.budget.summary.BudgetSummaryService;
import org.kuali.kra.service.ServiceHelper;
import org.kuali.kra.service.VersionException;
import org.kuali.kra.service.VersionHistoryService;
import org.kuali.kra.service.VersioningService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

public class AwardServiceImpl
implements AwardService {
    private static final String AWARD_NUMBER = "awardNumber";
    private static final String AWARD_ID = "awardId";
    private static final String SEQUENCE_NUMBER = "sequenceNumber";
    private BusinessObjectService businessObjectService;
    private VersioningService versioningService;
    private DocumentService documentService;
    private VersionHistoryService versionHistoryService;
    private BudgetSummaryService budgetSummaryService;
    private ParameterService parameterService;

    public List<Award> findAwardsForAwardNumber(String awardNumber) {
        ArrayList<Award> results = new ArrayList<Award>(this.businessObjectService.findMatchingOrderBy(Award.class, ServiceHelper.getInstance().buildCriteriaMap(AWARD_NUMBER, (Object)awardNumber), SEQUENCE_NUMBER, true));
        return results;
    }

    public Award getAward(Long awardId) {
        return awardId != null ? (Award)this.businessObjectService.findByPrimaryKey(Award.class, ServiceHelper.getInstance().buildCriteriaMap(AWARD_ID, (Object)awardId)) : null;
    }

    public Award getAward(String awardId) {
        return awardId != null ? (Award)this.businessObjectService.findByPrimaryKey(Award.class, ServiceHelper.getInstance().buildCriteriaMap(AWARD_ID, (Object)awardId)) : null;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public AwardDocument createNewAwardVersion(AwardDocument awardDocument) throws VersionException, WorkflowException {
        Award newVersion = (Award)this.getVersioningService().createNewVersion((SequenceOwner)awardDocument.getAward());
        for (AwardAttachment attach : newVersion.getAwardAttachments()) {
            AwardAttachment orignalAttachment = this.findMatchingAwardAttachment(awardDocument.getAward().getAwardAttachments(), attach.getFileId());
            attach.setUpdateUser(orignalAttachment.getUpdateUser());
            attach.setUpdateTimestamp(orignalAttachment.getUpdateTimestamp());
            attach.setUpdateUserSet(true);
        }
        this.incrementVersionNumberIfCanceledVersionsExist(newVersion);
        newVersion.getFundingProposals().clear();
        AwardDocument newAwardDocument = (AwardDocument)this.getDocumentService().getNewDocument(AwardDocument.class);
        newAwardDocument.getDocumentHeader().setDocumentDescription(awardDocument.getDocumentHeader().getDocumentDescription());
        newAwardDocument.setAward(newVersion);
        newVersion.setAwardDocument(newAwardDocument);
        newVersion.setAwardTransactionTypeCode(Integer.valueOf(0));
        newVersion.getSyncChanges().clear();
        newVersion.getSyncStatuses().clear();
        newVersion.setSyncChild(false);
        newVersion.setAwardAmountInfos(this.minimizeAwardAmountInfoCollection(newVersion.getAwardAmountInfos()));
        ((AwardAmountInfo)newVersion.getAwardAmountInfos().get(0)).setOriginatingAwardVersion(newVersion.getSequenceNumber());
        ((AwardAmountInfo)newVersion.getAwardAmountInfos().get(0)).setTimeAndMoneyDocumentNumber(null);
        ((AwardAmountInfo)newVersion.getAwardAmountInfos().get(0)).setSequenceNumber(newVersion.getSequenceNumber());
        this.synchNewCustomAttributes(newVersion, awardDocument.getAward());
        return newAwardDocument;
    }

    public void synchNewCustomAttributes(Award newAward, Award oldAward) {
        HashSet<Integer> availableCustomAttributes = new HashSet<Integer>();
        for (AwardCustomData awardCustomData : newAward.getAwardCustomDataList()) {
            availableCustomAttributes.add(awardCustomData.getCustomAttributeId().intValue());
        }
        if (oldAward.getAwardDocument() != null) {
            Map customAttributeDocuments = oldAward.getAwardDocument().getCustomAttributeDocuments();
            for (Map.Entry entry : customAttributeDocuments.entrySet()) {
                CustomAttributeDocument customAttributeDocument = (CustomAttributeDocument)entry.getValue();
                if (availableCustomAttributes.contains(customAttributeDocument.getCustomAttributeId())) continue;
                AwardCustomData awardCustomData = new AwardCustomData();
                awardCustomData.setCustomAttributeId(Long.valueOf(customAttributeDocument.getCustomAttributeId().intValue()));
                awardCustomData.setCustomAttribute(customAttributeDocument.getCustomAttribute());
                awardCustomData.setValue(customAttributeDocument.getCustomAttribute().getDefaultValue());
                awardCustomData.setAward(newAward);
                newAward.getAwardCustomDataList().add(awardCustomData);
            }
            newAward.getAwardCustomDataList().removeAll(this.getInactiveCustomDataList(newAward.getAwardCustomDataList(), customAttributeDocuments));
        }
    }

    private List<AwardCustomData> getInactiveCustomDataList(List<AwardCustomData> awardCustomDataList, Map<String, CustomAttributeDocument> customAttributeDocuments) {
        ArrayList<AwardCustomData> inactiveCustomDataList = new ArrayList<AwardCustomData>();
        for (AwardCustomData awardCustomData : awardCustomDataList) {
            CustomAttributeDocument customAttributeDocument = customAttributeDocuments.get(awardCustomData.getCustomAttributeId().toString());
            if (customAttributeDocument != null && customAttributeDocument.isActive()) continue;
            inactiveCustomDataList.add(awardCustomData);
        }
        return inactiveCustomDataList;
    }

    private AwardAttachment findMatchingAwardAttachment(List<AwardAttachment> originalAwardList, Long currentFileId) throws VersionException {
        for (AwardAttachment attach : originalAwardList) {
            if (!attach.getFileId().equals(currentFileId)) continue;
            return attach;
        }
        throw new VersionException("Unable to find matching attachment.");
    }

    protected void incrementVersionNumberIfCanceledVersionsExist(Award award) {
        List versionHistory = (List)this.businessObjectService.findMatching(VersionHistory.class, this.getHashMap(award.getAwardNumber()));
        award.setSequenceNumber(Integer.valueOf(versionHistory.size() + 1));
    }

    protected Map<String, String> getHashMap(String awardNumber) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sequenceOwnerVersionNameValue", awardNumber);
        return map;
    }

    protected List<AwardAmountInfo> minimizeAwardAmountInfoCollection(List<AwardAmountInfo> awardAmountInfos) {
        ArrayList<AwardAmountInfo> returnList = new ArrayList<AwardAmountInfo>();
        returnList.add(awardAmountInfos.get(awardAmountInfos.size() - 1));
        return returnList;
    }

    protected VersioningService getVersioningService() {
        return this.versioningService;
    }

    public void setVersioningService(VersioningService versioningService) {
        this.versioningService = versioningService;
    }

    protected DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    protected VersionHistoryService getVersionHistoryService() {
        return this.versionHistoryService;
    }

    public void setVersionHistoryService(VersionHistoryService versionHistoryService) {
        this.versionHistoryService = versionHistoryService;
    }

    protected BudgetSummaryService getBudgetSummaryService() {
        return this.budgetSummaryService;
    }

    public void setBudgetSummaryService(BudgetSummaryService budgetSummaryService) {
        this.budgetSummaryService = budgetSummaryService;
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void updateAwardSequenceStatus(Award award, VersionStatus status) {
        if (status.equals((Object)VersionStatus.ACTIVE)) {
            this.archiveCurrentActiveAward(award.getAwardNumber());
        }
        award.setAwardSequenceStatus(status.toString());
        if (award.getAwardDocument() != null) {
            this.businessObjectService.save((PersistableBusinessObject)award);
        }
    }

    protected void archiveCurrentActiveAward(String awardNumber) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put(AWARD_NUMBER, awardNumber);
        values.put("awardSequenceStatus", VersionStatus.ACTIVE.name());
        Collection awards = this.businessObjectService.findMatching(Award.class, values);
        for (Award award : awards) {
            award.setAwardSequenceStatus(VersionStatus.ARCHIVED.name());
            award.setAllowUpdateTimestampToBeReset(false);
            this.businessObjectService.save((PersistableBusinessObject)award);
        }
    }

    public Award getActiveOrNewestAward(String awardNumber) {
        List versions = this.getVersionHistoryService().loadVersionHistory(Award.class, awardNumber);
        VersionHistory newest = null;
        for (VersionHistory version : versions) {
            if (version.getStatus() == VersionStatus.ACTIVE) {
                newest = version;
                continue;
            }
            if (newest != null && (version.getStatus() == VersionStatus.CANCELED || version.getSequenceOwnerSequenceNumber() <= newest.getSequenceOwnerSequenceNumber())) continue;
            newest = version;
        }
        if (newest != null) {
            return (Award)newest.getSequenceOwner();
        }
        return null;
    }
}

