/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.home.fundingproposal;

import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardComment;
import org.kuali.kra.award.home.fundingproposal.FundingProposalMergeType;
import org.kuali.kra.award.home.fundingproposal.ProposalDataFeedCommandBase;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalComment;

public class CommentsDataFeedCommand
extends ProposalDataFeedCommandBase {
    private static final String FUNDING_PROPOSAL_ADDED_MSG_PATTERN = "Funding Proposal Number %s was added to Award";

    public CommentsDataFeedCommand(Award award, InstitutionalProposal proposal, FundingProposalMergeType mergeType) {
        super(award, proposal, mergeType);
    }

    void performDataFeed() {
        if (this.mergeType != FundingProposalMergeType.NOCHANGE) {
            this.feedProposalComment();
            this.feedProposalSummaryComment();
            this.feedFandARateComment();
            this.feedCostShareComment();
            this.feedProposalIPReviewComment();
        }
    }

    void feedProposalComment() {
        InstitutionalProposalComment proposalDeliveryComment = this.proposal.getDeliveryComment();
        AwardComment awardProposalComment = this.award.getawardProposalComments();
        if (proposalDeliveryComment != null) {
            this.appendComments(awardProposalComment, proposalDeliveryComment.getComments());
        } else {
            this.appendComments(awardProposalComment, String.format(FUNDING_PROPOSAL_ADDED_MSG_PATTERN, this.proposal.getProposalNumber()));
        }
    }

    void feedProposalSummaryComment() {
        InstitutionalProposalComment proposalSummaryComment = this.proposal.getSummaryComment();
        if (proposalSummaryComment != null) {
            AwardComment awardProposalSummaryComment = this.award.getawardProposalSummary();
            this.appendComments(awardProposalSummaryComment, proposalSummaryComment.getComments());
        }
    }

    void feedFandARateComment() {
        InstitutionalProposalComment proposalFandAComment = this.proposal.getUnrecoveredFandAComment();
        if (proposalFandAComment != null) {
            AwardComment awardFandAComment = this.award.getAwardFandaRateComment();
            this.appendComments(awardFandAComment, proposalFandAComment.getComments());
        }
    }

    void feedCostShareComment() {
        InstitutionalProposalComment proposalCostShareComment = this.proposal.getCostShareComment();
        if (proposalCostShareComment != null) {
            AwardComment awardCostShareComment = this.award.getAwardCostShareComment();
            this.appendComments(awardCostShareComment, proposalCostShareComment.getComments());
        }
    }

    void feedProposalIPReviewComment() {
        InstitutionalProposalComment proposalGeneralComment = this.proposal.getGeneralComment();
        if (proposalGeneralComment != null) {
            AwardComment awardIpReviewComment = this.award.getAwardProposalIPReviewComment();
            this.appendComments(awardIpReviewComment, proposalGeneralComment.getComments());
        }
    }
}

