/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.AwardUnitContact;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.document.authorization.AwardDocumentAuthorizer;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.dao.AwardLookupDao;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.lookup.KraLookupableHelperServiceImpl;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.lookup.CollectionIncomplete;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.UrlFactory;

class AwardLookupableHelperServiceImpl
extends KraLookupableHelperServiceImpl {
    private static final String COPY_HREF_PATTERN = "../DocCopyHandler.do?docId=%s&command=displayDocSearchView&documentTypeName=%s";
    static final String PERSON_ID = "personId";
    static final String ROLODEX_ID = "rolodexId";
    static final String UNIT_NUMBER = "unitNumber";
    static final String USER_ID = "userId";
    static final String PI_NAME = "principalInvestigatorName";
    static final String OSP_ADMIN_NAME = "ospAdministratorName";
    private static final Log LOG = LogFactory.getLog(AwardLookupableHelperServiceImpl.class);
    private static final long serialVersionUID = 6304433555064511153L;
    private transient KcPersonService kcPersonService;
    private AwardLookupDao awardLookupDao;

    AwardLookupableHelperServiceImpl() {
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        HashMap<String, String> formProps = new HashMap<String, String>();
        if (!StringUtils.isEmpty((String)fieldValues.get("lookupOspAdministratorName"))) {
            formProps.put("fullName", fieldValues.get("lookupOspAdministratorName"));
            formProps.put("unitAdministratorTypeCode", "2");
        }
        fieldValues.remove("lookupOspAdministratorName");
        if (!formProps.isEmpty()) {
            ArrayList<Long> ids = new ArrayList<Long>();
            Collection persons = this.getLookupService().findCollectionBySearch(AwardUnitContact.class, formProps);
            if (persons.isEmpty()) {
                return new ArrayList();
            }
            for (AwardUnitContact person : persons) {
                ids.add(person.getAwardContactId());
            }
            fieldValues.put("awardUnitContacts.awardContactId", StringUtils.join(ids, (char)'|'));
        }
        boolean usePrimaryKeys = this.getLookupService().allPrimaryKeyValuesPresentAndNotWildcard(Award.class, fieldValues);
        this.setBackLocation(fieldValues.get("backLocation"));
        this.setDocFormKey(fieldValues.get("docFormKey"));
        this.setReferencesToRefresh(fieldValues.get("referencesToRefresh"));
        List unboundedResults = this.getAwardLookupDao().getAwardSearchResults(fieldValues, usePrimaryKeys);
        CollectionIncomplete filteredResults = new ArrayList();
        filteredResults = this.filterForPermissions(unboundedResults);
        if (unboundedResults instanceof CollectionIncomplete) {
            filteredResults = new CollectionIncomplete(filteredResults, ((CollectionIncomplete)unboundedResults).getActualSizeIfTruncated());
        }
        return filteredResults;
    }

    public List<Award> filterForPermissions(List<Award> results) {
        Person user = GlobalVariables.getUserSession().getPerson();
        AwardDocumentAuthorizer authorizer = new AwardDocumentAuthorizer();
        ArrayList<Award> filteredResults = new ArrayList<Award>();
        for (Award award : results) {
            if (award == null || !authorizer.canOpen((Document)award.getAwardDocument(), user)) continue;
            filteredResults.add(award);
        }
        return filteredResults;
    }

    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        List htmlDataList = super.getCustomActionUrls(businessObject, pkNames);
        AwardDocument document = ((Award)businessObject).getAwardDocument();
        htmlDataList.add(this.getOpenLink((Award)businessObject, Boolean.valueOf(false)));
        htmlDataList.add(this.getCopyLink((Award)businessObject, Boolean.valueOf(false)));
        htmlDataList.add(this.getMedusaLink((Award)businessObject, Boolean.valueOf(false)));
        return htmlDataList;
    }

    public List<Row> getRows() {
        List rows = super.getRows();
        for (Row row : rows) {
            for (Field field : row.getFields()) {
                if (!field.getPropertyName().equals(PI_NAME)) continue;
                super.updateLookupField(field, PI_NAME, AwardPerson.class.getName());
            }
        }
        return rows;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public HtmlData getInquiryUrl(BusinessObject bo, String propertyName) {
        Award award = (Award)bo;
        HtmlData inquiryUrl = super.getInquiryUrl(bo, propertyName);
        if (propertyName.equals(UNIT_NUMBER)) {
            inquiryUrl = this.getUnitNumberInquiryUrl(award);
        } else if (propertyName.equals(PI_NAME)) {
            inquiryUrl = this.getPrincipalInvestigatorNameInquiryUrl(award);
        } else if (propertyName.equals(OSP_ADMIN_NAME)) {
            inquiryUrl = this.getOspAdminNameInquiryUrl(award);
        }
        return inquiryUrl;
    }

    protected HtmlData.AnchorHtmlData getOpenLink(Award award, Boolean viewOnly) {
        AwardDocument awardDocument = award.getAwardDocument();
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        htmlData.setDisplayText("open");
        Properties parameters = new Properties();
        parameters.put("methodToCall", "docHandler");
        parameters.put("command", "displayDocSearchView");
        parameters.put("docTypeName", this.getDocumentTypeName());
        parameters.put("viewDocument", viewOnly.toString());
        parameters.put("docOpenedFromAwardSearch", "true");
        parameters.put("docId", awardDocument.getDocumentNumber());
        parameters.put("placeHolderAwardId", award.getAwardId().toString());
        String href = UrlFactory.parameterizeUrl((String)("../" + this.getHtmlAction()), (Properties)parameters);
        htmlData.setHref(href);
        return htmlData;
    }

    protected HtmlData.AnchorHtmlData getMedusaLink(Award award, Boolean readOnly) {
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        htmlData.setDisplayText("medusa");
        Properties parameters = new Properties();
        parameters.put("methodToCall", "medusa");
        parameters.put("command", "displayDocSearchView");
        parameters.put("docTypeName", this.getDocumentTypeName());
        parameters.put("viewDocument", readOnly.toString());
        parameters.put("docId", award.getAwardDocument().getDocumentNumber());
        parameters.put("docOpenedFromAwardSearch", "true");
        parameters.put("placeHolderAwardId", award.getAwardId().toString());
        String href = UrlFactory.parameterizeUrl((String)("../" + this.getHtmlAction()), (Properties)parameters);
        htmlData.setHref(href);
        return htmlData;
    }

    protected HtmlData.AnchorHtmlData getCopyLink(Award award, Boolean readOnly) {
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        htmlData.setDisplayText("copy");
        Properties parameters = new Properties();
        parameters.put("methodToCall", "awardActions");
        parameters.put("command", "displayDocSearchView");
        parameters.put("docTypeName", this.getDocumentTypeName());
        parameters.put("viewDocument", readOnly.toString());
        parameters.put("docId", award.getAwardDocument().getDocumentNumber());
        parameters.put("docOpenedFromAwardSearch", "true");
        parameters.put("placeHolderAwardId", award.getAwardId().toString());
        String href = UrlFactory.parameterizeUrl((String)("../" + this.getHtmlAction()), (Properties)parameters);
        htmlData.setHref(href);
        return htmlData;
    }

    protected void addCopyLink(BusinessObject businessObject, List<String> pkNames, List<HtmlData> htmlDataList, String hrefPattern, String methodToCall) {
        HtmlData.AnchorHtmlData htmlData = this.getUrlData(businessObject, methodToCall, pkNames);
        AwardDocument document = ((Award)businessObject).getAwardDocument();
        htmlData.setHref(String.format(hrefPattern, document.getDocumentNumber(), this.getDocumentTypeName()));
        htmlDataList.add((HtmlData)htmlData);
    }

    protected HtmlData getOspAdminNameInquiryUrl(Award award) {
        KcPerson ospAdministrator = award.getOspAdministrator();
        if (ospAdministrator != null) {
            KcPerson inqBo = this.kcPersonService.getKcPersonByPersonId(ospAdministrator.getPersonId());
            return super.getInquiryUrl((BusinessObject)inqBo, PERSON_ID);
        }
        return null;
    }

    protected HtmlData getPrincipalInvestigatorNameInquiryUrl(Award award) {
        HtmlData inquiryUrl = null;
        AwardPerson principalInvestigator = award.getPrincipalInvestigator();
        if (principalInvestigator != null) {
            if (StringUtils.isNotBlank((String)principalInvestigator.getPersonId())) {
                KcPerson inqBo = this.kcPersonService.getKcPersonByPersonId(principalInvestigator.getPersonId());
                inquiryUrl = super.getInquiryUrl((BusinessObject)inqBo, PERSON_ID);
            } else if (principalInvestigator.getRolodexId() != null) {
                Rolodex inqBo = new Rolodex();
                inqBo.setRolodexId(principalInvestigator.getRolodexId());
                inquiryUrl = super.getInquiryUrl((BusinessObject)inqBo, ROLODEX_ID);
            }
        }
        return inquiryUrl;
    }

    protected HtmlData getUnitNumberInquiryUrl(Award award) {
        Unit inqBo = new Unit();
        Unit leadUnit = award.getLeadUnit();
        inqBo.setUnitNumber(leadUnit != null ? leadUnit.getUnitNumber() : null);
        return super.getInquiryUrl((BusinessObject)inqBo, UNIT_NUMBER);
    }

    protected String getHtmlAction() {
        return "awardHome.do";
    }

    protected void addEditHtmlData(List<HtmlData> htmlDataList, BusinessObject businessObject) {
    }

    protected String getDocumentTypeName() {
        return "AwardDocument";
    }

    protected String getKeyFieldName() {
        return "awardId";
    }

    protected List<Award> filterForActiveAwardsAndAwardWithActiveTimeAndMoney(Collection<Award> collectionByQuery) throws WorkflowException {
        BusinessObjectService businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        DocumentService documentService = (DocumentService)KraServiceLocator.getService(DocumentService.class);
        TreeSet<String> awardNumbers = new TreeSet<String>();
        for (Award award : collectionByQuery) {
            if (awardNumbers.contains(award.getAwardNumber())) continue;
            awardNumbers.add(award.getAwardNumber());
        }
        ArrayList<Award> activeAwards = new ArrayList<Award>();
        for (String versionName : awardNumbers) {
            TimeAndMoneyDocument t;
            TimeAndMoneyDocument timeAndMoneyDocument;
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            String[] splitAwardNumber = versionName.split("-");
            StringBuilder rootAwardNumberBuilder = new StringBuilder(12);
            rootAwardNumberBuilder.append(splitAwardNumber[0]);
            rootAwardNumberBuilder.append("-00001");
            String rootAwardNumber = rootAwardNumberBuilder.toString();
            fieldValues.put("rootAwardNumber", rootAwardNumber);
            List timeAndMoneyDocuments = (List)businessObjectService.findMatching(TimeAndMoneyDocument.class, fieldValues);
            Collections.sort(timeAndMoneyDocuments);
            if (timeAndMoneyDocuments.size() == 0 || !(timeAndMoneyDocument = (TimeAndMoneyDocument)documentService.getByDocumentHeaderId((t = (TimeAndMoneyDocument)timeAndMoneyDocuments.get(0)).getDocumentNumber())).getDocumentHeader().getWorkflowDocument().isFinal()) continue;
            activeAwards.add(timeAndMoneyDocument.getAward());
        }
        return activeAwards;
    }

    private boolean isAwardInAwardList(String awardNumber, List<Award> awardList) {
        boolean returnVal = false;
        for (Award award : awardList) {
            if (!award.getAwardNumber().equals(awardNumber)) continue;
            returnVal = true;
        }
        return returnVal;
    }

    public AwardLookupDao getAwardLookupDao() {
        return this.awardLookupDao;
    }

    public void setAwardLookupDao(AwardLookupDao awardLookupDao) {
        this.awardLookupDao = awardLookupDao;
    }
}

