/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.lookup.keyvalue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.krad.service.KeyValuesService;

public class AwardSequenceNumberValuesFinder
extends KeyValuesBase {
    public List<KeyValue> getKeyValues() {
        AwardDocument doc = this.getDocument();
        String awardNumber = doc.getAward().getAwardNumber();
        KeyValuesService keyValuesService = (KeyValuesService)KraServiceLocator.getService((String)"keyValuesService");
        HashMap<String, String> idMatch = new HashMap<String, String>();
        idMatch.put("awardNumber", awardNumber);
        Collection awards = keyValuesService.findMatching(Award.class, idMatch);
        ArrayList<Integer> sortedList = new ArrayList<Integer>();
        for (Award award : awards) {
            sortedList.add(award.getSequenceNumber());
        }
        Collections.sort(sortedList, Collections.reverseOrder());
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        for (Integer num : sortedList) {
            keyValues.add((KeyValue)new ConcreteKeyValue(num.toString(), num.toString()));
        }
        return keyValues;
    }

    private AwardDocument getDocument() {
        AwardDocument doc = null;
        AwardForm form = (AwardForm)KNSGlobalVariables.getKualiForm();
        if (form != null) {
            doc = form.getAwardDocument();
        }
        return doc;
    }
}

