/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.lookup.keyvalue;

import java.util.ArrayList;
import java.util.List;
import org.drools.core.util.StringUtils;
import org.kuali.kra.award.home.AwardTemplate;
import org.kuali.kra.award.home.AwardTemplateContact;
import org.kuali.kra.lookup.keyvalue.ExtendedPersistableBusinessObjectValuesFinder;
import org.kuali.kra.lookup.keyvalue.PrefixValuesFinder;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiMaintenanceForm;

public class AwardTemplateContactValuesFinder
extends ExtendedPersistableBusinessObjectValuesFinder {
    public List<KeyValue> getKeyValues() {
        MaintenanceDocument doc = this.getDocument();
        AwardTemplate awardTemplate = (AwardTemplate)doc.getNoteTarget();
        List contacts = awardTemplate.getTemplateContacts();
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        for (AwardTemplateContact contact : contacts) {
            contact.refreshReferenceObject("contactType");
            String key = contact.getRoleCode() + "***" + contact.getRolodexId().toString();
            StringBuffer sb = new StringBuffer(contact.getContactType().getDescription());
            if (contact.getRolodex() != null) {
                sb.append(" : ");
                if (!StringUtils.isEmpty((CharSequence)contact.getRolodex().getFullName())) {
                    sb.append(contact.getRolodex().getFullName());
                } else {
                    sb.append(contact.getRolodex().getOrganization());
                }
            }
            String label = sb.toString();
            keyValues.add((KeyValue)new ConcreteKeyValue(key, label));
        }
        keyValues.add(0, (KeyValue)new ConcreteKeyValue(PrefixValuesFinder.getPrefixKey(), PrefixValuesFinder.getDefaultPrefixValue()));
        return keyValues;
    }

    private MaintenanceDocument getDocument() {
        MaintenanceDocument doc = null;
        KualiMaintenanceForm form = (KualiMaintenanceForm)KNSGlobalVariables.getKualiForm();
        if (form != null) {
            doc = (MaintenanceDocument)form.getDocument();
        }
        return doc;
    }
}

