/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.lookup.keyvalue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.lookup.keyvalue.FrequencyCodeValuesFinder;
import org.kuali.kra.award.paymentreports.ValidClassReportFrequency;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.krad.service.KeyValuesService;
import org.kuali.rice.krad.util.GlobalVariables;

public class FrequencyCodeValuesFinder
extends KeyValuesBase {
    private String reportClassCode;
    private String reportCode;
    private KeyValuesService keyValuesService;

    public FrequencyCodeValuesFinder() {
    }

    public FrequencyCodeValuesFinder(String reportClassCode, String reportCode) {
        this.reportClassCode = reportClassCode;
        this.reportCode = reportCode;
    }

    public List<KeyValue> getKeyValues() {
        if (GlobalVariables.getUserSession().retrieveObject("awfreqr" + this.getReportClassCode() + "c" + this.getReportCode()) != null) {
            return (List)GlobalVariables.getUserSession().retrieveObject("awfreqr" + this.getReportClassCode() + "c" + this.getReportCode());
        }
        Collection validClassReportFrequencies = this.getKeyValuesService().findAll(ValidClassReportFrequency.class);
        return this.getKeyValues(this.getUniqueRelevantFrequencyCodes(validClassReportFrequencies));
    }

    public String getReportClassCode() {
        return this.reportClassCode;
    }

    public void setReportClassCode(String reportClassCode) {
        this.reportClassCode = reportClassCode;
    }

    public String getReportCode() {
        return this.reportCode;
    }

    public void setReportCode(String reportCode) {
        this.reportCode = reportCode;
    }

    protected KeyValuesService getKeyValuesService() {
        if (this.keyValuesService == null) {
            this.keyValuesService = (KeyValuesService)KraServiceLocator.getService((String)"keyValuesService");
        }
        return this.keyValuesService;
    }

    protected Set<String> getUniqueRelevantFrequencyCodes(Collection<ValidClassReportFrequency> validClassReportFrequencies) {
        HashSet<String> uniqueRelevantFrequencyCodes = new HashSet<String>();
        for (ValidClassReportFrequency validClassReportFrequency : validClassReportFrequencies) {
            if (!StringUtils.equalsIgnoreCase((String)validClassReportFrequency.getReportClassCode(), (String)this.getReportClassCode()) || !StringUtils.equalsIgnoreCase((String)validClassReportFrequency.getReportCode(), (String)this.getReportCode())) continue;
            uniqueRelevantFrequencyCodes.add(validClassReportFrequency.getFrequencyCode());
        }
        return uniqueRelevantFrequencyCodes;
    }

    protected List<KeyValue> getKeyValues(Set<String> uniqueValidClassReportFrequencies) {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        ValidClassReportFrequency validClassReportFrequency = new ValidClassReportFrequency();
        for (String frequencyCode : uniqueValidClassReportFrequencies) {
            if (frequencyCode == null) continue;
            validClassReportFrequency.setFrequencyCode(frequencyCode);
            validClassReportFrequency.refreshReferenceObject("frequency");
            keyValues.add((KeyValue)new ConcreteKeyValue(validClassReportFrequency.getFrequencyCode(), validClassReportFrequency.getFrequency().getDescription()));
        }
        Collections.sort(keyValues, new FrequenceComparator(this));
        keyValues.add(0, (KeyValue)new ConcreteKeyValue("", "select"));
        GlobalVariables.getUserSession().addObject("awfreqr" + this.getReportClassCode() + "c" + this.getReportCode(), keyValues);
        return keyValues;
    }
}

