/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.lookup.keyvalue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.lookup.keyvalue.ReportCodeValuesFinder;
import org.kuali.kra.award.paymentreports.Report;
import org.kuali.kra.award.paymentreports.ValidClassReportFrequency;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.keyvalues.KeyValuesBase;
import org.kuali.rice.krad.service.KeyValuesService;
import org.kuali.rice.krad.util.GlobalVariables;

public class ReportCodeValuesFinder
extends KeyValuesBase {
    KeyValuesService keyValuesService;
    private String reportClassCode;

    public ReportCodeValuesFinder() {
    }

    public ReportCodeValuesFinder(String reportClassCode) {
        this.reportClassCode = reportClassCode;
    }

    public List<KeyValue> getKeyValues() {
        if (GlobalVariables.getUserSession().retrieveObject("awreport" + this.getReportClassCode()) != null) {
            return (List)GlobalVariables.getUserSession().retrieveObject("awreport" + this.getReportClassCode());
        }
        Collection validClassReportFrequencies = this.getKeyValuesService().findAll(ValidClassReportFrequency.class);
        return this.getKeyValues(this.getUniqueRelevantReportClassCodes(validClassReportFrequencies));
    }

    public String getReportClassCode() {
        return this.reportClassCode;
    }

    public void setReportClassCode(String reportClassCode) {
        this.reportClassCode = reportClassCode;
    }

    protected KeyValuesService getKeyValuesService() {
        if (this.keyValuesService == null) {
            this.keyValuesService = (KeyValuesService)KraServiceLocator.getService((String)"keyValuesService");
        }
        return this.keyValuesService;
    }

    protected Set<String> getUniqueRelevantReportClassCodes(Collection<ValidClassReportFrequency> validClassReportFrequencies) {
        HashSet<String> uniqueRelevantReportClassCodes = new HashSet<String>();
        for (ValidClassReportFrequency validClassReportFrequency : validClassReportFrequencies) {
            if (!StringUtils.equalsIgnoreCase((String)validClassReportFrequency.getReportClassCode(), (String)this.getReportClassCode())) continue;
            uniqueRelevantReportClassCodes.add(validClassReportFrequency.getReportCode());
        }
        return uniqueRelevantReportClassCodes;
    }

    protected List<KeyValue> getKeyValues(Set<String> uniqueValidClassReportFrequencies) {
        ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
        ValidClassReportFrequency validClassReportFrequency = new ValidClassReportFrequency();
        for (String reportCode : uniqueValidClassReportFrequencies) {
            validClassReportFrequency.setReportCode(reportCode);
            validClassReportFrequency.refreshReferenceObject("report");
            String reportReportCode = validClassReportFrequency.getReportCode().toString();
            Report report = validClassReportFrequency.getReport();
            String reportDescription = report.getDescription() + (report.getFinalReportFlag() ? " (Final Report)" : "");
            keyValues.add((KeyValue)new ConcreteKeyValue(reportReportCode, reportDescription));
        }
        Collections.sort(keyValues, new ReportCodeComparator(this));
        keyValues.add(0, (KeyValue)new ConcreteKeyValue("", "select"));
        GlobalVariables.getUserSession().addObject("awreport" + this.getReportClassCode(), keyValues);
        return keyValues;
    }
}

