/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.maintenance;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.award.home.AwardTemplate;
import org.kuali.kra.award.home.AwardTemplateReportTerm;
import org.kuali.kra.award.home.AwardTemplateReportTermRecipient;
import org.kuali.kra.award.home.ValidBasisMethodPayment;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTermRuleImpl;
import org.kuali.kra.award.paymentreports.awardreports.GenericAwardReportTerm;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.bo.SponsorTerm;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.maintenance.KraMaintainableImpl;
import org.kuali.kra.rules.ErrorReporter;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;
import org.springframework.util.AutoPopulatingList;

public class AwardTemplateMaintainableImpl
extends KraMaintainableImpl {
    private static final long serialVersionUID = -3368480537790330757L;
    private static final String ERROR_KEY_PREFIX = "document.newMaintainableObject.add.templateReportTerms[";
    private static final Log LOG = LogFactory.getLog(AwardTemplateMaintainableImpl.class);
    private int columnNumber = 0;

    public void addMultipleValueLookupResults(MaintenanceDocument document, String collectionName, Collection<PersistableBusinessObject> rawValues, boolean needsBlank, PersistableBusinessObject bo) {
        if (StringUtils.equals((String)collectionName, (String)"templateTerms")) {
            for (PersistableBusinessObject nextBo : rawValues) {
                SponsorTerm aTerm = (SponsorTerm)nextBo;
                aTerm.refreshNonUpdateableReferences();
            }
        }
        super.addMultipleValueLookupResults(document, collectionName, rawValues, needsBlank, bo);
    }

    public void processBeforeAddLine(String colName, Class colClass, BusinessObject addBO) {
        if (colName.contains("[") && colName.contains("]")) {
            String numString = (String)colName.subSequence(colName.indexOf("[") + 1, colName.indexOf("]"));
            try {
                this.columnNumber = Integer.parseInt(numString);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        super.processBeforeAddLine(colName, colClass, addBO);
    }

    public void addNewLineToCollection(String collectionName) {
        if (collectionName.equals("templateReportTerms")) {
            AwardTemplateReportTerm awardTemplateReportTerm = (AwardTemplateReportTerm)this.newCollectionLines.get(collectionName);
            if (awardTemplateReportTerm != null && this.isValid(awardTemplateReportTerm)) {
                super.addNewLineToCollection(collectionName);
            }
        } else if (collectionName.endsWith("awardTemplateReportTermRecipients")) {
            this.addNewRecipientToCollection(collectionName);
        } else {
            super.addNewLineToCollection(collectionName);
        }
    }

    public void addNewRecipientToCollection(String collectionName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("addNewRecipientToCollection( " + collectionName + " )"));
        }
        AwardTemplateReportTermRecipient addLine = (AwardTemplateReportTermRecipient)this.newCollectionLines.get(collectionName);
        ErrorReporter errorReporter = new ErrorReporter();
        if (addLine != null) {
            addLine.setNewCollectionRecord(true);
            addLine.setRolodexNameOrganization("");
            String contactTypeCodeAndRolodexIdString = addLine.getContactTypeCodeAndRolodexId();
            if (StringUtils.isNotEmpty((String)contactTypeCodeAndRolodexIdString) && addLine.getRolodexId() != null) {
                addLine.setRolodexNameOrganization("");
                String errorKey = ERROR_KEY_PREFIX + this.columnNumber + "].awardTemplateReportTermRecipients.rolodexId";
                errorReporter.reportError(errorKey, "error.award.awardTemplateRecipient.canNotSelectBothFields", new String[]{contactTypeCodeAndRolodexIdString, addLine.getRolodexId().toString()});
                return;
            }
            if (StringUtils.isNotEmpty((String)contactTypeCodeAndRolodexIdString)) {
                int index1 = contactTypeCodeAndRolodexIdString.indexOf("***");
                if (index1 > 0) {
                    String contactTypeCode = contactTypeCodeAndRolodexIdString.substring(0, index1);
                    Integer rolodexId = Integer.parseInt(contactTypeCodeAndRolodexIdString.substring(index1 + "***".length(), contactTypeCodeAndRolodexIdString.length()));
                    addLine.setContactTypeCode(contactTypeCode);
                    addLine.setRolodexId(rolodexId);
                    addLine.setRolodexNameOrganization(this.rolodexNameAndOrganization(rolodexId));
                }
            } else if (addLine.getRolodexId() != null) {
                addLine.setContactTypeCode("-1");
                addLine.setRolodexId(addLine.getRolodexId());
                addLine.setRolodexNameOrganization(this.rolodexNameAndOrganization(addLine.getRolodexId()));
            } else {
                addLine.setRolodexNameOrganization("");
                String errorKey = ERROR_KEY_PREFIX + this.columnNumber + "].awardTemplateReportTermRecipients.contactTypeCodeAndRolodexId";
                errorReporter.reportError(errorKey, "error.award.awardTemplateRecipient.oneFieldMustBeSelected", new String[0]);
                return;
            }
            Collection maintCollection = (Collection)ObjectUtils.getPropertyValue((Object)this.getBusinessObject(), (String)collectionName);
            if (maintCollection.size() > 0) {
                AutoPopulatingList aList = new AutoPopulatingList(AwardTemplateReportTermRecipient.class);
                aList.addAll(maintCollection);
                Integer id = addLine.getRolodexId();
                for (int i = 0; i < aList.size(); ++i) {
                    AwardTemplateReportTermRecipient aRecipient = (AwardTemplateReportTermRecipient)aList.get(i);
                    if (!aRecipient.getRolodexId().equals(id)) continue;
                    String errorKey = ERROR_KEY_PREFIX + this.columnNumber + "].awardTemplateReportTermRecipients.rolodexId";
                    errorReporter.reportError(errorKey, "error.award.awardTemplateRecipient.duplicateRolodexId", new String[0]);
                    return;
                }
            }
            maintCollection.add(addLine);
            String referencesToRefresh = LookupUtils.convertReferencesToSelectCollectionToString((Collection)this.getAllRefreshableReferences(this.getBusinessObject().getClass()));
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("References to refresh for adding line to collection " + collectionName + ": " + referencesToRefresh));
            }
            this.refreshReferences(referencesToRefresh);
        }
        this.initNewCollectionLine(collectionName);
    }

    public String rolodexNameAndOrganization(Integer rolodexId) {
        BusinessObjectService businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        Rolodex aRolodex = (Rolodex)businessObjectService.findBySinglePrimaryKey(Rolodex.class, (Object)rolodexId);
        String rolocesNameAndOrganization = "";
        if (aRolodex != null) {
            rolocesNameAndOrganization = aRolodex.getFullName() + "/" + aRolodex.getOrganization();
        }
        return rolocesNameAndOrganization;
    }

    public void prepareForSave() {
        AwardTemplate awardTemplate = (AwardTemplate)this.businessObject;
        if (!this.isValid(awardTemplate.getBasisOfPaymentCode(), awardTemplate.getMethodOfPaymentCode())) {
            this.reportInvalidAwardBasisError(awardTemplate);
        }
        super.prepareForSave();
    }

    private void reportInvalidAwardBasisError(AwardTemplate awardTemplate) {
        ErrorReporter errorReporter = new ErrorReporter();
        awardTemplate.refreshNonUpdateableReferences();
        errorReporter.reportError("document.newMaintainableObject.basisOfPaymentCode", "error.invalid.award.awardTemplate.awardBasisPayment", new String[]{awardTemplate.getAwardBasisOfPayment() == null ? "" : awardTemplate.getAwardBasisOfPayment().getDescription()});
        errorReporter.reportError("document.newMaintainableObject.methodOfPaymentCode", "error.invalid.award.awardTemplate.awardMethodPayment", new String[]{awardTemplate.getAwardMethodOfPayment() == null ? "" : awardTemplate.getAwardMethodOfPayment().getDescription()});
    }

    private boolean isValid(String basisOfPaymentCode, String methodOfPaymentCode) {
        BusinessObjectService businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        HashMap<String, String> validBasisOfPaymentsParams = new HashMap<String, String>();
        validBasisOfPaymentsParams.put("basisOfPaymentCode", basisOfPaymentCode);
        validBasisOfPaymentsParams.put("methodOfPaymentCode", methodOfPaymentCode);
        Collection validBasisMethodPayments = businessObjectService.findMatching(ValidBasisMethodPayment.class, validBasisOfPaymentsParams);
        return !validBasisMethodPayments.isEmpty();
    }

    public void refresh(String refreshCaller, Map fieldValues, MaintenanceDocument document) {
        super.refresh(refreshCaller, fieldValues, document);
    }

    protected boolean isValid(AwardTemplateReportTerm reportTerm) {
        GlobalVariables.getMessageMap().addToErrorPath("document.newMaintainableObject.add.templateReportTerms");
        boolean result = new AwardReportTermRuleImpl().processAwardReportTermBusinessRules((GenericAwardReportTerm)reportTerm, ((AwardTemplate)this.getBusinessObject()).getAwardReportTermItems());
        GlobalVariables.getMessageMap().removeFromErrorPath("document.newMaintainableObject.add.templateReportTerms");
        return result;
    }

    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> parameters) {
        AwardTemplate template = (AwardTemplate)document.getNoteTarget();
        template.processAfterCopy();
    }
}

