/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.notesandattachments.comments;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.home.AwardComment;
import org.kuali.kra.bo.CommentType;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.AwardCommentService;

public class AwardCommentBean
implements Serializable {
    private static final long serialVersionUID = -8505814106872342691L;
    private List<CommentType> awardCommentScreenDisplayTypes;
    private AwardForm form;

    public AwardCommentBean() {
    }

    public AwardCommentBean(AwardForm form) {
        this.form = form;
    }

    public List<CommentType> getAwardCommentScreenDisplayTypes() {
        return this.awardCommentScreenDisplayTypes;
    }

    public void setAwardCommentScreenDisplayTypes(List<CommentType> awardCommentScreenDisplayTypes) {
        this.awardCommentScreenDisplayTypes = awardCommentScreenDisplayTypes;
    }

    public AwardForm getForm() {
        return this.form;
    }

    public void setForm(AwardForm form) {
        this.form = form;
    }

    public void setAwardCommentScreenDisplayTypesOnForm() {
        AwardCommentService awardCommentService = this.getAwardCommentService();
        this.setAwardCommentScreenDisplayTypes(awardCommentService.retrieveCommentTypes());
        for (CommentType commentType : this.getAwardCommentScreenDisplayTypes()) {
            this.setupAwardComment(this.form, commentType);
        }
    }

    private void setupAwardComment(AwardForm form, CommentType commentType) {
        for (AwardComment awardComment : form.getAwardDocument().getAward().getAwardComments()) {
            if (!StringUtils.equals((String)awardComment.getCommentTypeCode(), (String)commentType.getCommentTypeCode())) continue;
            return;
        }
        AwardComment awardComment = new AwardComment();
        awardComment.setCommentTypeCode(commentType.getCommentTypeCode());
        awardComment.setCommentType(commentType);
        awardComment.setAwardNumber(form.getAwardDocument().getAward().getAwardNumber());
        form.getAwardDocument().getAward().getAwardComments().add(awardComment);
    }

    public void setAwardCommentHistoryFlags() {
        ArrayList<Boolean> results = new ArrayList<Boolean>();
        List comments = this.form.getAwardDocument().getAward().getAwardComments();
        AwardCommentService awardCommentService = this.getAwardCommentService();
        List allAwardCommentTypes = awardCommentService.retrieveCommentHistoryFlags(this.form.getAwardDocument().getAward().getAwardNumber());
        for (AwardComment comment : comments) {
            results.add(new Boolean(allAwardCommentTypes.contains(comment.getCommentTypeCode())));
        }
        this.form.getAwardDocument().getAward().setAwardCommentHistoryFlags(results);
    }

    protected AwardCommentService getAwardCommentService() {
        return (AwardCommentService)KraServiceLocator.getService(AwardCommentService.class);
    }
}

