/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.awardreports;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.contacts.AwardSponsorContact;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.paymentreports.awardreports.AddAwardReportTermRecipientRuleEvent;
import org.kuali.kra.award.paymentreports.awardreports.AddAwardReportTermRuleEvent;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTerm;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTermRecipient;
import org.kuali.kra.award.paymentreports.awardreports.MultipleSponsorContactsException;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.service.KeyValuesService;
import org.kuali.rice.krad.service.KualiRuleService;

public class AwardReportsBean
implements Serializable {
    private static final long serialVersionUID = -7425300585057908055L;
    private List<AwardReportTerm> newAwardReportTerms;
    private List<AwardReportTermRecipient> newAwardReportTermRecipients;
    private transient KualiRuleService ruleService;
    private AwardForm form;
    private transient ParameterService parameterService;

    public AwardReportsBean(AwardForm form) {
        this.form = form;
    }

    public AwardReportsBean() {
    }

    public AwardReportTerm addAwardReportTermItem(String reportClassCode, int index) {
        AwardReportTerm newAwardReportTerm = (AwardReportTerm)this.getNewAwardReportTerms().get(index);
        newAwardReportTerm.setReportClassCode(reportClassCode);
        AddAwardReportTermRuleEvent event = this.generateAddAwardReportTermEvent(newAwardReportTerm, reportClassCode, index);
        boolean success = this.getRuleService().applyRules((KualiDocumentEvent)event);
        if (success) {
            this.getAward().add(newAwardReportTerm);
            this.init(index);
            return newAwardReportTerm;
        }
        return null;
    }

    public AwardReportTermRecipient addAwardReportTermRecipientItem(int index) {
        AwardReportTermRecipient newAwardReportTermRecipient = (AwardReportTermRecipient)this.getNewAwardReportTermRecipients().get(index);
        AddAwardReportTermRecipientRuleEvent event = this.generateAddAwardReportTermRecipientEvent(index);
        boolean success = this.getRuleService().applyRules((KualiDocumentEvent)event);
        if (success) {
            if (newAwardReportTermRecipient.getContactId() != null) {
                this.populateContactTypeAndRolodex(newAwardReportTermRecipient);
            } else if (newAwardReportTermRecipient.getRolodexId() != null) {
                newAwardReportTermRecipient.setContactTypeCode(this.getParameterService().getParameterValueAsString(AwardDocument.class, "contactTypeOther"));
            }
            ((AwardReportTerm)this.getAward().getAwardReportTermItems().get(index)).getAwardReportTermRecipients().add(newAwardReportTermRecipient);
            this.initRecipient(index);
            return newAwardReportTermRecipient;
        }
        return null;
    }

    public AwardReportTerm deleteAwardReportTermItem(int deletedItemIndex) {
        AwardReportTerm termToDelete = null;
        List items = this.getAward().getAwardReportTermItems();
        if (deletedItemIndex >= 0 && deletedItemIndex < items.size()) {
            termToDelete = (AwardReportTerm)items.get(deletedItemIndex);
            items.remove(deletedItemIndex);
        }
        return termToDelete;
    }

    public AwardReportTermRecipient deleteAwardReportTermRecipientItem(int awardReportTermIndex, int deletedItemIndex) {
        AwardReportTermRecipient recipient = null;
        List items = ((AwardReportTerm)this.getAward().getAwardReportTermItems().get(awardReportTermIndex)).getAwardReportTermRecipients();
        if (deletedItemIndex >= 0 && deletedItemIndex < items.size()) {
            recipient = (AwardReportTermRecipient)items.get(deletedItemIndex);
            items.remove(deletedItemIndex);
        }
        return recipient;
    }

    public Award getAward() {
        return this.form.getAwardDocument().getAward();
    }

    public AwardDocument getAwardDocument() {
        return this.form.getAwardDocument();
    }

    public void init(int index) {
        int i;
        if (index > this.getNewAwardReportTerms().size() - 1) {
            for (i = this.getNewAwardReportTerms().size(); i <= index; ++i) {
                this.getNewAwardReportTerms().add(new AwardReportTerm());
            }
        }
        if (index > this.getNewAwardReportTermRecipients().size() - 1) {
            for (i = this.getNewAwardReportTermRecipients().size(); i <= index; ++i) {
                this.getNewAwardReportTermRecipients().add(new AwardReportTermRecipient());
            }
        }
        this.getNewAwardReportTerms().set(index, new AwardReportTerm());
        this.getNewAwardReportTermRecipients().set(index, new AwardReportTermRecipient());
    }

    public AwardReportTermRecipient getNewAwardReportTermRecipient(int index) {
        if (this.getNewAwardReportTermRecipients().size() <= index) {
            this.init(index);
        }
        return (AwardReportTermRecipient)this.getNewAwardReportTermRecipients().get(index);
    }

    public void initRecipient(int index) {
        if (index > this.getNewAwardReportTermRecipients().size() - 1) {
            for (int i = this.getNewAwardReportTermRecipients().size(); i <= index; ++i) {
                this.getNewAwardReportTermRecipients().add(null);
            }
        }
        this.getNewAwardReportTermRecipients().set(index, new AwardReportTermRecipient());
    }

    protected KualiRuleService getRuleService() {
        if (this.ruleService == null) {
            this.ruleService = (KualiRuleService)KraServiceLocator.getService(KualiRuleService.class);
        }
        return this.ruleService;
    }

    protected void setRuleService(KualiRuleService ruleService) {
        this.ruleService = ruleService;
    }

    AddAwardReportTermRuleEvent generateAddAwardReportTermEvent(AwardReportTerm newAwardReportTerm, String reportClassCode, int index) {
        AddAwardReportTermRuleEvent event = new AddAwardReportTermRuleEvent("awardReportsBean.newAwardReportTerms[" + index + "]", this.getAwardDocument(), this.getAward(), newAwardReportTerm);
        return event;
    }

    AddAwardReportTermRecipientRuleEvent generateAddAwardReportTermRecipientEvent(int index) {
        AddAwardReportTermRecipientRuleEvent event = new AddAwardReportTermRecipientRuleEvent("awardReportsBean.newAwardReportTermRecipient[" + index + "]", this.getAwardDocument(), this.getAward(), (AwardReportTerm)this.getAward().getAwardReportTermItems().get(index), (AwardReportTermRecipient)this.getNewAwardReportTermRecipients().get(index));
        return event;
    }

    public List<AwardReportTerm> getNewAwardReportTerms() {
        return this.newAwardReportTerms;
    }

    public void setNewAwardReportTerms(List<AwardReportTerm> newAwardReportTerms) {
        this.newAwardReportTerms = newAwardReportTerms;
    }

    public List<AwardReportTermRecipient> getNewAwardReportTermRecipients() {
        return this.newAwardReportTermRecipients;
    }

    public void setNewAwardReportTermRecipients(List<AwardReportTermRecipient> newAwardReportTermRecipients) {
        this.newAwardReportTermRecipients = newAwardReportTermRecipients;
    }

    void populateContactTypeAndRolodex(AwardReportTermRecipient newAwardReportTermRecipient) {
        Collection awardSponsorContacts = this.getSponsorContactsUsingKeyValuesService(newAwardReportTermRecipient.getContactId());
        if (awardSponsorContacts.size() > 1) {
            throw new MultipleSponsorContactsException(awardSponsorContacts.size());
        }
        for (AwardSponsorContact awardSponsorContact : awardSponsorContacts) {
            newAwardReportTermRecipient.setRolodexId(awardSponsorContact.getRolodexId());
            newAwardReportTermRecipient.refreshReferenceObject("rolodex");
            newAwardReportTermRecipient.setContactTypeCode(awardSponsorContact.getContactRoleCode());
            newAwardReportTermRecipient.refreshReferenceObject("contactType");
        }
    }

    Collection<AwardSponsorContact> getSponsorContactsUsingKeyValuesService(Long contactId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("awardContactId", contactId);
        return this.getKeyValuesService().findMatching(AwardSponsorContact.class, map);
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = (ParameterService)KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    protected KeyValuesService getKeyValuesService() {
        return (KeyValuesService)KraServiceLocator.getService(KeyValuesService.class);
    }
}

