/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.awardreports.reporting.service;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingNotificationDetails;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingNotificationService;
import org.kuali.kra.common.notification.service.KcNotificationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.util.GlobalVariables;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.transaction.annotation.Transactional;

public class ReportTrackingNotificationJobDetail
extends QuartzJobBean {
    private static final String BREAK = "<BR>";
    private static final String CONTEXT_NAME = "Report Tracking Notification Job";
    private static final String SUBJECT = "Report Tracking Notification batch job result";
    private static final Log LOG = LogFactory.getLog(ReportTrackingNotificationJobDetail.class);
    private String user;
    private ReportTrackingNotificationService reportTrackingNotificationService;
    private ParameterService parameterService;
    private KcNotificationService kcNotificationService;

    @Transactional
    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        if (this.batchProcessEnabled()) {
            StringBuilder builder = new StringBuilder();
            UserSession userSession = new UserSession(this.user);
            GlobalVariables.setUserSession((UserSession)userSession);
            try {
                List results = this.reportTrackingNotificationService.runReportTrackingNotifications();
                this.buildMessage(builder, results);
            }
            catch (Exception e) {
                LOG.error((Object)"Error running report tracking notification service.", (Throwable)e);
                builder.append("Message: Error running report tracking notification service. See log for more details. " + e.getMessage());
            }
            String message = builder.toString();
            LOG.info((Object)message);
            String recipient = this.getRecipient();
            if (StringUtils.isNotEmpty((String)recipient)) {
                this.kcNotificationService.sendNotification(CONTEXT_NAME, SUBJECT, message, Collections.singletonList(recipient));
            }
        }
    }

    protected void buildMessage(StringBuilder builder, List<ReportTrackingNotificationDetails> details) {
        builder.append("Report Tracking Notifications : " + details.size() + BREAK);
        int i = 1;
        for (ReportTrackingNotificationDetails detail : details) {
            builder.append("Report Tracking Notification " + i++ + BREAK);
            builder.append("Notification Name : " + detail.getNotificationName() + BREAK);
            builder.append("Action Code : " + detail.getActionCode() + BREAK);
            if (StringUtils.isNotBlank((String)detail.getErrorMessage())) {
                builder.append("Error Occurred : " + detail.getErrorMessage());
            }
            if (!detail.isNotificationActive()) {
                builder.append("Was not found, was inactive or had no recipients defined.<BR>");
            } else {
                builder.append("Notification Type Recipients : " + detail.getNotificationRecipients() + BREAK);
                builder.append("Report Tracking Records found using task parameters : " + detail.getTrackingRecordsFound() + BREAK);
                builder.append("Report Tracking Records whose due date matched : " + detail.getTrackingRecordsMatched() + BREAK);
                builder.append("Report Tracking Notifications sent : " + detail.getNotificationsSent() + BREAK);
            }
            builder.append(BREAK);
        }
    }

    protected String getRecipient() {
        return this.parameterService.getParameterValueAsString(AwardDocument.class, "REPORT_TRACKING_NOTIFICATIONS_BATCH_RECIPIENT");
    }

    protected boolean batchProcessEnabled() {
        return this.parameterService.getParameterValueAsBoolean(AwardDocument.class, "REPORT_TRACKING_NOTIFICATIONS_BATCH_ENABLED");
    }

    public void setUser(String user) {
        this.user = user;
    }

    protected String getUser() {
        return this.user;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setKcNotificationService(KcNotificationService kcNotificationService) {
        this.kcNotificationService = kcNotificationService;
    }

    protected ReportTrackingNotificationService getReportTrackingNotificationService() {
        return this.reportTrackingNotificationService;
    }

    public void setReportTrackingNotificationService(ReportTrackingNotificationService reportTrackingNotificationService) {
        this.reportTrackingNotificationService = reportTrackingNotificationService;
    }

    protected ParameterService getParameterService() {
        return this.parameterService;
    }

    protected KcNotificationService getKcNotificationService() {
        return this.kcNotificationService;
    }
}

