/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.awardreports.reporting.service;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import org.kuali.kra.award.paymentreports.awardreports.reporting.ReportTracking;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.AwardReportTracking;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingPrint;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingPrintingService;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingPrintingServiceImpl;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingType;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.printing.Printable;
import org.kuali.kra.printing.PrintingException;
import org.kuali.kra.printing.service.PrintingService;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ReportTrackingPrintingServiceImpl
implements ReportTrackingPrintingService {
    private PrintingService printingService;
    private BusinessObjectService businessObjectService;
    private ReportTrackingPrint reportTrackingPrint;

    public AttachmentDataSource printReportTracking(KraPersistableBusinessObjectBase printableBusinessObject, String reportName, Map<String, Object> reportParameters) throws PrintingException {
        AttachmentDataSource source = null;
        ReportTrackingPrint printable = null;
        printable = this.getReportTrackingPrint();
        printable.setPrintableBusinessObject(printableBusinessObject);
        printable.setReportParameters(reportParameters);
        source = this.getPrintingService().print((Printable)printable);
        return source;
    }

    public AttachmentDataSource printAwardReportTracking(List<Printable> printableArtifactList) throws PrintingException {
        AttachmentDataSource attachmentDataSource = this.getPrintingService().print(printableArtifactList);
        String fileName = "ReportTrackingPrint.pdf";
        try {
            attachmentDataSource.setFileName(URLEncoder.encode(fileName, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            attachmentDataSource.setFileName(fileName);
        }
        attachmentDataSource.setContentType("application/pdf");
        return attachmentDataSource;
    }

    protected String getReportName(String reportFileNamePrefix, String reportName) {
        StringBuilder reportFullName = new StringBuilder(reportFileNamePrefix).append("_").append(reportName.replace(' ', '_')).append(".pdf");
        return reportFullName.toString();
    }

    public AwardReportTracking getReportPrintable(ReportTrackingType reportType, ReportTracking detailResult, AwardReportTracking printable) {
        switch (1.$SwitchMap$org$kuali$kra$award$paymentreports$awardreports$reporting$service$ReportTrackingType[reportType.ordinal()]) {
            case 1: {
                printable = this.getReportTrackingPrint();
                printable.setPrintableBusinessObject((KraPersistableBusinessObjectBase)detailResult);
            }
        }
        return printable;
    }

    public PrintingService getPrintingService() {
        return this.printingService;
    }

    public void setPrintingService(PrintingService printingService) {
        this.printingService = printingService;
    }

    public ReportTrackingPrint getReportTrackingPrint() {
        return this.reportTrackingPrint;
    }

    public void setReportTrackingPrint(ReportTrackingPrint reportTrackingPrint) {
        this.reportTrackingPrint = reportTrackingPrint;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

