/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.awardreports.reporting.service;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.award.paymentreports.ReportRegenerationType;
import org.kuali.kra.award.paymentreports.ReportStatus;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTerm;
import org.kuali.kra.award.paymentreports.awardreports.reporting.ReportTracking;
import org.kuali.kra.award.paymentreports.awardreports.reporting.ReportTrackingBean;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingService;
import org.kuali.kra.service.AwardScheduleGenerationService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public class ReportTrackingServiceImpl
implements ReportTrackingService {
    private static final String PENDING_STATUS_DESCRIPTION = "Pending";
    private AwardScheduleGenerationService awardScheduleGenerationService;
    private BusinessObjectService businessObjectService;
    private AwardService awardService;

    public void refreshReportTracking(Award award) throws ParseException {
        List awardReportTermItems = award.getAwardReportTermItems();
        for (AwardReportTerm awardTerm : awardReportTermItems) {
            List dates = new ArrayList();
            ArrayList<AwardReportTerm> awardReportTerms = new ArrayList<AwardReportTerm>();
            awardReportTerms.add(awardTerm);
            dates = this.getAwardScheduleGenerationService().generateSchedules(award, awardReportTerms, true);
            if (awardTerm.getReportTrackings() == null) {
                awardTerm.setReportTrackings(this.getReportTacking(awardTerm));
            } else {
                awardTerm.setReportTrackings(this.purgePendingReports(awardTerm, awardTerm.getReportTrackings(), new ArrayList()));
            }
            if (this.autoRegenerateReports(award) && award.getPrincipalInvestigator() != null) {
                this.runDateCalcuations(dates, award, awardTerm, new ArrayList());
            }
            Collections.sort(awardTerm.getReportTrackings());
        }
    }

    public void generateReportTrackingAndSave(Award award, boolean forceReportRegeneration) throws ParseException {
        if ((forceReportRegeneration || this.autoRegenerateReports(award)) && award.getPrincipalInvestigator() != null) {
            List awardReportTermItems = award.getAwardReportTermItems();
            ArrayList reportsToSave = new ArrayList();
            ArrayList reportsToDelete = new ArrayList();
            for (AwardReportTerm awardTerm : awardReportTermItems) {
                List dates = new ArrayList();
                awardTerm.refreshReferenceObject("reportClass");
                if (!awardTerm.getReportClass().getGenerateReportRequirements()) continue;
                ArrayList<AwardReportTerm> awardReportTerms = new ArrayList<AwardReportTerm>();
                awardReportTerms.add(awardTerm);
                dates = this.getAwardScheduleGenerationService().generateSchedules(award, awardReportTerms, true);
                if (awardTerm.getReportTrackings() == null) {
                    awardTerm.setReportTrackings(this.getReportTacking(awardTerm));
                } else {
                    awardTerm.setReportTrackings(this.purgePendingReports(awardTerm, awardTerm.getReportTrackings(), reportsToDelete));
                    reportsToSave.addAll(awardTerm.getReportTrackings());
                }
                this.runDateCalcuations(dates, award, awardTerm, reportsToSave);
                Collections.sort(awardTerm.getReportTrackings());
            }
            this.getBusinessObjectService().delete(reportsToDelete);
            for (ReportTracking rt : reportsToSave) {
                if (rt.getObjectId() == null || StringUtils.equals((String)rt.getStatusCode(), (String)this.getPendingReportStatus().getReportStatusCode())) continue;
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("OBJ_ID", rt.getObjectId());
                ReportTracking dbRt = (ReportTracking)this.getBusinessObjectService().findByPrimaryKey(ReportTracking.class, params);
                if (!rt.hasBeenUpdated(dbRt)) continue;
                rt.setLastUpdateDate(new Timestamp(new java.util.Date().getTime()));
                rt.setLastUpdateUser(GlobalVariables.getUserSession().getPerson().getName());
            }
            this.getBusinessObjectService().save(reportsToSave);
        }
    }

    protected void runDateCalcuations(List<java.util.Date> dates, Award award, AwardReportTerm awardTerm, List<ReportTracking> reportsToSave) {
        if (dates.size() == 0 && awardTerm.getReportTrackings().size() == 0) {
            ReportTracking rt = this.buildReportTracking(award, awardTerm);
            awardTerm.getReportTrackings().add(rt);
        }
        for (java.util.Date date : dates) {
            if (this.isAwardTermDateAlreadySet(awardTerm.getReportTrackings(), date)) continue;
            ReportTracking rt = this.buildReportTracking(award, awardTerm);
            Date sqldate = new Date(date.getTime());
            rt.setDueDate(sqldate);
            awardTerm.getReportTrackings().add(rt);
            reportsToSave.add(rt);
        }
    }

    protected ReportTracking buildReportTracking(Award award, AwardReportTerm awardTerm) {
        awardTerm.refresh();
        ReportTracking reportTracking = new ReportTracking();
        reportTracking.setAwardNumber(award.getAwardNumber());
        reportTracking.setAwardReportTermId(awardTerm.getAwardReportTermId());
        reportTracking.setDueDate(awardTerm.getDueDate());
        reportTracking.setFrequency(awardTerm.getFrequency());
        reportTracking.setFrequencyBase(awardTerm.getFrequencyBase());
        reportTracking.setFrequencyBaseCode(awardTerm.getFrequencyBaseCode());
        reportTracking.setFrequencyCode(awardTerm.getFrequencyCode());
        reportTracking.setLastUpdateDate(new Timestamp(new java.util.Date().getTime()));
        reportTracking.setLastUpdateUser(GlobalVariables.getUserSession().getPerson().getName());
        reportTracking.setLeadUnit(award.getLeadUnit());
        reportTracking.setLeadUnitNumber(award.getLeadUnitNumber());
        reportTracking.setOverdue(Integer.valueOf(0));
        reportTracking.setPiName(award.getPrincipalInvestigatorName());
        if (award.getPrincipalInvestigator() != null) {
            reportTracking.setPiPersonId(award.getPrincipalInvestigator().getPersonId());
            reportTracking.setPiRolodexId(award.getPrincipalInvestigator().getRolodexId());
        }
        reportTracking.setReport(awardTerm.getReport());
        reportTracking.setReportClass(awardTerm.getReportClass());
        reportTracking.setReportClassCode(awardTerm.getReportClassCode());
        reportTracking.setReportCode(awardTerm.getReportCode());
        ReportStatus pending = this.getPendingReportStatus();
        reportTracking.setReportStatus(pending);
        reportTracking.setStatusCode(pending.getReportStatusCode());
        reportTracking.setSponsor(award.getSponsor());
        reportTracking.setSponsorAwardNumber(award.getSponsorAwardNumber());
        reportTracking.setSponsorCode(award.getSponsorCode());
        reportTracking.setTitle(award.getTitle());
        reportTracking.setBaseDate(this.calculateBaseDate(awardTerm));
        return reportTracking;
    }

    protected Date calculateBaseDate(AwardReportTerm awardTerm) {
        Date returnDate = null;
        if (awardTerm != null && awardTerm.getFrequencyBaseCode() != null) {
            if (StringUtils.equalsIgnoreCase((String)awardTerm.getFrequencyBaseCode(), (String)"1")) {
                returnDate = awardTerm.getAward().getAwardExecutionDate();
            } else if (StringUtils.equalsIgnoreCase((String)awardTerm.getFrequencyBaseCode(), (String)"2")) {
                returnDate = awardTerm.getAward().getAwardEffectiveDate();
            } else if (StringUtils.equalsIgnoreCase((String)awardTerm.getFrequencyBaseCode(), (String)"3")) {
                returnDate = awardTerm.getAward().getLastAwardAmountInfo().getObligationExpirationDate();
            } else if (StringUtils.equalsIgnoreCase((String)awardTerm.getFrequencyBaseCode(), (String)"4")) {
                returnDate = awardTerm.getAward().getLastAwardAmountInfo().getFinalExpirationDate();
            } else if (StringUtils.equalsIgnoreCase((String)awardTerm.getFrequencyBaseCode(), (String)"5")) {
                returnDate = awardTerm.getAward().getLastAwardAmountInfo().getCurrentFundEffectiveDate();
            }
        }
        return returnDate;
    }

    protected ReportStatus getPendingReportStatus() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("DESCRIPTION", PENDING_STATUS_DESCRIPTION);
        ReportStatus rs = (ReportStatus)this.getBusinessObjectService().findByPrimaryKey(ReportStatus.class, params);
        return rs;
    }

    private List<ReportTracking> purgePendingReports(AwardReportTerm awardTerm, List<ReportTracking> reportListToClean, List<ReportTracking> deleteReports) {
        ArrayList<ReportTracking> reportTrackingReturn = new ArrayList<ReportTracking>();
        for (ReportTracking rt : reportListToClean) {
            if (StringUtils.equals((String)this.getPendingReportStatus().getReportStatusCode(), (String)rt.getStatusCode()) && awardTerm.getFrequencyBase() != null && StringUtils.equals((String)awardTerm.getFrequencyBase().getReportRegenerationType().getDescription(), (String)ReportRegenerationType.REGEN.getDescription())) {
                deleteReports.add(rt);
                continue;
            }
            reportTrackingReturn.add(rt);
        }
        return reportTrackingReturn;
    }

    private boolean isAwardTermDateAlreadySet(List<ReportTracking> reportTrackings, java.util.Date date) {
        boolean retVal = false;
        if (date == null && reportTrackings.size() > 0) {
            retVal = true;
        }
        if (!retVal) {
            for (ReportTracking rt : reportTrackings) {
                if (rt.getDueDate() == null || rt.getDueDate().getTime() != date.getTime()) continue;
                retVal = true;
            }
        }
        return retVal;
    }

    public List<ReportTracking> getReportTacking(AwardReportTerm awardTerm) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("AWARD_REPORT_TERM_ID", awardTerm.getAwardReportTermId());
        Collection reportTrackingCollection = this.getBusinessObjectService().findMatching(ReportTracking.class, params);
        ArrayList<ReportTracking> reportTrackings = new ArrayList<ReportTracking>();
        reportTrackings.addAll(reportTrackingCollection);
        Collections.sort(reportTrackings);
        return reportTrackings;
    }

    public List<ReportTracking> getReportTacking(Award award) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("AWARD_NUMBER", award.getAwardNumber());
        Collection reportTrackingCollection = this.getBusinessObjectService().findMatching(ReportTracking.class, params);
        ArrayList<ReportTracking> reportTrackings = new ArrayList<ReportTracking>();
        reportTrackings.addAll(reportTrackingCollection);
        Collections.sort(reportTrackings);
        return reportTrackings;
    }

    public boolean autoRegenerateReports(Award award) {
        String rootAwardNumberEnder = "-00001";
        boolean retVal = StringUtils.endsWith((String)award.getAwardNumber(), (String)rootAwardNumberEnder);
        if (!retVal) {
            for (AwardReportTerm term : award.getAwardReportTermItems()) {
                List tracking = this.getReportTacking(term);
                if (tracking.isEmpty()) continue;
                return true;
            }
        }
        return retVal;
    }

    public AwardScheduleGenerationService getAwardScheduleGenerationService() {
        return this.awardScheduleGenerationService;
    }

    public void setAwardScheduleGenerationService(AwardScheduleGenerationService awardScheduleGenerationService) {
        this.awardScheduleGenerationService = awardScheduleGenerationService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public AwardService getAwardService() {
        return this.awardService;
    }

    public void setAwardService(AwardService awardService) {
        this.awardService = awardService;
    }

    public void setReportTrackingListSelected(List<ReportTracking> reportTrackingListing, boolean selectedValue) {
        for (ReportTracking rt : reportTrackingListing) {
            rt.setMultiEditSelected(selectedValue);
        }
    }

    public void updateMultipleReportTrackingRecords(List<ReportTracking> reportTrackingListing, ReportTrackingBean reportTrackingBean) {
        for (ReportTracking rt : reportTrackingListing) {
            if (!rt.getMultiEditSelected()) continue;
            if (StringUtils.isNotBlank((String)reportTrackingBean.getComments())) {
                rt.setComments(reportTrackingBean.getComments());
            }
            if (StringUtils.isNotBlank((String)reportTrackingBean.getPreparerId())) {
                rt.setPreparerId(reportTrackingBean.getPreparerId());
                rt.setPreparerName(reportTrackingBean.getPreparerName());
            }
            if (reportTrackingBean.getActivityDate() != null) {
                rt.setActivityDate(reportTrackingBean.getActivityDate());
            }
            if (!StringUtils.isNotBlank((String)reportTrackingBean.getStatusCode())) continue;
            rt.setStatusCode(reportTrackingBean.getStatusCode());
            rt.setReportStatus(this.getReportStatus(reportTrackingBean.getStatusCode()));
        }
    }

    protected ReportStatus getReportStatus(String statusCode) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("REPORT_STATUS_CODE", statusCode);
        ReportStatus rs = (ReportStatus)this.getBusinessObjectService().findByPrimaryKey(ReportStatus.class, params);
        return rs;
    }

    public boolean shouldAlertReportTrackingDetailChange(Award award) {
        List dbReportTrackings;
        Award dbAward;
        boolean retVal = false;
        if (award.getAwardId() != null && (dbAward = this.getAwardService().getAward(award.getAwardId())) != null && (dbReportTrackings = this.getReportTacking(dbAward)) != null && !dbReportTrackings.isEmpty()) {
            retVal = !this.dateCompare(award.getAwardExecutionDate(), dbAward.getAwardExecutionDate()) || !this.dateCompare(award.getAwardEffectiveDate(), dbAward.getAwardEffectiveDate()) || !this.dateCompare(award.getLastAwardAmountInfo().getObligationExpirationDate(), dbAward.getLastAwardAmountInfo().getObligationExpirationDate()) || !this.dateCompare(award.getLastAwardAmountInfo().getFinalExpirationDate(), dbAward.getLastAwardAmountInfo().getFinalExpirationDate()) || !this.dateCompare(award.getLastAwardAmountInfo().getCurrentFundEffectiveDate(), dbAward.getLastAwardAmountInfo().getCurrentFundEffectiveDate());
        }
        return retVal;
    }

    private boolean dateCompare(Date formDate, Date dbDate) {
        boolean retVal = false;
        if (formDate == null && dbDate == null) {
            retVal = true;
        } else if (formDate != null && dbDate != null && formDate.equals(dbDate)) {
            retVal = true;
        }
        return retVal;
    }
}

