/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.closeout;

import java.io.Serializable;
import java.util.List;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.paymentreports.closeout.AddAwardCloseoutRuleEvent;
import org.kuali.kra.award.paymentreports.closeout.AwardCloseout;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.service.KualiRuleService;

public class AwardCloseoutBean
implements Serializable {
    private static final long serialVersionUID = 7888151034323714279L;
    private AwardCloseout newAwardCloseout;
    private transient KualiRuleService ruleService;
    private AwardForm form;
    private String closeoutReportTypeUserDefined;
    private String closeoutReportTypeFinancialReport;
    private String closeoutReportTypePatent;
    private String closeoutReportTypeTechnical;
    private String closeoutReportTypeProperty;
    private String closeoutReportTypeInvoice;
    private transient ParameterService parameterService;

    public AwardCloseoutBean(AwardForm form) {
        this.form = form;
        this.initializeAwardCloseoutSystemParams();
    }

    private void initializeAwardCloseoutSystemParams() {
        this.setCloseoutReportTypeUserDefined(this.getParameterService().getParameterValueAsString(AwardDocument.class, "closeoutReportTypeUserDefined"));
        this.setCloseoutReportTypeFinancialReport(this.getParameterService().getParameterValueAsString(AwardDocument.class, "closeoutReportTypeFinancialReport"));
        this.setCloseoutReportTypeTechnical(this.getParameterService().getParameterValueAsString(AwardDocument.class, "closeoutReportTypeTechnical"));
        this.setCloseoutReportTypePatent(this.getParameterService().getParameterValueAsString(AwardDocument.class, "closeoutReportTypePatent"));
        this.setCloseoutReportTypeProperty(this.getParameterService().getParameterValueAsString(AwardDocument.class, "closeoutReportTypeProperty"));
        this.setCloseoutReportTypeInvoice(this.getParameterService().getParameterValueAsString(AwardDocument.class, "closeoutReportTypeInvoice"));
        this.getAward().setAwardCloseoutItems(this.getAward().getAwardCloseoutItems());
        this.setNewAwardCloseout(new AwardCloseout());
    }

    public boolean addAwardCloseoutItem() {
        AddAwardCloseoutRuleEvent event = this.generateAddEvent();
        boolean success = this.getRuleService().applyRules((KualiDocumentEvent)event);
        this.getNewAwardCloseout().setCloseoutReportCode(this.getCloseoutReportTypeUserDefined());
        if (success) {
            this.getAward().add(this.getNewAwardCloseout());
            this.init();
        }
        return success;
    }

    public void deleteAwardCloseoutItem(int deletedItemIndex) {
        List items = this.getAward().getAwardCloseoutItems();
        if (deletedItemIndex >= 0 && deletedItemIndex < items.size()) {
            items.remove(deletedItemIndex);
        }
    }

    public void addAwardCloseoutStaticItems(List<KeyValue> keyValues) {
        AwardCloseout awardCloseout = new AwardCloseout();
        for (KeyValue KeyValue2 : keyValues) {
            awardCloseout.setCloseoutReportCode(KeyValue2.getKey().toString());
            awardCloseout.setCloseoutReportName(KeyValue2.getValue());
            this.getAward().addStaticCloseout(awardCloseout);
            awardCloseout = new AwardCloseout();
        }
        this.getAward().orderStaticCloseOutReportItems(this.getAward().getAwardCloseoutItems());
    }

    private AddAwardCloseoutRuleEvent generateAddEvent() {
        AddAwardCloseoutRuleEvent event = new AddAwardCloseoutRuleEvent("awardCloseoutBean.newAwardCloseout", this.getAwardDocument(), this.getAward(), this.getNewAwardCloseout());
        return event;
    }

    public Award getAward() {
        return this.form.getAwardDocument().getAward();
    }

    public AwardDocument getAwardDocument() {
        return this.form.getAwardDocument();
    }

    public Object getData() {
        return this.getNewAwardCloseout();
    }

    public void init() {
        this.newAwardCloseout = new AwardCloseout();
    }

    public KualiRuleService getRuleService() {
        if (this.ruleService == null) {
            this.ruleService = (KualiRuleService)KraServiceLocator.getService(KualiRuleService.class);
        }
        return this.ruleService;
    }

    public void setRuleService(KualiRuleService ruleService) {
        this.ruleService = ruleService;
    }

    public AwardCloseout getNewAwardCloseout() {
        return this.newAwardCloseout;
    }

    public void setNewAwardCloseout(AwardCloseout newAwardCloseout) {
        this.newAwardCloseout = newAwardCloseout;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = (ParameterService)KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public String getCloseoutReportTypeUserDefined() {
        return this.closeoutReportTypeUserDefined;
    }

    public void setCloseoutReportTypeUserDefined(String closeoutReportTypeUserDefined) {
        this.closeoutReportTypeUserDefined = closeoutReportTypeUserDefined;
    }

    public String getCloseoutReportTypeFinancialReport() {
        return this.closeoutReportTypeFinancialReport;
    }

    public void setCloseoutReportTypeFinancialReport(String closeoutReportTypeFinancialReport) {
        this.closeoutReportTypeFinancialReport = closeoutReportTypeFinancialReport;
    }

    public String getCloseoutReportTypePatent() {
        return this.closeoutReportTypePatent;
    }

    public void setCloseoutReportTypePatent(String closeoutReportTypePatent) {
        this.closeoutReportTypePatent = closeoutReportTypePatent;
    }

    public String getCloseoutReportTypeTechnical() {
        return this.closeoutReportTypeTechnical;
    }

    public void setCloseoutReportTypeTechnical(String closeoutReportTypeTechnical) {
        this.closeoutReportTypeTechnical = closeoutReportTypeTechnical;
    }

    public String getCloseoutReportTypeProperty() {
        return this.closeoutReportTypeProperty;
    }

    public void setCloseoutReportTypeProperty(String closeoutReportTypeProperty) {
        this.closeoutReportTypeProperty = closeoutReportTypeProperty;
    }

    public String getCloseoutReportTypeInvoice() {
        return this.closeoutReportTypeInvoice;
    }

    public void setCloseoutReportTypeInvoice(String closeoutReportTypeInvoice) {
        this.closeoutReportTypeInvoice = closeoutReportTypeInvoice;
    }
}

