/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.paymentschedule;

import java.sql.Date;
import java.sql.Timestamp;
import org.kuali.kra.award.AwardAssociate;
import org.kuali.kra.award.paymentreports.ReportStatus;
import org.kuali.kra.bo.KcPerson;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class AwardPaymentSchedule
extends AwardAssociate {
    private static final long serialVersionUID = 1387310207139506329L;
    private Long awardPaymentScheduleId;
    private Date dueDate;
    private KualiDecimal amount;
    private Date submitDate;
    private String submittedBy;
    private String invoiceNumber;
    private String statusDescription;
    private String status;
    private Integer overdue;
    private String lastUpdateUser;
    private Timestamp lastUpdateTimestamp;
    private String reportStatusCode;
    private String submittedByPersonId;
    private KcPerson submittedByPerson;
    private ReportStatus reportStatus;

    public AwardPaymentSchedule() {
    }

    public AwardPaymentSchedule(Date dueDate, String awardNumber, Integer sequenceNumber) {
        this.setAwardNumber(awardNumber);
        this.setSequenceNumber(sequenceNumber);
        this.dueDate = dueDate;
    }

    public Long getAwardPaymentScheduleId() {
        return this.awardPaymentScheduleId;
    }

    public void setAwardPaymentScheduleId(Long awardPaymentScheduleId) {
        this.awardPaymentScheduleId = awardPaymentScheduleId;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public KualiDecimal getAmount() {
        return this.amount;
    }

    public void resetPersistenceState() {
        this.awardPaymentScheduleId = null;
    }

    public void setAmount(KualiDecimal amount) {
        this.amount = amount;
    }

    public Date getSubmitDate() {
        return this.submitDate;
    }

    public void setSubmitDate(Date submitDate) {
        this.submitDate = submitDate;
    }

    public String getSubmittedBy() {
        return this.submittedBy;
    }

    public void setSubmittedBy(String submittedBy) {
        this.submittedBy = submittedBy;
    }

    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.getAwardNumber() == null ? 0 : this.getAwardNumber().hashCode());
        result = 31 * result + (this.dueDate == null ? 0 : this.dueDate.hashCode());
        result = 31 * result + (this.getSequenceNumber() == null ? 0 : this.getSequenceNumber().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwardPaymentSchedule)) {
            return false;
        }
        return this.equals((AwardPaymentSchedule)obj);
    }

    public boolean equals(AwardPaymentSchedule awardPaymentSchedule) {
        if (this.getAwardNumber() == null ? awardPaymentSchedule.getAwardNumber() != null : !this.getAwardNumber().equals(awardPaymentSchedule.getAwardNumber())) {
            return false;
        }
        if (this.dueDate == null ? awardPaymentSchedule.dueDate != null : !this.dueDate.equals(awardPaymentSchedule.dueDate)) {
            return false;
        }
        return !(this.getSequenceNumber() == null ? awardPaymentSchedule.getSequenceNumber() != null : !this.getSequenceNumber().equals(awardPaymentSchedule.getSequenceNumber()));
    }

    public boolean checkForUpdates(AwardPaymentSchedule awardPaymentSchedule) {
        boolean retVal = true;
        if (awardPaymentSchedule == null || !this.objectCompare((Object)this.getAwardPaymentScheduleId(), (Object)awardPaymentSchedule.getAwardPaymentScheduleId())) {
            throw new IllegalArgumentException("The passed in award payment schedule is null, or it has a different AwardPaymentScheduleId than this object.");
        }
        retVal &= this.objectCompare((Object)this.getInvoiceNumber(), (Object)awardPaymentSchedule.getInvoiceNumber());
        retVal &= this.objectCompare((Object)this.getDueDate(), (Object)awardPaymentSchedule.getDueDate());
        retVal &= this.objectCompare((Object)this.getOverdue(), (Object)awardPaymentSchedule.getOverdue());
        retVal &= this.objectCompare((Object)this.getStatusDescription(), (Object)awardPaymentSchedule.getStatusDescription());
        retVal &= this.objectCompare((Object)this.getStatus(), (Object)awardPaymentSchedule.getStatus());
        retVal &= this.objectCompare((Object)this.getAmount(), (Object)awardPaymentSchedule.getAmount());
        retVal &= this.objectCompare((Object)this.getSubmittedBy(), (Object)awardPaymentSchedule.getSubmittedBy());
        return !(retVal &= this.objectCompare((Object)this.getSubmitDate(), (Object)awardPaymentSchedule.getSubmitDate()));
    }

    private boolean objectCompare(Object ob1, Object ob2) {
        boolean retVal = false;
        if (ob1 == null && ob2 == null) {
            retVal = true;
        } else if (ob1 != null && ob2 != null && ob1.equals(ob2)) {
            retVal = true;
        }
        return retVal;
    }

    public Integer getOverdue() {
        return this.overdue;
    }

    public void setOverdue(Integer overdue) {
        this.overdue = overdue;
    }

    public String getLastUpdateUser() {
        return this.lastUpdateUser;
    }

    public void setLastUpdateUser(String lastUpdateUser) {
        this.lastUpdateUser = lastUpdateUser;
    }

    public Timestamp getLastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    public void setLastUpdateTimestamp(Timestamp lastUpdateTimestamp) {
        this.lastUpdateTimestamp = lastUpdateTimestamp;
    }

    public String getReportStatusCode() {
        return this.reportStatusCode;
    }

    public void setReportStatusCode(String reportStatusCode) {
        this.reportStatusCode = reportStatusCode;
    }

    public String getSubmittedByPersonId() {
        return this.submittedByPersonId;
    }

    public void setSubmittedByPersonId(String submittedByPersonId) {
        this.submittedByPersonId = submittedByPersonId;
    }

    public KcPerson getSubmittedByPerson() {
        if (this.submittedByPerson == null && this.getSubmittedByPersonId() != null) {
            this.submittedByPerson = this.getKcPersonService().getKcPersonByPersonId(this.getSubmittedByPersonId());
        }
        return this.submittedByPerson;
    }

    public String getSubmittedByPersonUsername() {
        KcPerson submitter = this.getSubmittedByPerson();
        return submitter == null ? "" : submitter.getUserName();
    }

    public String getSubmittedByPersonFullname() {
        KcPerson submitter = this.getSubmittedByPerson();
        return submitter == null ? "" : submitter.getFullName();
    }

    public ReportStatus getReportStatus() {
        return this.reportStatus;
    }

    public void setReportStatus(ReportStatus reportStatus) {
        this.reportStatus = reportStatus;
    }
}

