/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.specialapproval.approvedequipment;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.award.paymentreports.specialapproval.approvedequipment.AddAwardApprovedEquipmentRuleEvent;
import org.kuali.kra.award.paymentreports.specialapproval.approvedequipment.AwardApprovedEquipment;
import org.kuali.kra.award.paymentreports.specialapproval.approvedequipment.AwardApprovedEquipmentRule;
import org.kuali.kra.award.paymentreports.specialapproval.approvedequipment.AwardApprovedEquipmentRuleEvent;
import org.kuali.kra.award.paymentreports.specialapproval.approvedequipment.MinimumCapitalizationInfo;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardApprovedEquipmentRuleImpl
extends ResearchDocumentRuleBase
implements AwardApprovedEquipmentRule {
    private static final String EQUIPMENT_AMOUNT_PROPERTY = "approvedEquipmentBean.newAwardApprovedEquipment.amount";
    private static final String EQUIPMENT_ITEM_PROPERTY = "approvedEquipmentBean.newAwardApprovedEquipment.item";
    private static final String AMOUNT_ERROR_PARM = "Amount (Amount)";
    private static final String ITEM_ERROR_PARM = "Item (Item)";

    public boolean processAwardApprovedEquipmentBusinessRules(AwardApprovedEquipmentRuleEvent event) {
        return this.processCommonValidations(event);
    }

    public boolean processAddAwardApprovedEquipmentBusinessRules(AddAwardApprovedEquipmentRuleEvent event) {
        return this.areRequiredFieldsComplete(event.getEquipmentItemForValidation()) && this.processCommonValidations((AwardApprovedEquipmentRuleEvent)event);
    }

    private boolean processCommonValidations(AwardApprovedEquipmentRuleEvent event) {
        AwardApprovedEquipment equipmentItem = event.getEquipmentItemForValidation();
        boolean valid = this.isAmountValid(event.getErrorPathPrefix(), equipmentItem, event.getMinimumCapitalization());
        List items = event.getAward().getApprovedEquipmentItems();
        return valid &= this.isUnique(items, equipmentItem);
    }

    boolean isUnique(List<AwardApprovedEquipment> equipmentItems, AwardApprovedEquipment equipmentItem) {
        AwardApprovedEquipment listItem;
        boolean duplicateFound = false;
        Iterator<AwardApprovedEquipment> i$ = equipmentItems.iterator();
        while (i$.hasNext() && !(duplicateFound = equipmentItem != (listItem = i$.next()) && listItem.equals(equipmentItem))) {
        }
        if (duplicateFound && !this.hasDuplicateErrorBeenReported()) {
            this.reportError("approvedEquipmentItems", "error.awardApprovedEquipment.notunique", new String[]{ITEM_ERROR_PARM});
        }
        return !duplicateFound;
    }

    boolean areRequiredFieldsComplete(AwardApprovedEquipment equipmentItem) {
        boolean amountValid;
        boolean itemValid;
        boolean bl = itemValid = !StringUtils.isEmpty((String)equipmentItem.getItem());
        if (!itemValid) {
            this.reportError(EQUIPMENT_ITEM_PROPERTY, "error.required", new String[]{ITEM_ERROR_PARM});
        }
        boolean bl2 = amountValid = equipmentItem.getAmount() != null;
        if (!amountValid) {
            this.reportError(EQUIPMENT_AMOUNT_PROPERTY, "error.required", new String[]{AMOUNT_ERROR_PARM});
        }
        return itemValid && amountValid;
    }

    boolean isAmountValid(String errorPath, AwardApprovedEquipment equipmentItem, MinimumCapitalizationInfo minimumCapitalization) {
        boolean amountValid;
        KualiDecimal amount = equipmentItem.getAmount();
        boolean bl = amountValid = amount != null && amount.doubleValue() >= minimumCapitalization.getAmount();
        if (!amountValid) {
            this.reportSoftError("approvedEquipmentItems", "error.awardApprovedEquipment.amount.invalid", new String[]{String.format("%-12.2f", minimumCapitalization.getAmount()).trim(), minimumCapitalization.getRequirementDriver()});
        } else if (minimumCapitalization.getFederalMinimum() <= amount.doubleValue() && minimumCapitalization.getInstituteMinimum() > amount.doubleValue()) {
            this.reportSoftError("approvedEquipmentItems", "error.awardApprovedEquipment.amount.invalid", new String[]{String.format("%-12.2f", minimumCapitalization.getInstituteMinimum()).trim(), "Institution"});
            amountValid = false;
        } else if (minimumCapitalization.getFederalMinimum() > amount.doubleValue() && minimumCapitalization.getInstituteMinimum() <= amount.doubleValue()) {
            this.reportSoftError("approvedEquipmentItems", "error.awardApprovedEquipment.amount.invalid", new String[]{String.format("%-12.2f", minimumCapitalization.getFederalMinimum()).trim(), "Federal"});
            amountValid = false;
        }
        return true;
    }

    private boolean hasDuplicateErrorBeenReported() {
        return GlobalVariables.getMessageMap().containsMessageKey("error.awardApprovedEquipment.notunique");
    }
}

