/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.specialapproval.approvedequipment;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.paymentreports.specialapproval.approvedequipment.MinimumCapitalizationInfo;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.rice.core.api.config.ConfigurationException;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;

public class EquipmentCapitalizationMinimumLoader
implements Serializable {
    public static final String PARM_TYPE_CODE = "D";
    static final String FEDERAL_CAPITALIZATION_MIN_PARM_NAME = "federalCapitalizationMinimum";
    static final String FEDERAL_REQUIREMENT = "Federal";
    static final String INSTITUTE_CAPITALIZATION_MIN_PARM_NAME = "institutionCapitalizationMinimum";
    static final String INSTITUTION_REQUIREMENT = "Institution";
    private static final String CONFIG_PARM_MISSING_MSG = "Configuration parameter %s is missing";
    private static final String CONFIG_PARM_NOT_NUMERIC_MSG = "Configuration parameter %s is not numeric";
    private ParameterService parameterService;

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = (ParameterService)KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public MinimumCapitalizationInfo getMinimumCapitalization() {
        double federalMinimum = this.getFederalCapitalizationMinimum();
        double institutionMinimum = this.getInstitutionCapitalizationMinimum();
        double minimumCapitalization = Math.max(0.0, Math.min(federalMinimum, institutionMinimum));
        String context = institutionMinimum <= federalMinimum ? INSTITUTION_REQUIREMENT : FEDERAL_REQUIREMENT;
        return new MinimumCapitalizationInfo(context, minimumCapitalization, federalMinimum, institutionMinimum);
    }

    protected String fetchParameterValue(String parmName) {
        return this.getParameterService().getParameterValueAsString(AwardDocument.class, parmName);
    }

    protected double getFederalCapitalizationMinimum() {
        return this.getValueFromParameter(FEDERAL_CAPITALIZATION_MIN_PARM_NAME);
    }

    protected double getInstitutionCapitalizationMinimum() {
        return this.getValueFromParameter(INSTITUTE_CAPITALIZATION_MIN_PARM_NAME);
    }

    double getValueFromParameter(String parmName) {
        String parmValue = this.fetchParameterValue(parmName);
        this.validateParmPresent(parmName, parmValue);
        this.validateParmIsNumber(parmName, parmValue);
        return Double.valueOf(parmValue);
    }

    void validateParmIsNumber(String parmName, String parmValue) {
        if (!NumberUtils.isNumber((String)parmValue)) {
            String msg = String.format(CONFIG_PARM_NOT_NUMERIC_MSG, parmName);
            throw new ConfigurationException(msg);
        }
    }

    void validateParmPresent(String parmName, String parmValue) {
        if (StringUtils.isEmpty((String)parmValue)) {
            String msg = String.format(CONFIG_PARM_MISSING_MSG, parmName);
            throw new ConfigurationException(msg);
        }
    }
}

