/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.permissions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.document.authorization.AwardTask;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.common.permissions.web.struts.form.PermissionsHelperBase;
import org.kuali.kra.infrastructure.AwardRoleConstants;
import org.kuali.kra.infrastructure.AwardTaskNames;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.KraAuthorizationService;

public class PermissionsHelper
extends PermissionsHelperBase {
    private static final String AGGREGATOR_NAME = "Aggregator";
    private static final String VIEWER_NAME = "Viewer";
    private static final String UNASSIGNED_NAME = "unassigned";
    private AwardForm form;
    private Map<String, String> displayNameMap = null;

    public PermissionsHelper(AwardForm form) {
        super("KC-AWARD");
        this.form = form;
    }

    private void buildDisplayNameMap() {
        if (this.displayNameMap == null) {
            this.displayNameMap = new HashMap();
            this.displayNameMap.put(AwardRoleConstants.AWARD_MODIFIER.getAwardRole(), AGGREGATOR_NAME);
            this.displayNameMap.put(AwardRoleConstants.AWARD_VIEWER.getAwardRole(), VIEWER_NAME);
            this.displayNameMap.put(AwardRoleConstants.AWARD_UNASSIGNED.getAwardRole(), UNASSIGNED_NAME);
        }
    }

    private Award getAward() {
        AwardDocument document = this.form.getAwardDocument();
        if (document == null || document.getAward() == null) {
            throw new IllegalArgumentException("invalid (null) AWARDDocument in AWARDForm");
        }
        return document.getAward();
    }

    public String getUnassignedRoleName() {
        return AwardRoleConstants.AWARD_UNASSIGNED.getAwardRole();
    }

    protected boolean isStandardRoleName(String roleName) {
        return StringUtils.equals((String)roleName, (String)AwardRoleConstants.AWARD_MODIFIER.getAwardRole()) || StringUtils.equals((String)roleName, (String)AwardRoleConstants.AWARD_VIEWER.getAwardRole());
    }

    protected String getRoleDisplayName(String roleName) {
        this.buildDisplayNameMap();
        String displayName = (String)this.displayNameMap.get(roleName);
        if (displayName == null) {
            displayName = roleName;
        }
        return displayName;
    }

    protected List<KcPerson> getPersonsInRole(String roleName) {
        KraAuthorizationService kraAuthService = (KraAuthorizationService)KraServiceLocator.getService(KraAuthorizationService.class);
        return kraAuthService.getPersonsInRole((Permissionable)this.getAward(), roleName);
    }

    public boolean canModifyPermissions() {
        AwardTask task = new AwardTask(AwardTaskNames.MODIFY_AWARD_ROLES.getAwardTaskName(), this.getAward());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), (Task)task);
    }

    public boolean getMaintainAwardReportTracking() {
        AwardTask task = new AwardTask(AwardTaskNames.MAINTAIN_REPORT_TRACKING.getAwardTaskName(), this.getAward());
        return this.getTaskAuthorizationService().isAuthorized(this.getUserIdentifier(), (Task)task);
    }
}

