/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.printing.service.impl;

import java.util.Map;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardTemplate;
import org.kuali.kra.award.printing.AwardPrintType;
import org.kuali.kra.award.printing.print.AwardBudgetHierarchyPrint;
import org.kuali.kra.award.printing.print.AwardBudgetHistoryTransactionPrint;
import org.kuali.kra.award.printing.print.AwardDeltaPrint;
import org.kuali.kra.award.printing.print.AwardNoticePrint;
import org.kuali.kra.award.printing.print.AwardTemplatePrint;
import org.kuali.kra.award.printing.print.MoneyAndEndDatesHistoryPrint;
import org.kuali.kra.award.printing.service.AwardPrintingService;
import org.kuali.kra.award.printing.service.impl.AwardPrintingServiceImpl;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.printing.Printable;
import org.kuali.kra.printing.PrintingException;
import org.kuali.kra.printing.service.PrintingService;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;

public class AwardPrintingServiceImpl
implements AwardPrintingService {
    private AwardDeltaPrint awardDeltaPrint;
    private AwardNoticePrint awardNoticePrint;
    private AwardTemplatePrint awardTemplatePrint;
    private MoneyAndEndDatesHistoryPrint moneyAndEndDatesHistoryPrint;
    private AwardBudgetHierarchyPrint awardBudgetHierarchyPrint;
    private AwardBudgetHistoryTransactionPrint awardBudgetHistoryTransactionPrint;
    private PrintingService printingService;

    public AttachmentDataSource printAwardReport(KraPersistableBusinessObjectBase printableBO, AwardPrintType awardReportType, Map<String, Object> reportParameters) throws PrintingException {
        AttachmentDataSource source = null;
        AwardDeltaPrint printable = null;
        String repoprtFileNamePrefix = "";
        switch (1.$SwitchMap$org$kuali$kra$award$printing$AwardPrintType[awardReportType.ordinal()]) {
            case 1: {
                printable = this.getAwardDeltaPrint();
                repoprtFileNamePrefix = ((Award)printableBO).getAwardNumber();
                break;
            }
            case 2: {
                printable = this.getAwardNoticePrint();
                repoprtFileNamePrefix = ((Award)printableBO).getAwardNumber();
                break;
            }
            case 3: {
                printable = this.getMoneyAndEndDatesHistoryPrint();
                repoprtFileNamePrefix = ((Award)printableBO).getAwardNumber();
                break;
            }
            case 4: {
                printable = this.getAwardBudgetHierarchyPrint();
                repoprtFileNamePrefix = ((Award)printableBO).getAwardNumber();
                break;
            }
            case 5: {
                printable = this.getAwardBudgetHistoryTransactionPrint();
                repoprtFileNamePrefix = ((Award)printableBO).getAwardNumber();
                break;
            }
            case 6: {
                printable = this.getAwardTemplatePrint();
                repoprtFileNamePrefix = ((AwardTemplate)printableBO).getTemplateCode().toString();
            }
        }
        if (printable != null) {
            printable.setPrintableBusinessObject(printableBO);
            printable.setReportParameters(reportParameters);
            source = this.getPrintingService().print((Printable)printable);
            source.setFileName(this.getReportName(repoprtFileNamePrefix, awardReportType.getAwardPrintType()));
            source.setContentType("application/pdf");
        }
        return source;
    }

    protected String getReportName(String reportFileNamePrefix, String reportName) {
        StringBuilder reportFullName = new StringBuilder(reportFileNamePrefix).append("_").append(reportName.replace(' ', '_')).append(".pdf");
        return reportFullName.toString();
    }

    public PrintingService getPrintingService() {
        return this.printingService;
    }

    public void setPrintingService(PrintingService printingService) {
        this.printingService = printingService;
    }

    public AwardDeltaPrint getAwardDeltaPrint() {
        return this.awardDeltaPrint;
    }

    public void setAwardDeltaPrint(AwardDeltaPrint awardDeltaPrint) {
        this.awardDeltaPrint = awardDeltaPrint;
    }

    public AwardNoticePrint getAwardNoticePrint() {
        return this.awardNoticePrint;
    }

    public void setAwardNoticePrint(AwardNoticePrint awardNoticePrint) {
        this.awardNoticePrint = awardNoticePrint;
    }

    public AwardTemplatePrint getAwardTemplatePrint() {
        return this.awardTemplatePrint;
    }

    public void setAwardTemplatePrint(AwardTemplatePrint awardTemplatePrint) {
        this.awardTemplatePrint = awardTemplatePrint;
    }

    public MoneyAndEndDatesHistoryPrint getMoneyAndEndDatesHistoryPrint() {
        return this.moneyAndEndDatesHistoryPrint;
    }

    public void setMoneyAndEndDatesHistoryPrint(MoneyAndEndDatesHistoryPrint moneyAndEndDatesHistoryPrint) {
        this.moneyAndEndDatesHistoryPrint = moneyAndEndDatesHistoryPrint;
    }

    public AwardBudgetHierarchyPrint getAwardBudgetHierarchyPrint() {
        return this.awardBudgetHierarchyPrint;
    }

    public void setAwardBudgetHierarchyPrint(AwardBudgetHierarchyPrint awardBudgetHierarchyPrint) {
        this.awardBudgetHierarchyPrint = awardBudgetHierarchyPrint;
    }

    public AwardBudgetHistoryTransactionPrint getAwardBudgetHistoryTransactionPrint() {
        return this.awardBudgetHistoryTransactionPrint;
    }

    public void setAwardBudgetHistoryTransactionPrint(AwardBudgetHistoryTransactionPrint awardBudgetHistoryTransactionPrint) {
        this.awardBudgetHistoryTransactionPrint = awardBudgetHistoryTransactionPrint;
    }
}

