/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.printing.xmlstream;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import noNamespace.AmountInfoType;
import noNamespace.AwardNoticeDocument;
import noNamespace.AwardType;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.printing.AwardPrintType;
import org.kuali.kra.award.printing.xmlstream.AwardBudgetBaseStream;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.service.VersionHistoryService;
import org.kuali.kra.timeandmoney.document.TimeAndMoneyDocument;
import org.kuali.kra.timeandmoney.transactions.AwardAmountTransaction;

public class AwardBudgetHistoryTransaction
extends AwardBudgetBaseStream {
    private static final String AWARD_AMOUNT_INFO_MODIFIED_VALUE = "1";
    private static final String AWARD_NUMBER = "awardNumber";
    private static final String TRANSACTION_ID = "transactionId";
    private VersionHistoryService versionHistoryService;

    public Map<String, XmlObject> generateXmlStream(KraPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        HashMap<String, XmlObject> budgetHierarchyMap = new HashMap<String, XmlObject>();
        Award award = (Award)printableBusinessObject;
        AwardNoticeDocument.AwardNotice awardNotice = AwardNoticeDocument.AwardNotice.Factory.newInstance();
        String awardNumber = this.getAwardNumber(reportParameters);
        Long transactionId = this.getTransactionId(reportParameters);
        if (award != null) {
            awardNotice.setAward(this.getAwardType(award, transactionId, awardNumber));
            awardNotice.setSchoolInfo(this.getSchoolInfoType());
        }
        budgetHierarchyMap.put(AwardPrintType.AWARD_BUDGET_HISTORY_TRANSACTION.getAwardPrintType(), (XmlObject)awardNotice);
        return budgetHierarchyMap;
    }

    private String getAwardNumber(Map<String, Object> reportParameters) {
        String awardNumber = null;
        if (reportParameters.get(AWARD_NUMBER) != null) {
            awardNumber = String.valueOf(reportParameters.get(AWARD_NUMBER));
        }
        return awardNumber;
    }

    private Long getTransactionId(Map<String, Object> reportParameters) {
        Long transactionId = null;
        if (reportParameters.get(TRANSACTION_ID) != null) {
            transactionId = Long.valueOf(String.valueOf(reportParameters.get(TRANSACTION_ID)));
        }
        return transactionId;
    }

    private AwardType getAwardType(Award award, Long transactionId, String awardNumber) {
        AwardType awardType = AwardType.Factory.newInstance();
        awardType.setAwardAmountInfo(this.getAwardAmountInfo(award, transactionId, awardNumber));
        awardType.setAwardTransactionInfo(this.getAwardTransactiontInfo(award));
        return awardType;
    }

    private AwardType.AwardAmountInfo getAwardAmountInfo(Award award, Long transactionId, String awardNumber) {
        AmountInfoType amountInfoType = null;
        AwardType.AwardAmountInfo awardAmountInfo = AwardType.AwardAmountInfo.Factory.newInstance();
        ArrayList<AmountInfoType> amountInfoTypes = new ArrayList<AmountInfoType>();
        for (AwardAmountInfo awardAmount : award.getAwardAmountInfos()) {
            Long transacationIdValue = awardAmount.getTransactionId();
            String awardNumberValue = awardAmount.getAwardNumber();
            if (transactionId != transacationIdValue || !awardNumber.equals(awardNumberValue)) continue;
            amountInfoType = this.setAwardAmountInfo(award, awardAmount, transacationIdValue);
            AwardAmountInfo prevAwardAmount = this.getPrevAwardAmountInfo(award, transactionId, awardNumber);
            this.setAwardAmountInfoModifiedValues(amountInfoType, awardAmount, prevAwardAmount);
            amountInfoTypes.add(amountInfoType);
        }
        awardAmountInfo.setAmountInfoArray(amountInfoTypes.toArray(new AmountInfoType[0]));
        return awardAmountInfo;
    }

    private void setAwardAmountInfoModifiedValues(AmountInfoType amountInfoType, AwardAmountInfo awrdAmountInfo, AwardAmountInfo prevAwardAmount) {
        if (prevAwardAmount != null) {
            if (prevAwardAmount.getAmountObligatedToDate() != awrdAmountInfo.getAmountObligatedToDate()) {
                amountInfoType.setAmtObligatedToDateModified(AWARD_AMOUNT_INFO_MODIFIED_VALUE);
            }
            if (prevAwardAmount.getObliDistributableAmount() != awrdAmountInfo.getObliDistributableAmount()) {
                amountInfoType.setObligatedDistributableAmtModified(AWARD_AMOUNT_INFO_MODIFIED_VALUE);
            }
            if (prevAwardAmount.getAnticipatedTotalAmount() != awrdAmountInfo.getAnticipatedTotalAmount()) {
                amountInfoType.setAnticipatedTotalAmtModified(AWARD_AMOUNT_INFO_MODIFIED_VALUE);
            }
            if (prevAwardAmount.getAntDistributableAmount() != awrdAmountInfo.getAntDistributableAmount()) {
                amountInfoType.setAnticipatedDistributableAmtModified(AWARD_AMOUNT_INFO_MODIFIED_VALUE);
            }
            if (!prevAwardAmount.getObligationExpirationDate().equals(awrdAmountInfo.getObligationExpirationDate())) {
                amountInfoType.setObligationExpDateModified(AWARD_AMOUNT_INFO_MODIFIED_VALUE);
            }
            if (!prevAwardAmount.getCurrentFundEffectiveDate().equals(awrdAmountInfo.getCurrentFundEffectiveDate())) {
                amountInfoType.setCurrentFundEffectiveDateModified(AWARD_AMOUNT_INFO_MODIFIED_VALUE);
            }
            if (!prevAwardAmount.getFinalExpirationDate().equals(awrdAmountInfo.getFinalExpirationDate())) {
                amountInfoType.setFinalExpDateModified(AWARD_AMOUNT_INFO_MODIFIED_VALUE);
            }
        }
    }

    private AwardAmountInfo getPrevAwardAmountInfo(Award award, Long transactionId, String awardNumber) {
        int prevTransactionId = 0;
        List awardAmountTransactions = this.getAwardAmountTransactions(awardNumber);
        boolean transactionIdFound = false;
        for (AwardAmountTransaction timeAndMoneyActionSummary : awardAmountTransactions) {
            if (transactionId == (long)timeAndMoneyActionSummary.getAwardAmountTransactionId().intValue()) {
                transactionIdFound = true;
            }
            if (!transactionIdFound) continue;
            prevTransactionId = timeAndMoneyActionSummary.getAwardAmountTransactionId().intValue();
            break;
        }
        AwardAmountInfo prevAwardAmount = this.getPrevAwardAmountInfo(award, prevTransactionId);
        return prevAwardAmount;
    }

    private AwardAmountInfo getPrevAwardAmountInfo(Award award, int transactionId) {
        AwardAmountInfo awardAmountInfo = null;
        for (AwardAmountInfo awardAmount : award.getAwardAmountInfos()) {
            if (awardAmount.getTransactionId() != (long)transactionId) continue;
            awardAmountInfo = awardAmount;
            break;
        }
        return awardAmountInfo;
    }

    private List<AwardAmountTransaction> getAwardAmountTransactions(String awardNumber) {
        List awardAmountTransactions = null;
        HashMap<String, String> timeAndMoneyMap = new HashMap<String, String>();
        timeAndMoneyMap.put(AWARD_NUMBER, awardNumber);
        List timeAndMoneyList = (List)this.businessObjectService.findMatching(TimeAndMoneyDocument.class, timeAndMoneyMap);
        if (timeAndMoneyList != null && !timeAndMoneyList.isEmpty()) {
            TimeAndMoneyDocument timeAndMoneyDocument = (TimeAndMoneyDocument)timeAndMoneyList.get(0);
            awardAmountTransactions = timeAndMoneyDocument.getAwardAmountTransactions();
        }
        return awardAmountTransactions;
    }

    private AmountInfoType setAwardAmountInfo(Award award, AwardAmountInfo awardAmount, Long transacationIdValue) {
        AmountInfoType amountInfoType = AmountInfoType.Factory.newInstance();
        if (award.getAccountNumber() != null) {
            amountInfoType.setAccountNumber(award.getAccountNumber());
        }
        if (transacationIdValue != null) {
            amountInfoType.setAmountSequenceNumber(transacationIdValue.intValue());
        }
        if (awardAmount.getAmountObligatedToDate() != null) {
            amountInfoType.setAmtObligatedToDate(awardAmount.getAmountObligatedToDate().bigDecimalValue());
        }
        if (awardAmount.getAnticipatedChange() != null) {
            amountInfoType.setAnticipatedChange(awardAmount.getAnticipatedChange().bigDecimalValue());
        }
        if (awardAmount.getAnticipatedChangeDirect() != null) {
            amountInfoType.setAnticipatedChangeDirect(awardAmount.getAnticipatedChangeDirect().bigDecimalValue());
        }
        if (awardAmount.getAnticipatedChangeIndirect() != null) {
            amountInfoType.setAnticipatedChangeIndirect(awardAmount.getAnticipatedChangeIndirect().bigDecimalValue());
        }
        if (awardAmount.getAntDistributableAmount() != null) {
            amountInfoType.setAnticipatedDistributableAmt(awardAmount.getAntDistributableAmount().bigDecimalValue());
        }
        if (awardAmount.getAnticipatedTotalAmount() != null) {
            amountInfoType.setAnticipatedTotalAmt(awardAmount.getAnticipatedTotalAmount().bigDecimalValue());
        }
        if (awardAmount.getAnticipatedTotalDirect() != null) {
            amountInfoType.setAnticipatedTotalDirect(awardAmount.getAnticipatedTotalDirect().bigDecimalValue());
        }
        if (awardAmount.getAnticipatedTotalIndirect() != null) {
            amountInfoType.setAnticipatedTotalIndirect(awardAmount.getAnticipatedTotalIndirect().bigDecimalValue());
        }
        if (award.getAwardNumber() != null) {
            amountInfoType.setAwardNumber(award.getAwardNumber());
        }
        if (awardAmount.getObligationExpirationDate() != null) {
            amountInfoType.setObligationExpirationDate(this.dateTimeService.getCalendar((Date)awardAmount.getObligationExpirationDate()));
        }
        if (awardAmount.getObligatedTotalIndirect() != null) {
            amountInfoType.setObligatedTotalIndirect(awardAmount.getObligatedTotalIndirect().bigDecimalValue());
        }
        if (awardAmount.getObligatedTotalDirect() != null) {
            amountInfoType.setObligatedTotalDirect(awardAmount.getObligatedTotalDirect().bigDecimalValue());
        }
        if (awardAmount.getCurrentFundEffectiveDate() != null) {
            amountInfoType.setCurrentFundEffectiveDate(this.dateTimeService.getCalendar((Date)awardAmount.getCurrentFundEffectiveDate()));
        }
        return amountInfoType;
    }

    public VersionHistoryService getVersionHistoryService() {
        return this.versionHistoryService;
    }

    public void setVersionHistoryService(VersionHistoryService versionHistoryService) {
        this.versionHistoryService = versionHistoryService;
    }
}

